/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tomcat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.Embedded;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tomcat.AbstractI18NMojo;
import org.codehaus.mojo.tomcat.EmbeddedRegistry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRunMojo
extends AbstractI18NMojo {
    private String packaging;
    private File configurationDir;
    private int port;
    private int httpsPort;
    private String uriEncoding;
    private Map<String, String> systemProperties;
    private File additionalConfigFilesDir;
    private File serverXml;
    private File tomcatWebXml;
    private boolean fork;
    private boolean addContextWarDependencies;
    protected MavenProject project;
    private ArchiverManager archiverManager;
    protected boolean useSeparateTomcatClassLoader;
    private List pluginArtifacts;
    private boolean ignorePackaging;
    private String keystoreFile;
    private String keystorePass;
    private Embedded container;
    private ClassRealm tomcatRealm;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isWar()) {
            this.getLog().info((CharSequence)this.getMessage("AbstractRunMojo.nonWar"));
            return;
        }
        ClassLoader originalClassLoaser = Thread.currentThread().getContextClassLoader();
        try {
            if (this.useSeparateTomcatClassLoader) {
                Thread.currentThread().setContextClassLoader((ClassLoader)this.getTomcatClassLoader());
            }
            this.getLog().info((CharSequence)this.getMessage("AbstractRunMojo.runningWar", this.getWebappUrl()));
            this.initConfiguration();
            this.startContainer();
            if (!this.fork) {
                this.waitIndefinitely();
            }
        }
        catch (LifecycleException exception) {
            throw new MojoExecutionException(this.getMessage("AbstractRunMojo.cannotStart"), (Exception)((Object)exception));
        }
        catch (IOException exception) {
            throw new MojoExecutionException(this.getMessage("AbstractRunMojo.cannotCreateConfiguration"), (Exception)exception);
        }
        finally {
            if (this.useSeparateTomcatClassLoader) {
                Thread.currentThread().setContextClassLoader(originalClassLoaser);
            }
        }
    }

    protected String getPath() {
        return this.path;
    }

    protected Context createContext(Embedded container) throws IOException, MojoExecutionException {
        String contextPath = this.getPath();
        Context context = container.createContext("/".equals(contextPath) ? "" : contextPath, this.getDocBase().getAbsolutePath());
        if (this.useSeparateTomcatClassLoader) {
            context.setParentClassLoader((ClassLoader)this.getTomcatClassLoader());
        }
        context.setLoader((Loader)this.createWebappLoader());
        context.setConfigFile(this.getContextFile().getAbsolutePath());
        return context;
    }

    protected WebappLoader createWebappLoader() throws IOException, MojoExecutionException {
        if (this.useSeparateTomcatClassLoader) {
            return new WebappLoader((ClassLoader)this.getTomcatClassLoader());
        }
        return new WebappLoader(Thread.currentThread().getContextClassLoader());
    }

    protected abstract File getDocBase();

    protected abstract File getContextFile();

    protected boolean isWar() {
        return "war".equals(this.packaging) || this.ignorePackaging;
    }

    private URL getWebappUrl() throws MalformedURLException {
        return new URL("http", "localhost", this.port, this.getPath());
    }

    private void initConfiguration() throws IOException, MojoExecutionException {
        if (this.configurationDir.exists()) {
            this.getLog().info((CharSequence)this.getMessage("AbstractRunMojo.usingConfiguration", this.configurationDir));
        } else {
            this.getLog().info((CharSequence)this.getMessage("AbstractRunMojo.creatingConfiguration", this.configurationDir));
            this.configurationDir.mkdirs();
            File confDir = new File(this.configurationDir, "conf");
            confDir.mkdir();
            this.copyFile("/conf/tomcat-users.xml", new File(confDir, "tomcat-users.xml"));
            if (this.tomcatWebXml != null) {
                if (!this.tomcatWebXml.exists()) {
                    throw new MojoExecutionException(" tomcatWebXml " + this.tomcatWebXml.getPath() + " not exists");
                }
                FileUtils.copyFile((File)this.tomcatWebXml, (File)new File(confDir, "web.xml"));
            } else {
                this.copyFile("/conf/web.xml", new File(confDir, "web.xml"));
            }
            File logDir = new File(this.configurationDir, "logs");
            logDir.mkdir();
            File webappsDir = new File(this.configurationDir, "webapps");
            webappsDir.mkdir();
            if (this.additionalConfigFilesDir != null && this.additionalConfigFilesDir.exists()) {
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.addDefaultExcludes();
                scanner.setBasedir(this.additionalConfigFilesDir.getPath());
                scanner.scan();
                String[] files = scanner.getIncludedFiles();
                if (files != null && files.length > 0) {
                    this.getLog().info((CharSequence)"Coping additional tomcat config files");
                    for (int i = 0; i < files.length; ++i) {
                        File file = new File(this.additionalConfigFilesDir, files[i]);
                        this.getLog().info((CharSequence)(" copy " + file.getName()));
                        FileUtils.copyFileToDirectory((File)file, (File)confDir);
                    }
                }
            }
        }
    }

    private void copyFile(String fromPath, File toFile) throws IOException {
        URL fromURL = ((Object)((Object)this)).getClass().getResource(fromPath);
        if (fromURL == null) {
            throw new FileNotFoundException(fromPath);
        }
        FileUtils.copyURLToFile((URL)fromURL, (File)toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startContainer() throws IOException, LifecycleException, MojoExecutionException {
        this.setupSystemProperties();
        if (this.serverXml != null) {
            if (!this.serverXml.exists()) {
                throw new MojoExecutionException(this.serverXml.getPath() + " not exists");
            }
            this.container = new Catalina();
            this.container.setCatalinaHome(this.configurationDir.getAbsolutePath());
            ((Catalina)this.container).setConfigFile(this.serverXml.getPath());
            this.container.start();
        } else {
            this.container = new Embedded();
            this.container.setCatalinaHome(this.configurationDir.getAbsolutePath());
            this.container.setRealm((Realm)new MemoryRealm());
            Context context = this.createContext(this.container);
            String appBase = new File(this.configurationDir, "webapps").getAbsolutePath();
            Host host = this.container.createHost("localHost", appBase);
            host.addChild((Container)context);
            if (this.addContextWarDependencies) {
                Collection<Context> dependecyContexts = this.createDependencyContexts(this.container);
                for (Context extraContext : dependecyContexts) {
                    host.addChild((Container)extraContext);
                }
            }
            Engine engine = this.container.createEngine();
            engine.setName("localEngine");
            engine.addChild((Container)host);
            engine.setDefaultHost(host.getName());
            this.container.addEngine(engine);
            if (this.useSeparateTomcatClassLoader) {
                engine.setParentClassLoader((ClassLoader)this.getTomcatClassLoader());
            }
            Connector httpConnector = this.container.createConnector((InetAddress)null, this.port, false);
            if (this.httpsPort > 0) {
                httpConnector.setRedirectPort(this.httpsPort);
            }
            httpConnector.setURIEncoding(this.uriEncoding);
            this.container.addConnector(httpConnector);
            if (this.httpsPort > 0) {
                Connector httpsConnector = this.container.createConnector((InetAddress)null, this.httpsPort, true);
                if (this.keystoreFile != null) {
                    httpsConnector.setAttribute("keystoreFile", (Object)this.keystoreFile);
                }
                if (this.keystorePass != null) {
                    httpsConnector.setAttribute("keystorePass", (Object)this.keystorePass);
                }
                this.container.addConnector(httpsConnector);
            }
        }
        this.container.start();
        EmbeddedRegistry.getInstance().register(this.container);
    }

    protected ClassRealm getTomcatClassLoader() throws MojoExecutionException {
        if (this.tomcatRealm != null) {
            return this.tomcatRealm;
        }
        try {
            ClassWorld world = new ClassWorld();
            ClassRealm root = world.newRealm("tomcat", Thread.currentThread().getContextClassLoader());
            for (Artifact pluginArtifact : this.pluginArtifacts) {
                if (!"org.apache.tomcat".equals(pluginArtifact.getGroupId()) || pluginArtifact.getFile() == null) continue;
                root.addURL(pluginArtifact.getFile().toURI().toURL());
            }
            this.tomcatRealm = root;
            return root;
        }
        catch (DuplicateRealmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public Set<Artifact> getProjectArtifacts() {
        return this.project.getArtifacts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIndefinitely() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException exception) {
                this.getLog().warn((CharSequence)this.getMessage("AbstractRunMojo.interrupted"), (Throwable)exception);
            }
        }
    }

    private void setupSystemProperties() {
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            this.getLog().info((CharSequence)"setting SystemProperties:");
            for (String key : this.systemProperties.keySet()) {
                String value = this.systemProperties.get(key);
                if (value != null) {
                    this.getLog().info((CharSequence)(" " + key + "=" + value));
                    System.setProperty(key, value);
                    continue;
                }
                this.getLog().info((CharSequence)("skip sysProps " + key + " with empty value"));
            }
        }
    }

    private Collection<Context> createDependencyContexts(Embedded container) {
        this.getLog().info((CharSequence)"Deploying dependency wars");
        ArrayList<Context> contexts = new ArrayList<Context>();
        ScopeArtifactFilter filter = new ScopeArtifactFilter("tomcat");
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!"war".equals(artifact.getType()) || artifact.isOptional() || !filter.include(artifact)) continue;
            this.getLog().info((CharSequence)("Deploy warfile: " + String.valueOf(artifact.getFile())));
            File webapps = new File(this.configurationDir, "webapps");
            File artifactWarDir = new File(webapps, artifact.getArtifactId());
            if (!artifactWarDir.exists()) {
                artifactWarDir.mkdir();
                try {
                    UnArchiver unArchiver = this.archiverManager.getUnArchiver("zip");
                    unArchiver.setSourceFile(artifact.getFile());
                    unArchiver.setDestDirectory(artifactWarDir);
                    unArchiver.extract();
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                    continue;
                }
                catch (NoSuchArchiverException e) {
                    this.getLog().error((Throwable)e);
                    continue;
                }
                catch (ArchiverException e) {
                    this.getLog().error((Throwable)e);
                    continue;
                }
            }
            WebappLoader webappLoader = new WebappLoader(Thread.currentThread().getContextClassLoader());
            Context context = container.createContext("/" + artifact.getArtifactId(), artifactWarDir.getAbsolutePath());
            context.setLoader((Loader)webappLoader);
            context.setConfigFile(this.getContextFile().getAbsolutePath());
            contexts.add(context);
        }
        return contexts;
    }
}

