/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tomcat;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Embedded;
import org.apache.maven.plugin.logging.Log;

public final class EmbeddedRegistry {
    private static EmbeddedRegistry instance;
    private Set<Embedded> containers = new HashSet<Embedded>(1);

    private EmbeddedRegistry() {
    }

    public static EmbeddedRegistry getInstance() {
        if (instance == null) {
            instance = new EmbeddedRegistry();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        EmbeddedRegistry.getInstance().shutdownAll(null);
                    }
                    catch (LifecycleException lifecycleException) {
                        // empty catch block
                    }
                }
            });
        }
        return instance;
    }

    public synchronized boolean register(Embedded container) {
        return this.containers.add(container);
    }

    public synchronized void shutdownAll(Log log) throws LifecycleException {
        LifecycleException firstException = null;
        Iterator<Embedded> iterator = this.containers.iterator();
        while (iterator.hasNext()) {
            Embedded embedded = iterator.next();
            try {
                embedded.stop();
                iterator.remove();
            }
            catch (LifecycleException e) {
                if (firstException == null) {
                    firstException = e;
                    this.error(log, e, "Error while shutting down embedded Tomcat. Will be rethrown.");
                    continue;
                }
                this.error(log, e, "Error while shutting down embedded Tomcat.");
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    private void error(Log log, LifecycleException e, String message) {
        if (log == null) {
            System.err.println("ERROR: " + message);
            e.printStackTrace();
        } else {
            log.error((CharSequence)message, (Throwable)e);
        }
    }
}

