/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.hibernate.integrator.internal.IntegratorServiceImpl;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.BootstrapServiceRegistry;
import org.hibernate.service.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.internal.BootstrapServiceRegistryImpl;

public class BootstrapServiceRegistryBuilder {
    private final LinkedHashSet<Integrator> providedIntegrators = new LinkedHashSet();
    private List<ClassLoader> providedClassLoaders;
    private ClassLoaderService providedClassLoaderService;

    public BootstrapServiceRegistryBuilder with(Integrator integrator) {
        this.providedIntegrators.add(integrator);
        return this;
    }

    @Deprecated
    public BootstrapServiceRegistryBuilder withApplicationClassLoader(ClassLoader classLoader) {
        return this.with(classLoader);
    }

    public BootstrapServiceRegistryBuilder with(ClassLoader classLoader) {
        if (this.providedClassLoaders == null) {
            this.providedClassLoaders = new ArrayList<ClassLoader>();
        }
        this.providedClassLoaders.add(classLoader);
        return this;
    }

    public BootstrapServiceRegistryBuilder with(ClassLoaderService classLoaderService) {
        this.providedClassLoaderService = classLoaderService;
        return this;
    }

    @Deprecated
    public BootstrapServiceRegistryBuilder withResourceClassLoader(ClassLoader classLoader) {
        return this.with(classLoader);
    }

    @Deprecated
    public BootstrapServiceRegistryBuilder withHibernateClassLoader(ClassLoader classLoader) {
        return this.with(classLoader);
    }

    @Deprecated
    public BootstrapServiceRegistryBuilder withEnvironmentClassLoader(ClassLoader classLoader) {
        return this.with(classLoader);
    }

    public BootstrapServiceRegistry build() {
        ClassLoaderService classLoaderService = this.providedClassLoaderService == null ? new ClassLoaderServiceImpl(this.providedClassLoaders) : this.providedClassLoaderService;
        IntegratorServiceImpl integratorService = new IntegratorServiceImpl(this.providedIntegrators, classLoaderService);
        return new BootstrapServiceRegistryImpl(classLoaderService, integratorService);
    }
}

