/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.paths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.paths.Node;

public final class Path
implements Serializable {
    private static final long serialVersionUID = 8895491272907955543L;
    @Nonnull
    final List<Node> nodes = new ArrayList<Node>(4);
    @Nonnull
    private final AtomicInteger executionCount = new AtomicInteger();
    private final boolean shadowed;
    @Nullable
    private Path shadowPath;

    Path(@Nonnull Node.Entry entryNode) {
        this.shadowed = false;
        this.addNode(entryNode);
    }

    Path(@Nonnull Path sharedSubPath, boolean shadowed) {
        this.shadowed = shadowed;
        sharedSubPath.shadowPath = shadowed ? this : null;
        this.nodes.addAll(sharedSubPath.nodes);
    }

    void addNode(@Nonnull Node node) {
        this.nodes.add(node);
    }

    int countExecutionIfAllNodesWereReached(@Nonnull List<Node> nodesReached) {
        boolean allNodesReached = this.nodes.equals(nodesReached);
        if (allNodesReached) {
            return this.executionCount.getAndIncrement();
        }
        return -1;
    }

    public boolean isShadowed() {
        return this.shadowed;
    }

    @Nonnull
    public List<Node> getNodes() {
        return this.nodes;
    }

    public int getExecutionCount() {
        int count = this.executionCount.get();
        if (this.shadowPath != null) {
            count += this.shadowPath.executionCount.get();
        }
        return count;
    }

    void addCountFromPreviousTestRun(@Nonnull Path previousPath) {
        int currentExecutionCount = this.executionCount.get();
        int previousExecutionCount = previousPath.executionCount.get();
        this.executionCount.set(currentExecutionCount + previousExecutionCount);
    }

    void reset() {
        this.executionCount.set(0);
    }
}

