/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.testRedundancy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TestCoverage {
    @Nonnull
    public static final TestCoverage INSTANCE = new TestCoverage();
    @Nonnull
    private final Map<Method, Integer> testsToItemsCovered = new LinkedHashMap<Method, Integer>();
    @Nullable
    private Method currentTestMethod;

    private TestCoverage() {
    }

    public void setCurrentTestMethod(@Nullable Method testMethod) {
        if (testMethod != null) {
            this.testsToItemsCovered.put(testMethod, 0);
        }
        this.currentTestMethod = testMethod;
    }

    public void recordNewItemCoveredByTestIfApplicable(int previousExecutionCount) {
        if (previousExecutionCount == 0 && this.currentTestMethod != null) {
            Integer itemsCoveredByTest = this.testsToItemsCovered.get(this.currentTestMethod);
            this.testsToItemsCovered.put(this.currentTestMethod, itemsCoveredByTest == null ? 1 : itemsCoveredByTest + 1);
        }
    }

    @Nonnull
    public List<Method> getRedundantTests() {
        ArrayList<Method> redundantTests = new ArrayList<Method>();
        for (Map.Entry<Method, Integer> testAndItemsCovered : this.testsToItemsCovered.entrySet()) {
            Method testMethod = testAndItemsCovered.getKey();
            Integer itemsCovered = testAndItemsCovered.getValue();
            if (itemsCovered != 0) continue;
            redundantTests.add(testMethod);
        }
        return redundantTests;
    }
}

