/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit5;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Capturing;
import mockit.Injectable;
import mockit.Mocked;
import mockit.integration.internal.TestRunnerDecorator;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.FieldReflection;
import mockit.internal.util.StackTrace;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

final class JMockitExtension
extends TestRunnerDecorator
implements BeforeAllCallback,
AfterAllCallback,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver,
TestExecutionExceptionHandler {
    @Nonnull
    private final Field indexField;
    @Nullable
    private SavePoint savePointForTestClass;
    @Nullable
    private SavePoint savePointForTest;
    @Nullable
    private SavePoint savePointForTestMethod;
    @Nullable
    private Throwable thrownByTest;
    @Nullable
    private Object[] mockParameters;

    JMockitExtension() {
        try {
            this.indexField = Parameter.class.getDeclaredField("index");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void beforeAll(ContainerExtensionContext context) {
        this.savePointForTestClass = new SavePoint();
        Class testClass = (Class)context.getTestClass().get();
        TestRun.setCurrentTestClass(testClass);
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        TestRun.enterNoMockingZone();
        try {
            JMockitExtension.handleMockFieldsForWholeTestClass(testInstance);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
        TestRun.setRunningIndividualTest(testInstance);
    }

    public void beforeEach(TestExtensionContext context) {
        Object testInstance = context.getTestInstance();
        TestRun.prepareForNextTest();
        TestRun.enterNoMockingZone();
        try {
            this.savePointForTest = new SavePoint();
            JMockitExtension.createInstancesForTestedFields(testInstance, true);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTestExecution(TestExtensionContext context) {
        Method method = (Method)context.getTestMethod().get();
        Object testInstance = context.getTestInstance();
        TestRun.enterNoMockingZone();
        try {
            this.savePointForTestMethod = new SavePoint();
            this.mockParameters = JMockitExtension.createInstancesForMockParameters(method, null);
            JMockitExtension.createInstancesForTestedFields(testInstance, false);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
        TestRun.setRunningIndividualTest(testInstance);
    }

    public boolean supports(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        return parameter.isAnnotationPresent(Mocked.class) || parameter.isAnnotationPresent(Injectable.class) || parameter.isAnnotationPresent(Capturing.class);
    }

    public Object resolve(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        Integer parameterIndex = (Integer)FieldReflection.getFieldValue(this.indexField, parameter);
        return this.mockParameters[parameterIndex];
    }

    public void handleTestExecutionException(TestExtensionContext context, Throwable throwable) throws Throwable {
        this.thrownByTest = throwable;
        throw throwable;
    }

    public void afterTestExecution(TestExtensionContext context) {
        TestRun.enterNoMockingZone();
        try {
            assert (this.savePointForTestMethod != null);
            this.savePointForTestMethod.rollback();
            this.savePointForTestMethod = null;
            if (this.thrownByTest != null) {
                StackTrace.filterStackTrace(this.thrownByTest);
            }
            Error expectationsFailure = RecordAndReplayExecution.endCurrentReplayIfAny();
            JMockitExtension.clearTestedFieldsIfAny();
            if (expectationsFailure != null) {
                StackTrace.filterStackTrace(expectationsFailure);
                throw expectationsFailure;
            }
        }
        finally {
            TestRun.finishCurrentTestExecution();
            TestRun.exitNoMockingZone();
        }
    }

    public void afterEach(TestExtensionContext context) {
        assert (this.savePointForTest != null);
        this.savePointForTest.rollback();
        this.savePointForTest = null;
    }

    public void afterAll(ContainerExtensionContext context) {
        assert (this.savePointForTestClass != null);
        this.savePointForTestClass.rollback();
        this.savePointForTestClass = null;
        JMockitExtension.clearFieldTypeRedefinitions();
        TestRun.setCurrentTestClass(null);
    }
}

