/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.InvocationHandler;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.mocking.MockedBridge;
import mockit.internal.mockups.MockMethodBridge;
import mockit.internal.mockups.MockupBridge;
import mockit.internal.startup.InstrumentationHolder;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.StackTrace;

public abstract class MockingBridge
implements InvocationHandler {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static boolean fieldsSet;
    public final String id;

    protected MockingBridge(@Nonnull String id) {
        this.id = id;
    }

    protected static boolean notToBeMocked(@Nullable Object mocked, @Nonnull String mockedClassDesc) {
        return (mocked == null && "java/lang/System".equals(mockedClassDesc) || mocked != null && MockingBridge.instanceOfClassThatParticipatesInClassLoading(mocked.getClass())) && MockingBridge.wasCalledDuringClassLoading();
    }

    public static boolean instanceOfClassThatParticipatesInClassLoading(@Nonnull Class<?> mockedClass) {
        return mockedClass == System.class || mockedClass == File.class || mockedClass == URL.class || mockedClass == FileInputStream.class || mockedClass == Manifest.class || JarFile.class.isAssignableFrom(mockedClass) || JarEntry.class.isAssignableFrom(mockedClass) || Vector.class.isAssignableFrom(mockedClass) || Hashtable.class.isAssignableFrom(mockedClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean wasCalledDuringClassLoading() {
        if (LOCK.isHeldByCurrentThread()) {
            return true;
        }
        LOCK.lock();
        try {
            StackTrace st = new StackTrace(new Throwable());
            int n = st.getDepth();
            for (int i = 3; i < n; ++i) {
                StackTraceElement ste = st.getElement(i);
                if (!"ClassLoader.java".equals(ste.getFileName()) || !"loadClass getResource loadLibrary".contains(ste.getMethodName())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            LOCK.unlock();
        }
    }

    @Nonnull
    protected static Object[] extractMockArguments(int startingIndex, @Nonnull Object[] args) {
        if (args.length > startingIndex) {
            Object[] mockArgs = new Object[args.length - startingIndex];
            System.arraycopy(args, startingIndex, mockArgs, 0, mockArgs.length);
            return mockArgs;
        }
        return EMPTY_ARGS;
    }

    public static void setMockingBridgeFields() {
        Class hostClass = ClassLoad.loadByInternalName(InstrumentationHolder.hostJREClassName);
        MockingBridge.setMockingBridgeField(hostClass, MockedBridge.MB);
        MockingBridge.setMockingBridgeField(hostClass, MockupBridge.MB);
        MockingBridge.setMockingBridgeField(hostClass, MockMethodBridge.MB);
    }

    private static void setMockingBridgeField(@Nonnull Class<?> hostClass, @Nonnull MockingBridge mockingBridge) {
        try {
            hostClass.getDeclaredField(mockingBridge.id).set(null, mockingBridge);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static String getHostClassName() {
        if (!fieldsSet) {
            MockingBridge.setMockingBridgeFields();
            fieldsSet = true;
        }
        return InstrumentationHolder.hostJREClassName;
    }
}

