/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.MethodVisitor;
import mockit.internal.ClassFile;
import mockit.internal.util.VisitInterruptedException;

final class SuperConstructorCollector
extends ClassVisitor {
    @Nonnull
    static final SuperConstructorCollector INSTANCE = new SuperConstructorCollector();
    @Nonnull
    private final Map<String, String> cache = new HashMap<String, String>();
    @Nullable
    private String constructorDesc;
    private boolean samePackage;

    private SuperConstructorCollector() {
    }

    @Nonnull
    synchronized String findConstructor(@Nonnull String classDesc, @Nonnull String superClassDesc) {
        this.constructorDesc = this.cache.get(superClassDesc);
        if (this.constructorDesc != null) {
            return this.constructorDesc;
        }
        this.findIfBothClassesAreInSamePackage(classDesc, superClassDesc);
        ClassReader cr = ClassFile.readFromFile(superClassDesc);
        try {
            cr.accept(this, 6);
        }
        catch (VisitInterruptedException visitInterruptedException) {
            // empty catch block
        }
        this.cache.put(superClassDesc, this.constructorDesc);
        return this.constructorDesc;
    }

    private void findIfBothClassesAreInSamePackage(@Nonnull String classDesc, @Nonnull String superClassDesc) {
        int p2;
        int p1 = classDesc.lastIndexOf(47);
        this.samePackage = p1 == (p2 = superClassDesc.lastIndexOf(47)) && (p1 < 0 || classDesc.substring(0, p1).equals(superClassDesc.substring(0, p2)));
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if (this.isAccessible(access) && "<init>".equals(name)) {
            this.constructorDesc = desc;
            throw VisitInterruptedException.INSTANCE;
        }
        return null;
    }

    private boolean isAccessible(int access) {
        return access != 2 && (access != 0 || this.samePackage);
    }
}

