/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.UnexpectedInvocation;
import mockit.internal.expectations.invocation.ExpectedInvocation;

public final class InvocationConstraints {
    public int minInvocations;
    private int maxInvocations;
    public int invocationCount;

    public InvocationConstraints(boolean strictInvocation, boolean nonStrictInvocation) {
        this.setLimits(nonStrictInvocation ? 0 : 1, strictInvocation ? 1 : -1);
    }

    public void setLimits(int minInvocations, int maxInvocations) {
        this.minInvocations = minInvocations;
        this.maxInvocations = maxInvocations;
    }

    void adjustMaxInvocations(int expectedInvocationCount) {
        if (this.maxInvocations > 0 && this.maxInvocations < expectedInvocationCount) {
            this.maxInvocations = expectedInvocationCount;
        }
    }

    void setUnlimitedMaxInvocations() {
        this.maxInvocations = -1;
    }

    public void incrementInvocationCount() {
        ++this.invocationCount;
    }

    public boolean isInvocationCountAtMaximumAllowed() {
        return this.invocationCount == this.maxInvocations;
    }

    public boolean isInvocationCountLessThanMinimumExpected() {
        return this.invocationCount < this.minInvocations;
    }

    public boolean isInvocationCountMoreThanMaximumExpected() {
        return this.maxInvocations >= 0 && this.invocationCount > this.maxInvocations;
    }

    public boolean isInvocationCountInExpectedRange() {
        return this.minInvocations <= this.invocationCount && (this.invocationCount <= this.maxInvocations || this.maxInvocations < 0);
    }

    @Nullable
    public Error verifyLowerLimit(@Nonnull ExpectedInvocation invocation, int lowerLimit) {
        if (this.invocationCount < lowerLimit) {
            int missingInvocations = lowerLimit - this.invocationCount;
            return invocation.errorForMissingInvocations(missingInvocations, Collections.<ExpectedInvocation>emptyList());
        }
        return null;
    }

    @Nullable
    public Error verifyUpperLimit(@Nonnull ExpectedInvocation invocation, @Nonnull Object[] replayArgs, int upperLimit) {
        int unexpectedInvocations;
        if (upperLimit >= 0 && (unexpectedInvocations = this.invocationCount - upperLimit) > 0) {
            UnexpectedInvocation error = invocation.errorForUnexpectedInvocations(replayArgs, unexpectedInvocations);
            return error;
        }
        return null;
    }

    @Nonnull
    public Error errorForMissingExpectations(@Nonnull ExpectedInvocation invocation, @Nonnull List<ExpectedInvocation> nonMatchingInvocations) {
        return invocation.errorForMissingInvocations(this.minInvocations - this.invocationCount, nonMatchingInvocations);
    }
}

