/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.Type;
import mockit.internal.expectations.mocking.CaptureOfNewInstances;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TypeRedefinition;
import mockit.internal.expectations.mocking.TypeRedefinitions;
import mockit.internal.state.TestRun;

public final class ParameterTypeRedefinitions
extends TypeRedefinitions {
    @Nonnull
    private final java.lang.reflect.Type[] paramTypes;
    @Nonnull
    private final Annotation[][] paramAnnotations;
    @Nonnull
    private final Object[] paramValues;
    @Nonnull
    private final MockedType[] mockParameters;
    @Nonnull
    private final List<MockedType> injectableParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterTypeRedefinitions(@Nonnull Method testMethod, @Nullable Object[] parameterValues) {
        TestRun.enterNoMockingZone();
        try {
            this.paramTypes = testMethod.getGenericParameterTypes();
            this.paramAnnotations = testMethod.getParameterAnnotations();
            int n = this.paramTypes.length;
            this.paramValues = parameterValues == null || parameterValues.length != n ? new Object[n] : parameterValues;
            this.mockParameters = new MockedType[n];
            this.injectableParameters = new ArrayList<MockedType>(n);
            String testClassDesc = Type.getInternalName(testMethod.getDeclaringClass());
            String testMethodDesc = testMethod.getName() + Type.getMethodDescriptor(testMethod);
            for (int i = 0; i < n; ++i) {
                this.getMockedTypeFromMockParameterDeclaration(testClassDesc, testMethodDesc, i);
            }
            InstanceFactory[] instanceFactories = this.redefineMockedTypes();
            this.instantiateMockedTypes(instanceFactories);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    private void getMockedTypeFromMockParameterDeclaration(@Nonnull String testClassDesc, @Nonnull String testMethodDesc, int paramIndex) {
        MockedType mockedType;
        java.lang.reflect.Type paramType = this.paramTypes[paramIndex];
        Annotation[] annotationsOnParameter = this.paramAnnotations[paramIndex];
        this.mockParameters[paramIndex] = mockedType = new MockedType(testClassDesc, testMethodDesc, paramIndex, paramType, annotationsOnParameter);
        if (mockedType.injectable) {
            this.injectableParameters.add(mockedType);
            this.paramValues[paramIndex] = mockedType.providedValue;
        }
    }

    @Nonnull
    private InstanceFactory[] redefineMockedTypes() {
        int n = this.mockParameters.length;
        InstanceFactory[] instanceFactories = new InstanceFactory[n];
        for (int i = 0; i < n; ++i) {
            MockedType mockedType = this.mockParameters[i];
            if (!mockedType.isMockableType()) continue;
            instanceFactories[i] = this.redefineMockedType(mockedType);
        }
        return instanceFactories;
    }

    @Nullable
    private InstanceFactory redefineMockedType(@Nonnull MockedType mockedType) {
        TypeRedefinition typeRedefinition = new TypeRedefinition(mockedType);
        InstanceFactory instanceFactory = typeRedefinition.redefineType();
        if (instanceFactory != null) {
            this.addTargetClass(mockedType);
        }
        return instanceFactory;
    }

    private void registerCaptureOfNewInstances(@Nonnull MockedType mockedType, @Nonnull Object originalInstance) {
        if (this.captureOfNewInstances == null) {
            this.captureOfNewInstances = new CaptureOfNewInstances();
        }
        this.captureOfNewInstances.registerCaptureOfNewInstances(mockedType, originalInstance);
        this.captureOfNewInstances.makeSureAllSubtypesAreModified(mockedType);
    }

    private void instantiateMockedTypes(@Nonnull InstanceFactory[] instanceFactories) {
        for (int i = 0; i < instanceFactories.length; ++i) {
            Object mockedInstance;
            InstanceFactory instanceFactory = instanceFactories[i];
            if (instanceFactory == null) continue;
            MockedType mockedType = this.mockParameters[i];
            this.paramValues[i] = mockedInstance = this.instantiateMockedType(mockedType, instanceFactory);
            mockedType.providedValue = mockedInstance;
        }
    }

    @Nonnull
    private Object instantiateMockedType(@Nonnull MockedType mockedType, @Nonnull InstanceFactory instanceFactory) {
        Object mock = instanceFactory.create();
        ParameterTypeRedefinitions.registerMock(mockedType, mock);
        if (mockedType.withInstancesToCapture()) {
            this.registerCaptureOfNewInstances(mockedType, mock);
        }
        return mock;
    }

    @Nonnull
    public List<MockedType> getInjectableParameters() {
        return this.injectableParameters;
    }

    @Nonnull
    public Object[] getParameterValues() {
        return this.paramValues;
    }
}

