/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.Type;
import mockit.internal.expectations.transformation.ActiveInvocations;
import mockit.internal.expectations.transformation.InvocationBlockModifier;

final class ArgumentCapturing {
    @Nonnull
    private final InvocationBlockModifier modifier;
    @Nullable
    private List<InvocationBlockModifier.Capture> captures;
    private boolean parameterForCapture;
    @Nullable
    private String capturedTypeDesc;
    private boolean capturesFound;

    ArgumentCapturing(@Nonnull InvocationBlockModifier modifier) {
        this.modifier = modifier;
    }

    boolean registerMatcher(boolean withCaptureMethod, @Nonnull String methodDesc, int lastLoadedVarIndex) {
        if (withCaptureMethod && "(Ljava/lang/Object;)Ljava/util/List;".equals(methodDesc)) {
            return false;
        }
        if (withCaptureMethod) {
            if (methodDesc.contains("List")) {
                if (lastLoadedVarIndex > 0) {
                    InvocationBlockModifier invocationBlockModifier = this.modifier;
                    invocationBlockModifier.getClass();
                    InvocationBlockModifier.Capture capture = new InvocationBlockModifier.Capture(invocationBlockModifier, lastLoadedVarIndex);
                    this.addCapture(capture);
                }
                this.parameterForCapture = false;
            } else {
                this.parameterForCapture = true;
            }
        } else {
            this.parameterForCapture = false;
        }
        return true;
    }

    void registerTypeToCaptureIfApplicable(int opcode, @Nonnull String typeDesc) {
        if (opcode == 192 && this.parameterForCapture) {
            this.capturedTypeDesc = typeDesc;
        }
    }

    void registerTypeToCaptureIntoListIfApplicable(int varIndex, @Nonnull String signature) {
        if (signature.startsWith("Ljava/util/List<")) {
            String typeDesc = signature.substring(16, signature.length() - 2);
            int p = typeDesc.indexOf(60);
            if (p > 0) {
                typeDesc = typeDesc.substring(0, p) + ';';
            }
            Type type = Type.getType(typeDesc);
            ActiveInvocations.varIndexToTypeDesc.put(varIndex, type.getInternalName());
        }
    }

    void registerAssignmentToCaptureVariableIfApplicable(int opcode, int varIndex) {
        if (opcode >= 54 && opcode <= 58 && this.parameterForCapture) {
            InvocationBlockModifier invocationBlockModifier = this.modifier;
            invocationBlockModifier.getClass();
            InvocationBlockModifier.Capture capture = new InvocationBlockModifier.Capture(invocationBlockModifier, opcode, varIndex, this.capturedTypeDesc);
            this.addCapture(capture);
            this.parameterForCapture = false;
            this.capturedTypeDesc = null;
        }
    }

    private void addCapture(@Nonnull InvocationBlockModifier.Capture capture) {
        if (this.captures == null) {
            this.captures = new ArrayList<InvocationBlockModifier.Capture>();
            this.capturesFound = true;
        }
        this.captures.add(capture);
    }

    void updateCaptureIfAny(int originalIndex, int newIndex) {
        if (this.captures != null) {
            InvocationBlockModifier.Capture capture;
            for (int i = this.captures.size() - 1; i >= 0 && !(capture = this.captures.get(i)).fixParameterIndex(originalIndex, newIndex); --i) {
            }
        }
    }

    void generateCallsToSetArgumentTypesToCaptureIfAny() {
        if (this.captures != null) {
            for (InvocationBlockModifier.Capture capture : this.captures) {
                capture.generateCallToSetArgumentTypeIfNeeded();
            }
        }
    }

    void generateCallsToCaptureMatchedArgumentsIfPending() {
        if (this.captures != null) {
            for (InvocationBlockModifier.Capture capture : this.captures) {
                capture.generateCodeToStoreCapturedValue();
            }
            this.captures = null;
        }
    }

    boolean hasCaptures() {
        return this.capturesFound;
    }
}

