/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.injection.FieldToInject;
import mockit.internal.injection.FullInjection;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionPointProvider;
import mockit.internal.injection.Injector;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.TestedField;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.FieldReflection;

final class FieldInjection
extends Injector {
    private static final Pattern TYPE_NAME = Pattern.compile("class |interface |java\\.lang\\.");
    boolean requireDIAnnotation;
    @Nonnull
    Class<?> targetClass;
    private Field targetField;

    FieldInjection(@Nonnull TestedField testedField, @Nonnull TestedClass testedClass, @Nullable FullInjection fullInjection) {
        super(testedClass, testedField.injectionState, fullInjection);
        this.requireDIAnnotation = testedField.requireDIAnnotation;
        this.targetClass = testedClass.targetClass;
    }

    @Nonnull
    List<Field> findAllTargetInstanceFieldsInTestedClassHierarchy(@Nonnull Class<?> actualTestedClass) {
        this.requireDIAnnotation = false;
        ArrayList<Field> targetFields = new ArrayList<Field>();
        Class<?> classWithFields = actualTestedClass;
        do {
            this.addEligibleFields(targetFields, classWithFields);
        } while (this.testedClass.isClassFromSameModuleOrSystemAsTestedClass(classWithFields = classWithFields.getSuperclass()) || InjectionPoint.isServlet(classWithFields));
        return targetFields;
    }

    private void addEligibleFields(@Nonnull List<Field> targetFields, @Nonnull Class<?> classWithFields) {
        Field[] fields;
        for (Field field : fields = classWithFields.getDeclaredFields()) {
            if (!this.isEligibleForInjection(field)) continue;
            targetFields.add(field);
        }
    }

    private boolean isEligibleForInjection(@Nonnull Field field) {
        boolean annotated;
        int modifiers = field.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            return false;
        }
        boolean bl = annotated = InjectionPoint.isAnnotated(field) != InjectionPoint.KindOfInjectionPoint.NotAnnotated;
        if (annotated) {
            this.requireDIAnnotation = true;
            return true;
        }
        return !Modifier.isStatic(modifiers) && !Modifier.isVolatile(modifiers);
    }

    void injectIntoEligibleFields(@Nonnull List<Field> targetFields, @Nonnull Object testedObject) {
        this.targetClass = testedObject.getClass();
        Iterator<Field> iterator = targetFields.iterator();
        while (iterator.hasNext()) {
            Object injectableValue;
            Field field;
            this.targetField = field = iterator.next();
            if (!this.targetFieldWasNotAssignedByConstructor(testedObject) || (injectableValue = this.getValueForFieldIfAvailable(targetFields)) == null || injectableValue == InjectionPointProvider.NULL) continue;
            injectableValue = InjectionPoint.wrapInProviderIfNeeded(field.getGenericType(), injectableValue);
            FieldReflection.setFieldValue(field, testedObject, injectableValue);
        }
    }

    private boolean targetFieldWasNotAssignedByConstructor(@Nonnull Object testedObject) {
        if (InjectionPoint.isAnnotated(this.targetField) != InjectionPoint.KindOfInjectionPoint.NotAnnotated) {
            return true;
        }
        Object fieldValue = FieldReflection.getFieldValue(this.targetField, testedObject);
        if (fieldValue == null) {
            return true;
        }
        Class<?> fieldType = this.targetField.getType();
        if (!fieldType.isPrimitive()) {
            return false;
        }
        Object defaultValue = DefaultValues.defaultValueForPrimitiveType(fieldType);
        return fieldValue.equals(defaultValue);
    }

    @Nullable
    private Object getValueForFieldIfAvailable(@Nonnull List<Field> targetFields) {
        String qualifiedFieldName = InjectionPoint.getQualifiedName(this.targetField.getDeclaredAnnotations());
        InjectionPointProvider mockedType = this.findAvailableInjectableIfAny(targetFields, qualifiedFieldName);
        if (mockedType != null) {
            return this.injectionState.getValueToInject(mockedType);
        }
        InjectionPoint.KindOfInjectionPoint kindOfInjectionPoint = InjectionPoint.isAnnotated(this.targetField);
        if (this.fullInjection != null) {
            FieldToInject fieldToInject = new FieldToInject(this.targetField);
            if (this.requireDIAnnotation && kindOfInjectionPoint == InjectionPoint.KindOfInjectionPoint.NotAnnotated) {
                Object existingInstance = this.fullInjection.reuseInstance(this.testedClass, fieldToInject, qualifiedFieldName);
                return existingInstance;
            }
            Object newInstance = this.fullInjection.createOrReuseInstance(this, fieldToInject, qualifiedFieldName);
            if (newInstance != null) {
                return newInstance;
            }
        }
        if (kindOfInjectionPoint == InjectionPoint.KindOfInjectionPoint.WithValue) {
            return InjectionPoint.getValueFromAnnotation(this.targetField);
        }
        this.throwExceptionIfUnableToInjectRequiredTargetField(kindOfInjectionPoint);
        return null;
    }

    @Nullable
    private InjectionPointProvider findAvailableInjectableIfAny(@Nonnull List<Field> targetFields, @Nullable String qualifiedTargetFieldName) {
        this.injectionState.setTypeOfInjectionPoint(this.targetField.getGenericType());
        if (qualifiedTargetFieldName != null && !qualifiedTargetFieldName.isEmpty()) {
            String injectableName = InjectionPoint.convertToLegalJavaIdentifierIfNeeded(qualifiedTargetFieldName);
            return this.injectionState.findInjectableByTypeAndName(injectableName);
        }
        String targetFieldName = this.targetField.getName();
        return this.withMultipleTargetFieldsOfSameType(targetFields) ? this.injectionState.findInjectableByTypeAndName(targetFieldName) : this.injectionState.getProviderByTypeAndOptionallyName(targetFieldName);
    }

    private boolean withMultipleTargetFieldsOfSameType(@Nonnull List<Field> targetFields) {
        for (Field anotherTargetField : targetFields) {
            if (anotherTargetField == this.targetField || !this.injectionState.isSameTypeAsInjectionPoint(anotherTargetField.getGenericType())) continue;
            return true;
        }
        return false;
    }

    private void throwExceptionIfUnableToInjectRequiredTargetField(@Nonnull InjectionPoint.KindOfInjectionPoint kindOfInjectionPoint) {
        if (kindOfInjectionPoint == InjectionPoint.KindOfInjectionPoint.Required) {
            Type fieldType = this.targetField.getGenericType();
            String fieldTypeName = fieldType.toString();
            fieldTypeName = TYPE_NAME.matcher(fieldTypeName).replaceAll("");
            String kindOfInjectable = "@Injectable";
            if (this.fullInjection != null) {
                kindOfInjectable = this.targetField.getType().isInterface() ? "@Tested instance of an implementation class" : "@Tested object";
            }
            throw new IllegalStateException("Missing " + kindOfInjectable + " for field \"" + fieldTypeName + ' ' + this.targetField.getName() + "\" in " + this.targetField.getDeclaringClass().getSimpleName());
        }
    }

    @Override
    public void fillOutDependenciesRecursively(@Nonnull Object dependency) {
        Class<?> dependencyClass = dependency.getClass();
        boolean previousRequireDIAnnotation = this.requireDIAnnotation;
        List<Field> targetFields = this.findAllTargetInstanceFieldsInTestedClassHierarchy(dependencyClass);
        if (!targetFields.isEmpty()) {
            List<InjectionPointProvider> currentlyConsumedInjectables = this.injectionState.saveConsumedInjectables();
            this.injectIntoEligibleFields(targetFields, dependency);
            this.injectionState.restoreConsumedInjectables(currentlyConsumedInjectables);
        }
        this.requireDIAnnotation = previousRequireDIAnnotation;
    }
}

