/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Injectable;
import mockit.Tested;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.injection.BeanExporter;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedField;

public final class TestedClassInstantiations {
    @Nonnull
    private final List<TestedField> testedFields = new LinkedList<TestedField>();
    @Nonnull
    private final List<MockedType> injectableFields = new ArrayList<MockedType>();
    @Nonnull
    private final InjectionState injectionState = new InjectionState();

    public boolean findTestedAndInjectableFields(@Nonnull Class<?> testClass) {
        this.findAllTestedAndInjectableFieldsInTestClassHierarchy(testClass);
        return !this.testedFields.isEmpty();
    }

    private void findAllTestedAndInjectableFieldsInTestClassHierarchy(@Nonnull Class<?> testClass) {
        Class<?> superclass = testClass.getSuperclass();
        if (superclass.getClassLoader() != null) {
            this.findAllTestedAndInjectableFieldsInTestClassHierarchy(superclass);
        }
        for (Field field : testClass.getDeclaredFields()) {
            this.addAsTestedOrInjectableFieldIfApplicable(field);
        }
    }

    private void addAsTestedOrInjectableFieldIfApplicable(@Nonnull Field fieldFromTestClass) {
        for (Annotation fieldAnnotation : fieldFromTestClass.getDeclaredAnnotations()) {
            Tested testedMetadata = TestedClassInstantiations.getTestedAnnotationIfPresent(fieldAnnotation);
            if (testedMetadata != null) {
                TestedField testedField = new TestedField(this.injectionState, fieldFromTestClass, testedMetadata);
                this.testedFields.add(testedField);
                break;
            }
            if (!(fieldAnnotation instanceof Injectable)) continue;
            MockedType mockedType = new MockedType(fieldFromTestClass);
            this.injectableFields.add(mockedType);
            break;
        }
    }

    @Nullable
    private static Tested getTestedAnnotationIfPresent(@Nonnull Annotation fieldAnnotation) {
        if (fieldAnnotation instanceof Tested) {
            return (Tested)fieldAnnotation;
        }
        return fieldAnnotation.annotationType().getAnnotation(Tested.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignNewInstancesToTestedFields(@Nonnull Object testClassInstance, boolean beforeSetup) {
        this.injectionState.buildListsOfInjectables(testClassInstance, this.injectableFields);
        for (TestedField testedField : this.testedFields) {
            if (beforeSetup && !testedField.isAvailableDuringSetup()) continue;
            try {
                testedField.instantiateWithInjectableValues(testClassInstance);
            }
            finally {
                this.injectionState.resetConsumedInjectables();
            }
        }
    }

    public void clearTestedFields() {
        this.injectionState.lifecycleMethods.executeTerminationMethodsIfAny();
        for (TestedField testedField : this.testedFields) {
            testedField.clearIfAutomaticCreation();
        }
    }

    @Nonnull
    public BeanExporter getBeanExporter() {
        return this.injectionState;
    }
}

