/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.mockups;

import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.external.asm.ClassReader;
import mockit.internal.BaseClassModifier;
import mockit.internal.capturing.CaptureOfImplementations;
import mockit.internal.mockups.MockClassSetup;
import mockit.internal.mockups.MockedImplementationClass;
import mockit.internal.util.Utilities;

public final class CaptureOfMockedUpImplementations
extends CaptureOfImplementations<Void> {
    private final MockClassSetup mockClassSetup;

    public CaptureOfMockedUpImplementations(@Nonnull MockUp<?> mockUp, @Nonnull Type baseType) {
        Class<?> baseClassType = Utilities.getClassType(baseType);
        this.mockClassSetup = new MockClassSetup(baseClassType, baseType, mockUp, null);
    }

    @Override
    @Nonnull
    protected BaseClassModifier createModifier(@Nullable ClassLoader cl, @Nonnull ClassReader cr, @Nonnull Class<?> baseType, Void typeMetadata) {
        return this.mockClassSetup.createClassModifier(cr);
    }

    @Override
    protected void redefineClass(@Nonnull Class<?> realClass, @Nonnull byte[] modifiedClass) {
        this.mockClassSetup.applyClassModifications(realClass, modifiedClass);
    }

    @Nullable
    public <T> Class<T> apply() {
        Class<?> baseType;
        Class<Object> baseClassType = baseType = this.mockClassSetup.realClass;
        Class mockedClass = null;
        if (baseType.isInterface()) {
            mockedClass = new MockedImplementationClass(this.mockClassSetup.mockUp).createImplementation(baseType);
            baseClassType = mockedClass;
        }
        if (baseClassType != Object.class) {
            this.redefineClass(baseClassType, baseType, null);
        }
        this.makeSureAllSubtypesAreModified(baseType, false, null);
        return mockedClass;
    }
}

