/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.mockups;

import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.external.asm.ClassReader;
import mockit.external.asm.Label;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.Type;
import mockit.internal.BaseClassModifier;
import mockit.internal.mockups.MockMethodBridge;
import mockit.internal.mockups.MockMethods;
import mockit.internal.mockups.MockupBridge;
import mockit.internal.util.ClassLoad;

final class MockupsModifier
extends BaseClassModifier {
    private static final int ABSTRACT_OR_SYNTHETIC = 5120;
    @Nonnull
    private final MockMethods mockMethods;
    private final boolean useMockingBridgeForUpdatingMockState;
    @Nonnull
    private final Class<?> mockedClass;
    private MockMethods.MockMethod mockMethod;
    private boolean isConstructor;

    MockupsModifier(@Nonnull ClassReader cr, @Nonnull Class<?> realClass, @Nonnull MockUp<?> mockUp, @Nonnull MockMethods mockMethods) {
        super(cr);
        this.mockedClass = realClass;
        this.mockMethods = mockMethods;
        ClassLoader classLoaderOfRealClass = realClass.getClassLoader();
        this.useMockingBridgeForUpdatingMockState = ClassLoad.isClassLoaderWithNoDirectAccess(classLoaderOfRealClass);
        this.inferUseOfMockingBridge(classLoaderOfRealClass, mockUp);
    }

    private void inferUseOfMockingBridge(@Nullable ClassLoader classLoaderOfRealClass, @Nonnull Object mock) {
        this.setUseMockingBridge(classLoaderOfRealClass);
        if (!this.useMockingBridge && !Modifier.isPublic(mock.getClass().getModifiers())) {
            this.useMockingBridge = true;
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if ((access & 0x1400) != 0) {
            if (Modifier.isAbstract(access)) {
                this.mockMethods.findMethod(access, name, desc, signature);
            }
            return this.cw.visitMethod(access, name, desc, signature, exceptions);
        }
        this.isConstructor = "<init>".equals(name);
        if (this.isConstructor && this.isMockedSuperclass() || !this.hasMock(access, name, desc, signature)) {
            return this.cw.visitMethod(access, name, desc, signature, exceptions);
        }
        this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
        if (this.isConstructor) {
            this.generateCallToSuperConstructor();
        } else if (Modifier.isNative(this.methodAccess)) {
            this.generateCallToUpdateMockState();
            this.generateCallToMockMethod();
            this.generateMethodReturn();
            this.mw.visitMaxs(1, 0);
            return this.methodAnnotationsVisitor;
        }
        this.generateDynamicCallToMock();
        return this.copyOriginalImplementationCode(this.isConstructor);
    }

    private boolean hasMock(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature) {
        String mockName = MockupsModifier.getCorrespondingMockName(name);
        this.mockMethod = this.mockMethods.findMethod(access, mockName, desc, signature);
        return this.mockMethod != null;
    }

    @Nonnull
    private static String getCorrespondingMockName(@Nonnull String name) {
        if ("<init>".equals(name)) {
            return "$init";
        }
        if ("<clinit>".equals(name)) {
            return "$clinit";
        }
        return name;
    }

    private boolean isMockedSuperclass() {
        return this.mockedClass != this.mockMethods.getRealClass();
    }

    private void generateDynamicCallToMock() {
        Label startOfRealImplementation = null;
        if (!Modifier.isStatic(this.methodAccess) && !this.isConstructor && this.isMockedSuperclass()) {
            startOfRealImplementation = new Label();
            this.mw.visitVarInsn(25, 0);
            this.mw.visitTypeInsn(193, Type.getInternalName(this.mockMethods.getRealClass()));
            this.mw.visitJumpInsn(153, startOfRealImplementation);
        }
        this.generateCallToUpdateMockState();
        if (this.isConstructor) {
            this.generateConditionalCallForMockedConstructor();
        } else {
            this.generateConditionalCallForMockedMethod(startOfRealImplementation);
        }
    }

    private void generateCallToUpdateMockState() {
        if (this.useMockingBridgeForUpdatingMockState) {
            this.generateCallToControlMethodThroughMockingBridge();
            this.mw.visitTypeInsn(192, "java/lang/Boolean");
            this.mw.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
        } else {
            this.mw.visitLdcInsn(this.mockMethods.getMockClassInternalName());
            this.generateCodeToPassThisOrNullIfStaticMethod();
            this.mw.visitIntInsn(17, this.mockMethod.getIndexForMockState());
            this.mw.visitMethodInsn(184, "mockit/internal/state/TestRun", "updateMockState", "(Ljava/lang/String;Ljava/lang/Object;I)Z", false);
        }
    }

    private void generateCallToControlMethodThroughMockingBridge() {
        this.generateCodeToObtainInstanceOfMockingBridge(MockupBridge.MB);
        this.generateCodeToPassThisOrNullIfStaticMethod();
        this.mw.visitInsn(1);
        MockupsModifier.generateCodeToCreateArrayOfObject(this.mw, 2);
        int i = 0;
        this.generateCodeToFillArrayElement(i++, this.mockMethods.getMockClassInternalName());
        this.generateCodeToFillArrayElement(i, this.mockMethod.getIndexForMockState());
        this.generateCallToInvocationHandler();
    }

    private void generateConditionalCallForMockedMethod(@Nullable Label startOfRealImplementation) {
        if (startOfRealImplementation == null) {
            startOfRealImplementation = new Label();
        }
        this.mw.visitJumpInsn(153, startOfRealImplementation);
        this.generateCallToMockMethod();
        this.generateMethodReturn();
        this.mw.visitLabel(startOfRealImplementation);
    }

    private void generateConditionalCallForMockedConstructor() {
        int jumpInsnOpcode;
        this.generateCallToMockMethod();
        if (this.shouldUseMockingBridge()) {
            this.mw.visitLdcInsn(VOID_TYPE);
            jumpInsnOpcode = 165;
        } else {
            jumpInsnOpcode = this.mockMethod.hasInvocationParameter ? 154 : 153;
        }
        Label startOfRealImplementation = new Label();
        this.mw.visitJumpInsn(jumpInsnOpcode, startOfRealImplementation);
        this.mw.visitInsn(177);
        this.mw.visitLabel(startOfRealImplementation);
    }

    private void generateCallToMockMethod() {
        if (this.shouldUseMockingBridge()) {
            this.generateCallToMockMethodThroughMockingBridge();
        } else {
            this.generateDirectCallToMockMethod();
        }
    }

    private boolean shouldUseMockingBridge() {
        return this.useMockingBridge || !this.mockMethod.isPublic();
    }

    private void generateCallToMockMethodThroughMockingBridge() {
        this.generateCodeToObtainInstanceOfMockingBridge(MockMethodBridge.MB);
        boolean isStatic = this.generateCodeToPassThisOrNullIfStaticMethod();
        this.mw.visitInsn(1);
        Type[] argTypes = Type.getArgumentTypes(this.methodDesc);
        MockupsModifier.generateCodeToCreateArrayOfObject(this.mw, 6 + argTypes.length);
        int i = 0;
        this.generateCodeToFillArrayElement(i++, this.mockMethods.getMockClassInternalName());
        this.generateCodeToFillArrayElement(i++, this.classDesc);
        this.generateCodeToFillArrayElement(i++, this.methodAccess);
        if (this.mockMethod.isAdvice) {
            this.generateCodeToFillArrayElement(i++, this.methodName);
            this.generateCodeToFillArrayElement(i++, this.methodDesc);
        } else {
            this.generateCodeToFillArrayElement(i++, this.mockMethod.name);
            this.generateCodeToFillArrayElement(i++, this.mockMethod.desc);
        }
        this.generateCodeToFillArrayElement(i++, this.mockMethod.getIndexForMockState());
        MockupsModifier.generateCodeToFillArrayWithParameterValues(this.mw, argTypes, i, isStatic ? 0 : 1);
        this.generateCallToInvocationHandler();
    }

    private void generateDirectCallToMockMethod() {
        int invokeOpcode;
        String mockClassDesc = this.mockMethods.getMockClassInternalName();
        if (this.mockMethod.isStatic()) {
            invokeOpcode = 184;
        } else {
            this.generateCodeToObtainMockUpInstance(mockClassDesc);
            invokeOpcode = 182;
        }
        boolean canProceedIntoConstructor = this.generateArgumentsForMockMethodInvocation();
        this.mw.visitMethodInsn(invokeOpcode, mockClassDesc, this.mockMethod.name, this.mockMethod.desc, false);
        if (canProceedIntoConstructor) {
            this.mw.visitMethodInsn(182, "mockit/internal/mockups/MockInvocation", "shouldProceedIntoConstructor", "()Z", false);
        }
    }

    private void generateCodeToObtainMockUpInstance(@Nonnull String mockClassDesc) {
        this.mw.visitLdcInsn(mockClassDesc);
        this.generateCodeToPassThisOrNullIfStaticMethod();
        this.mw.visitMethodInsn(184, "mockit/internal/state/TestRun", "getMock", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", false);
        this.mw.visitTypeInsn(192, mockClassDesc);
    }

    private boolean generateArgumentsForMockMethodInvocation() {
        String mockedDesc = this.mockMethod.isAdvice ? this.methodDesc : this.mockMethod.mockDescWithoutInvocationParameter;
        Type[] argTypes = Type.getArgumentTypes(mockedDesc);
        int varIndex = Modifier.isStatic(this.methodAccess) ? 0 : 1;
        boolean canProceedIntoConstructor = false;
        if (this.mockMethod.hasInvocationParameter) {
            this.generateCallToCreateNewMockInvocation(argTypes, varIndex);
            if (this.isConstructor) {
                this.mw.visitInsn(this.mockMethod.isStatic() ? 89 : 90);
                canProceedIntoConstructor = true;
            }
        }
        if (!this.mockMethod.isAdvice) {
            boolean forGenericMethod = this.mockMethod.isForGenericMethod();
            for (Type argType : argTypes) {
                int opcode = argType.getOpcode(21);
                this.mw.visitVarInsn(opcode, varIndex);
                if (forGenericMethod && argType.getSort() >= 9) {
                    this.mw.visitTypeInsn(192, argType.getInternalName());
                }
                varIndex += argType.getSize();
            }
        }
        return canProceedIntoConstructor;
    }

    private void generateCallToCreateNewMockInvocation(@Nonnull Type[] argTypes, int initialParameterIndex) {
        this.generateCodeToPassThisOrNullIfStaticMethod();
        int argCount = argTypes.length;
        if (argCount == 0) {
            this.mw.visitInsn(1);
        } else {
            MockupsModifier.generateCodeToCreateArrayOfObject(this.mw, argCount);
            MockupsModifier.generateCodeToFillArrayWithParameterValues(this.mw, argTypes, 0, initialParameterIndex);
        }
        this.mw.visitLdcInsn(this.mockMethods.getMockClassInternalName());
        this.mw.visitIntInsn(17, this.mockMethod.getIndexForMockState());
        this.mw.visitLdcInsn(this.classDesc);
        this.mw.visitLdcInsn(this.methodName);
        this.mw.visitLdcInsn(this.methodDesc);
        this.mw.visitMethodInsn(184, "mockit/internal/mockups/MockInvocation", "create", "(Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lmockit/internal/mockups/MockInvocation;", false);
    }

    private void generateMethodReturn() {
        if (this.shouldUseMockingBridge() || this.mockMethod.isAdvice) {
            this.generateReturnWithObjectAtTopOfTheStack(this.methodDesc);
        } else {
            Type returnType = Type.getReturnType(this.methodDesc);
            this.mw.visitInsn(returnType.getOpcode(172));
        }
    }
}

