/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.Type;
import mockit.internal.expectations.mocking.CascadingTypeRedefinition;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.state.CascadingTypes;
import mockit.internal.state.TestRun;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.GenericTypeReflection;
import mockit.internal.util.RealMethodOrConstructor;
import mockit.internal.util.Utilities;

public final class MockedTypeCascade {
    @Nonnull
    private static final CascadingTypes CASCADING_TYPES = TestRun.getExecutingTest().getCascadingTypes();
    final boolean fromMockField;
    @Nonnull
    private final java.lang.reflect.Type mockedType;
    @Nullable
    Class<?> mockedClass;
    @Nullable
    private GenericTypeReflection genericReflection;
    @Nonnull
    private final Map<String, java.lang.reflect.Type> cascadedTypesAndMocks;

    MockedTypeCascade(boolean fromMockField, @Nonnull java.lang.reflect.Type mockedType) {
        this.fromMockField = fromMockField;
        this.mockedType = mockedType;
        this.cascadedTypesAndMocks = new ConcurrentHashMap<String, java.lang.reflect.Type>(4);
    }

    @Nullable
    public static Object getMock(@Nonnull String mockedTypeDesc, @Nonnull String mockedMethodNameAndDesc, @Nullable Object mockInstance, @Nonnull String returnTypeDesc, @Nonnull Class<?> returnType) {
        MockedTypeCascade cascade = CASCADING_TYPES.getCascade(mockedTypeDesc, mockInstance);
        if (cascade == null) {
            return null;
        }
        String cascadedReturnTypeDesc = MockedTypeCascade.getReturnTypeIfCascadingSupportedForIt(returnTypeDesc);
        if (cascadedReturnTypeDesc == null) {
            return null;
        }
        return cascade.getCascadedInstance(mockedMethodNameAndDesc, cascadedReturnTypeDesc, returnType);
    }

    @Nullable
    public static Object getMock(@Nonnull String mockedTypeDesc, @Nonnull String mockedMethodNameAndDesc, @Nullable Object mockInstance, @Nonnull String returnTypeDesc, @Nullable String genericSignature) {
        char typeCode = returnTypeDesc.charAt(0);
        if (typeCode != 'L') {
            return null;
        }
        MockedTypeCascade cascade = CASCADING_TYPES.getCascade(mockedTypeDesc, mockInstance);
        if (cascade == null) {
            return null;
        }
        String resolvedReturnTypeDesc = null;
        if (genericSignature != null) {
            resolvedReturnTypeDesc = cascade.getGenericReturnType(genericSignature);
        }
        if (resolvedReturnTypeDesc == null) {
            resolvedReturnTypeDesc = MockedTypeCascade.getReturnTypeIfCascadingSupportedForIt(returnTypeDesc);
            if (resolvedReturnTypeDesc == null) {
                return null;
            }
        } else if (resolvedReturnTypeDesc.charAt(0) == '[') {
            return DefaultValues.computeForArrayType(resolvedReturnTypeDesc);
        }
        return cascade.getCascadedInstance(mockedMethodNameAndDesc, resolvedReturnTypeDesc, mockInstance);
    }

    @Nullable
    private String getGenericReturnType(@Nonnull String genericSignature) {
        String returnTypeDesc = this.getGenericReflection().resolveReturnType(genericSignature);
        if (returnTypeDesc.charAt(0) == '[') {
            return returnTypeDesc;
        }
        String returnTypeName = returnTypeDesc.substring(1, returnTypeDesc.length() - 1);
        return MockedTypeCascade.isTypeSupportedForCascading(returnTypeName) ? returnTypeName : null;
    }

    @Nonnull
    private synchronized GenericTypeReflection getGenericReflection() {
        GenericTypeReflection reflection = this.genericReflection;
        if (reflection == null) {
            Class<?> ownerClass = this.getClassWithCalledMethod();
            this.genericReflection = reflection = new GenericTypeReflection(ownerClass, this.mockedType);
        }
        return reflection;
    }

    @Nullable
    private static String getReturnTypeIfCascadingSupportedForIt(@Nonnull Class<?> returnType) {
        String typeName = Type.getInternalName(returnType);
        return MockedTypeCascade.isTypeSupportedForCascading(typeName) ? typeName : null;
    }

    private static boolean isTypeSupportedForCascading(@Nonnull String typeName) {
        if (typeName.contains("/Process") || typeName.endsWith("/Runnable")) {
            return true;
        }
        return !(typeName.startsWith("java/lang/") && !typeName.contains("management") || typeName.startsWith("java/math/") || typeName.startsWith("java/util/") && !typeName.endsWith("/Date") && !typeName.endsWith("/Callable") && !typeName.endsWith("Future") && !typeName.contains("logging") || "java/time/Duration".equals(typeName));
    }

    @Nullable
    private static String getReturnTypeIfCascadingSupportedForIt(@Nonnull String typeDesc) {
        String typeName = typeDesc.substring(1, typeDesc.length() - 1);
        return MockedTypeCascade.isTypeSupportedForCascading(typeName) ? typeName : null;
    }

    @Nullable
    private Object getCascadedInstance(@Nonnull String methodNameAndDesc, @Nonnull String returnTypeInternalName, @Nonnull Class<?> returnClass) {
        if (!this.cascadedTypesAndMocks.containsKey(returnTypeInternalName)) {
            this.cascadedTypesAndMocks.put(returnTypeInternalName, returnClass);
            CASCADING_TYPES.add(returnTypeInternalName, false, returnClass);
        }
        return MockedTypeCascade.createNewCascadedInstanceOrUseNonCascadedOneIfAvailable(methodNameAndDesc, returnClass);
    }

    @Nullable
    private Object getCascadedInstance(@Nonnull String methodNameAndDesc, @Nonnull String returnTypeInternalName, @Nullable Object mockInstance) {
        Class<?> returnClass;
        java.lang.reflect.Type returnType = this.cascadedTypesAndMocks.get(returnTypeInternalName);
        if (returnType == null) {
            java.lang.reflect.Type genericReturnType;
            Class<?> cascadingClass = this.getClassWithCalledMethod();
            try {
                genericReturnType = this.getGenericReturnType(cascadingClass, methodNameAndDesc);
            }
            catch (NoSuchMethodException ignore) {
                return null;
            }
            Class<?> resolvedReturnType = Utilities.getClassType(genericReturnType);
            if (resolvedReturnType.isAssignableFrom(cascadingClass)) {
                if (mockInstance != null) {
                    return mockInstance;
                }
                returnType = this.mockedType;
                returnClass = cascadingClass;
            } else {
                Object defaultReturnValue = DefaultValues.computeForType(resolvedReturnType);
                if (defaultReturnValue != null) {
                    return defaultReturnValue;
                }
                this.cascadedTypesAndMocks.put(returnTypeInternalName, genericReturnType);
                CASCADING_TYPES.add(returnTypeInternalName, false, genericReturnType);
                returnType = genericReturnType;
                returnClass = resolvedReturnType;
            }
        } else {
            returnClass = Utilities.getClassType(returnType);
        }
        if (MockedTypeCascade.getReturnTypeIfCascadingSupportedForIt(returnClass) == null) {
            return null;
        }
        return MockedTypeCascade.createNewCascadedInstanceOrUseNonCascadedOneIfAvailable(methodNameAndDesc, returnType);
    }

    @Nonnull
    private Class<?> getClassWithCalledMethod() {
        if (this.mockedClass != null) {
            return this.mockedClass;
        }
        if (this.mockedType instanceof Class) {
            return (Class)this.mockedType;
        }
        return (Class)((ParameterizedType)this.mockedType).getRawType();
    }

    @Nonnull
    private java.lang.reflect.Type getGenericReturnType(@Nonnull Class<?> cascadingClass, @Nonnull String methodNameAndDesc) throws NoSuchMethodException {
        Method cascadingMethod = (Method)new RealMethodOrConstructor(cascadingClass, methodNameAndDesc).getMember();
        java.lang.reflect.Type genericReturnType = cascadingMethod.getGenericReturnType();
        if (genericReturnType instanceof TypeVariable) {
            genericReturnType = this.getGenericReflection().resolveTypeVariable((TypeVariable)genericReturnType);
        }
        return genericReturnType;
    }

    @Nullable
    private static Object createNewCascadedInstanceOrUseNonCascadedOneIfAvailable(@Nonnull String methodNameAndDesc, @Nonnull java.lang.reflect.Type mockedReturnType) {
        InstanceFactory instanceFactory = TestRun.mockFixture().findInstanceFactory(mockedReturnType);
        if (instanceFactory == null) {
            String methodName = methodNameAndDesc.substring(0, methodNameAndDesc.indexOf(40));
            CascadingTypeRedefinition typeRedefinition = new CascadingTypeRedefinition(methodName, mockedReturnType);
            instanceFactory = typeRedefinition.redefineType();
            if (instanceFactory == null) {
                return null;
            }
        } else {
            Object lastInstance = instanceFactory.getLastInstance();
            if (lastInstance != null) {
                return lastInstance;
            }
        }
        Object cascadedInstance = instanceFactory.create();
        instanceFactory.clearLastInstance();
        TestRun.getExecutingTest().addInjectableMock(cascadedInstance);
        return cascadedInstance;
    }

    void discardCascadedMocks() {
        this.cascadedTypesAndMocks.clear();
    }
}

