/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ParameterNames {
    private static final Map<String, Map<String, String[]>> classesToMethodsToParameters = new HashMap<String, Map<String, String[]>>();
    private static final String[] NO_PARAMETERS = new String[0];

    private ParameterNames() {
    }

    public static boolean hasNamesForClass(@Nonnull String classDesc) {
        return classesToMethodsToParameters.containsKey(classDesc);
    }

    public static void registerName(@Nonnull String classDesc, @Nonnegative int memberAccess, @Nonnull String memberName, @Nonnull String memberDesc, @Nonnull String desc, @Nonnull String name, @Nonnegative int index) {
        int i;
        String methodKey;
        String[] parameterNames;
        if ("this".equals(name)) {
            return;
        }
        Map<String, String[]> methodsToParameters = classesToMethodsToParameters.get(classDesc);
        if (methodsToParameters == null) {
            methodsToParameters = new HashMap<String, String[]>();
            classesToMethodsToParameters.put(classDesc, methodsToParameters);
        }
        if ((parameterNames = methodsToParameters.get(methodKey = memberName + memberDesc)) == null) {
            int sumOfArgumentSizes = ParameterNames.getSumOfArgumentSizes(memberDesc);
            parameterNames = sumOfArgumentSizes == 0 ? NO_PARAMETERS : new String[sumOfArgumentSizes];
            methodsToParameters.put(methodKey, parameterNames);
        }
        if ((i = index - (Modifier.isStatic(memberAccess) ? 0 : 1)) < parameterNames.length) {
            parameterNames[i] = name;
            if (ParameterNames.isDoubleSizeType(desc.charAt(0))) {
                parameterNames[i + 1] = "";
            }
        }
    }

    private static int getSumOfArgumentSizes(@Nonnull String memberDesc) {
        int sum = 0;
        int i = 1;
        while (true) {
            char c = memberDesc.charAt(i);
            ++i;
            if (c == ')') {
                return sum;
            }
            if (c == 'L') {
                while (memberDesc.charAt(i) != ';') {
                    ++i;
                }
                ++i;
                ++sum;
                continue;
            }
            if (c == '[') {
                while ((c = memberDesc.charAt(i)) == '[') {
                    ++i;
                }
                if (!ParameterNames.isDoubleSizeType(c)) continue;
                ++i;
                ++sum;
                continue;
            }
            if (ParameterNames.isDoubleSizeType(c)) {
                sum += 2;
                continue;
            }
            ++sum;
        }
    }

    private static boolean isDoubleSizeType(char typeCode) {
        return typeCode == 'D' || typeCode == 'J';
    }

    @Nullable
    public static String getName(@Nonnull String classDesc, @Nonnull String methodDesc, int index) {
        Map<String, String[]> methodsToParameters = classesToMethodsToParameters.get(classDesc);
        if (methodsToParameters == null) {
            return null;
        }
        String[] parameterNames = methodsToParameters.get(methodDesc);
        int n = parameterNames.length;
        int i = 0;
        int j = 0;
        while (true) {
            String name = parameterNames[i];
            if (j == index || name == null) {
                return name;
            }
            if (++i == n) break;
            String nextName = parameterNames[i];
            if (nextName.isEmpty()) {
                ++i;
            }
            ++j;
        }
        return null;
    }
}

