/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.mocking.FieldTypeRedefinitions;
import mockit.internal.injection.TestedClassInstantiations;
import mockit.internal.mockups.MockStates;
import mockit.internal.state.ExecutingTest;
import mockit.internal.state.MockClasses;
import mockit.internal.state.MockFixture;

public final class TestRun {
    private static final TestRun INSTANCE = new TestRun();
    private static final ThreadLocal<Integer> noMockingCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }

        @Override
        public void set(Integer valueToAdd) {
            super.set((Integer)this.get() + valueToAdd);
        }
    };
    private int testId;
    @Nullable
    private Class<?> currentTestClass;
    @Nullable
    private Object currentTestInstance;
    @Nullable
    private FieldTypeRedefinitions fieldTypeRedefinitions;
    @Nullable
    private TestedClassInstantiations testedClassInstantiations;
    @Nonnull
    private final MockFixture mockFixture = new MockFixture();
    @Nonnull
    private final ExecutingTest executingTest = new ExecutingTest();
    @Nonnull
    private final MockClasses mockClasses = new MockClasses();

    private TestRun() {
    }

    public static boolean isInsideNoMockingZone() {
        return noMockingCount.get() > 0;
    }

    @Nullable
    public static Class<?> getCurrentTestClass() {
        return TestRun.INSTANCE.currentTestClass;
    }

    @Nullable
    public static Object getCurrentTestInstance() {
        return TestRun.INSTANCE.currentTestInstance;
    }

    public static int getTestId() {
        return TestRun.INSTANCE.testId;
    }

    @Nullable
    public static FieldTypeRedefinitions getFieldTypeRedefinitions() {
        return TestRun.INSTANCE.fieldTypeRedefinitions;
    }

    @Nullable
    public static TestedClassInstantiations getTestedClassInstantiations() {
        return TestRun.INSTANCE.testedClassInstantiations;
    }

    @Nonnull
    public static MockFixture mockFixture() {
        return TestRun.INSTANCE.mockFixture;
    }

    @Nonnull
    public static ExecutingTest getExecutingTest() {
        return TestRun.INSTANCE.executingTest;
    }

    @Nullable
    public static RecordAndReplayExecution getRecordAndReplayForRunningTest() {
        return TestRun.INSTANCE.executingTest.getCurrentRecordAndReplay();
    }

    @Nonnull
    public static RecordAndReplayExecution getOrCreateRecordAndReplayForRunningTest() {
        return TestRun.INSTANCE.executingTest.getOrCreateRecordAndReplay();
    }

    @Nonnull
    public static RecordAndReplayExecution getRecordAndReplayForVerifications() {
        return TestRun.INSTANCE.executingTest.getRecordAndReplayForVerifications();
    }

    @Nonnull
    public static MockClasses getMockClasses() {
        return TestRun.INSTANCE.mockClasses;
    }

    @Nonnull
    public static MockStates getMockStates() {
        return TestRun.INSTANCE.mockClasses.mockStates;
    }

    public static void setCurrentTestClass(@Nullable Class<?> testClass) {
        TestRun.INSTANCE.currentTestClass = testClass;
    }

    public static void prepareForNextTest() {
        ++TestRun.INSTANCE.testId;
        TestRun.INSTANCE.executingTest.setRecordAndReplay(null);
    }

    public static void enterNoMockingZone() {
        noMockingCount.set(1);
    }

    public static void exitNoMockingZone() {
        noMockingCount.set(-1);
    }

    public static void clearNoMockingZone() {
        noMockingCount.remove();
    }

    public static void clearCurrentTestInstance() {
        TestRun.INSTANCE.currentTestInstance = null;
    }

    public static void setRunningIndividualTest(@Nonnull Object testInstance) {
        TestRun.INSTANCE.currentTestInstance = testInstance;
    }

    public static void setFieldTypeRedefinitions(@Nullable FieldTypeRedefinitions redefinitions) {
        TestRun.INSTANCE.fieldTypeRedefinitions = redefinitions;
    }

    public static void setTestedClassInstantiations(@Nullable TestedClassInstantiations testedClassInstantiations) {
        TestRun.INSTANCE.testedClassInstantiations = testedClassInstantiations;
    }

    public static void finishCurrentTestExecution() {
        TestRun.INSTANCE.executingTest.finishExecution();
    }

    public static boolean updateMockState(@Nonnull String mockUpClassDesc, @Nullable Object mockedInstance, int mockStateIndex) {
        Object mockUp = TestRun.getMock(mockUpClassDesc, mockedInstance);
        if (mockUp == null) {
            return false;
        }
        if (mockStateIndex < 0) {
            return true;
        }
        return TestRun.getMockStates().updateMockState(mockUp, mockStateIndex);
    }

    @Nullable
    public static Object getMock(@Nonnull String mockUpClassDesc, @Nullable Object mockedInstance) {
        return TestRun.INSTANCE.mockClasses.getMock(mockUpClassDesc, mockedInstance);
    }
}

