/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.ConstructorReflection;

public final class GeneratedClasses {
    private static final String SUBCLASS_PREFIX = "$Subclass_";
    private static final String IMPLCLASS_PREFIX = "$Impl_";

    private GeneratedClasses() {
    }

    @Nonnull
    public static String getNameForGeneratedClass(@Nonnull Class<?> aClass, @Nullable String suffix) {
        Package targetPackage;
        String prefix = aClass.isInterface() ? IMPLCLASS_PREFIX : SUBCLASS_PREFIX;
        StringBuilder name = new StringBuilder(60).append(prefix).append(aClass.getSimpleName());
        if (suffix != null) {
            name.append('_').append(suffix);
        }
        if (aClass.getClassLoader() != null && (targetPackage = aClass.getPackage()) != null && !targetPackage.isSealed()) {
            name.insert(0, '.').insert(0, targetPackage.getName());
        }
        return name.toString();
    }

    public static boolean isGeneratedImplementationClass(@Nonnull Class<?> mockedType) {
        return GeneratedClasses.isGeneratedImplementationClass(mockedType.getName());
    }

    public static boolean isGeneratedSubclass(@Nonnull String className) {
        return className.contains(SUBCLASS_PREFIX);
    }

    public static boolean isGeneratedImplementationClass(@Nonnull String className) {
        return className.contains(IMPLCLASS_PREFIX);
    }

    public static boolean isGeneratedClass(@Nonnull String className) {
        return GeneratedClasses.isGeneratedSubclass(className) || GeneratedClasses.isGeneratedImplementationClass(className);
    }

    @Nonnull
    public static Class<?> getMockedClassOrInterfaceType(@Nonnull Class<?> aClass) {
        if (Proxy.isProxyClass(aClass) || GeneratedClasses.isGeneratedImplementationClass(aClass)) {
            return GeneratedClasses.getImplementedInterface(aClass);
        }
        if (GeneratedClasses.isGeneratedSubclass(aClass.getName())) {
            return aClass.getSuperclass();
        }
        return aClass;
    }

    @Nonnull
    public static Class<?> getImplementedInterface(@Nonnull Class<?> implementationClass) {
        return implementationClass.getInterfaces()[0];
    }

    @Nonnull
    public static Class<?> getMockedClass(@Nonnull Object mock) {
        return GeneratedClasses.getMockedClassOrInterfaceType(mock.getClass());
    }

    @Nonnull
    public static Object newInstance(Class<?> generatedClass) {
        Constructor<?> publicConstructor;
        try {
            publicConstructor = generatedClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return ConstructorReflection.invoke(publicConstructor, new Object[0]);
    }
}

