/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.Label;
import mockit.external.asm.MethodVisitor;
import mockit.internal.ClassFile;
import mockit.internal.state.ParameterNames;

public final class ParameterNameExtractor
extends ClassVisitor {
    @Nonnull
    private String classDesc = "";
    @Nonnegative
    private int memberAccess;
    @Nonnull
    private String memberName = "";
    @Nonnull
    private String memberDesc = "";

    @Nonnull
    public String extractNames(@Nonnull Class<?> classOfInterest) {
        String className = classOfInterest.getName();
        this.classDesc = className.replace('.', '/');
        if (!ParameterNames.hasNamesForClass(this.classDesc)) {
            ClassReader cr = ClassFile.readFromFile(this.classDesc);
            cr.accept(this, 4);
        }
        return this.classDesc;
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if ((access & 0x1000) == 0) {
            this.memberAccess = access;
            this.memberName = name;
            this.memberDesc = desc;
            return new MethodOrConstructorVisitor();
        }
        return null;
    }

    private final class MethodOrConstructorVisitor
    extends MethodVisitor {
        private MethodOrConstructorVisitor() {
        }

        @Override
        public void visitLocalVariable(@Nonnull String name, @Nonnull String desc, String signature, Label start, Label end, @Nonnegative int index) {
            ParameterNames.registerName(ParameterNameExtractor.this.classDesc, ParameterNameExtractor.this.memberAccess, ParameterNameExtractor.this.memberName, ParameterNameExtractor.this.memberDesc, desc, name, index);
        }
    }
}

