/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.ConstructorReflection;
import mockit.internal.util.TypeDescriptor;

public final class RealMethodOrConstructor {
    @Nonnull
    public final Member member;

    public RealMethodOrConstructor(@Nonnull String classDesc, @Nonnull String methodName, @Nonnull String methodDesc) throws NoSuchMethodException {
        ClassLoader cl = this.getClass().getClassLoader();
        Class realClass = ClassLoad.loadFromLoader(cl, classDesc.replace('/', '.'));
        this.member = methodName.charAt(0) == '<' ? RealMethodOrConstructor.findConstructor(realClass, methodDesc) : RealMethodOrConstructor.findMethod(realClass, methodName, methodDesc);
    }

    public RealMethodOrConstructor(@Nonnull String className, @Nonnull String methodNameAndDesc) throws NoSuchMethodException {
        this(ClassLoad.loadFromLoader(RealMethodOrConstructor.class.getClassLoader(), className), methodNameAndDesc);
    }

    public RealMethodOrConstructor(@Nonnull Class<?> realClass, @Nonnull String methodNameAndDesc) throws NoSuchMethodException {
        int p = methodNameAndDesc.indexOf(40);
        String memberDesc = methodNameAndDesc.substring(p);
        if (methodNameAndDesc.charAt(0) == '<') {
            this.member = RealMethodOrConstructor.findConstructor(realClass, memberDesc);
        } else {
            String methodName = methodNameAndDesc.substring(0, p);
            this.member = RealMethodOrConstructor.findMethod(realClass, methodName, memberDesc);
        }
    }

    public RealMethodOrConstructor(@Nonnull Class<?> realClass, @Nonnull String methodName, @Nonnull String memberDesc) throws NoSuchMethodException {
        this.member = methodName.charAt(0) == '<' ? RealMethodOrConstructor.findConstructor(realClass, memberDesc) : RealMethodOrConstructor.findMethod(realClass, methodName, memberDesc);
    }

    @Nonnull
    private static Constructor<?> findConstructor(@Nonnull Class<?> realClass, @Nonnull String methodDesc) {
        Class<?>[] parameterTypes = TypeDescriptor.getParameterTypes(methodDesc);
        return ConstructorReflection.findSpecifiedConstructor(realClass, parameterTypes);
    }

    @Nonnull
    private static Method findMethod(@Nonnull Class<?> realClass, @Nonnull String methodName, @Nonnull String methodDesc) throws NoSuchMethodException {
        Class<?>[] parameterTypes = TypeDescriptor.getParameterTypes(methodDesc);
        Class<?> ownerClass = realClass;
        while (true) {
            try {
                Method method;
                while ((method = ownerClass.getDeclaredMethod(methodName, parameterTypes)).isBridge()) {
                    ownerClass = ownerClass.getSuperclass();
                }
                return method;
            }
            catch (NoSuchMethodException e) {
                if (!ownerClass.isInterface()) continue;
                Method interfaceMethod = RealMethodOrConstructor.findInterfaceMethod(ownerClass, methodName, parameterTypes);
                if (interfaceMethod == null) {
                    throw e;
                }
                return interfaceMethod;
                if ((ownerClass = ownerClass.getSuperclass()) != Object.class) continue;
                throw e;
            }
            break;
        }
    }

    @Nullable
    private static Method findInterfaceMethod(@Nonnull Class<?> anInterface, @Nonnull String methodName, @Nonnull Class<?>[] parameterTypes) {
        for (Class<?> superInterface : anInterface.getInterfaces()) {
            try {
                return superInterface.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    @Nonnull
    public <M extends Member> M getMember() {
        return (M)this.member;
    }
}

