/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import javax.annotation.Nonnull;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.Type;

public final class TypeConversion {
    private static final String[] PRIMITIVE_WRAPPER_TYPE = new String[]{null, "java/lang/Boolean", "java/lang/Character", "java/lang/Byte", "java/lang/Short", "java/lang/Integer", "java/lang/Float", "java/lang/Long", "java/lang/Double"};
    private static final String PRIMITIVE_WRAPPER_TYPES = "java/lang/Boolean   java/lang/Character java/lang/Byte      java/lang/Short     java/lang/Integer   java/lang/Float     java/lang/Long      java/lang/Double";
    private static final String[] UNBOXING_NAME = new String[]{null, "booleanValue", "charValue", "byteValue", "shortValue", "intValue", "floatValue", "longValue", "doubleValue"};
    private static final String[] UNBOXING_DESC = new String[]{null, "()Z", "()C", "()B", "()S", "()I", "()F", "()J", "()D"};

    private TypeConversion() {
    }

    public static void generateCastToObject(@Nonnull MethodVisitor mv, @Nonnull Type type) {
        int sort = type.getSort();
        if (sort < 9) {
            String wrapperType = PRIMITIVE_WRAPPER_TYPE[sort];
            String desc = '(' + type.getDescriptor() + ")L" + wrapperType + ';';
            mv.visitMethodInsn(184, wrapperType, "valueOf", desc, false);
        }
    }

    public static void generateCastFromObject(@Nonnull MethodVisitor mv, @Nonnull Type toType) {
        int sort = toType.getSort();
        if (sort == 0) {
            mv.visitInsn(87);
        } else {
            TypeConversion.generateTypeCheck(mv, toType);
            if (sort < 9) {
                mv.visitMethodInsn(182, PRIMITIVE_WRAPPER_TYPE[sort], UNBOXING_NAME[sort], UNBOXING_DESC[sort], false);
            }
        }
    }

    private static void generateTypeCheck(@Nonnull MethodVisitor mv, @Nonnull Type toType) {
        String typeDesc;
        int sort = toType.getSort();
        switch (sort) {
            case 9: {
                typeDesc = toType.getDescriptor();
                break;
            }
            case 10: {
                typeDesc = toType.getInternalName();
                break;
            }
            default: {
                typeDesc = PRIMITIVE_WRAPPER_TYPE[sort];
            }
        }
        mv.visitTypeInsn(192, typeDesc);
    }

    public static void generateCastOrUnboxing(@Nonnull MethodVisitor mv, @Nonnull Type parameterType, int opcode) {
        String typeDesc;
        if (opcode == 58) {
            TypeConversion.generateTypeCheck(mv, parameterType);
            return;
        }
        int sort = parameterType.getSort();
        if (sort < 9) {
            typeDesc = PRIMITIVE_WRAPPER_TYPE[sort];
        } else {
            typeDesc = parameterType.getInternalName();
            int i = PRIMITIVE_WRAPPER_TYPES.indexOf(typeDesc);
            if (i >= 0) {
                sort = i / 20 + 1;
            } else if (opcode == 54 && "java/lang/Number".equals(typeDesc)) {
                sort = 5;
            } else {
                sort = 5;
                switch (opcode) {
                    case 56: {
                        sort = 6;
                        break;
                    }
                    case 55: {
                        sort = 7;
                        break;
                    }
                    case 57: {
                        sort = 8;
                    }
                }
                typeDesc = PRIMITIVE_WRAPPER_TYPE[sort];
            }
        }
        mv.visitTypeInsn(192, typeDesc);
        mv.visitMethodInsn(182, typeDesc, UNBOXING_NAME[sort], UNBOXING_DESC[sort], false);
    }

    public static boolean isPrimitiveWrapper(@Nonnull String typeDesc) {
        return PRIMITIVE_WRAPPER_TYPES.contains(typeDesc);
    }

    public static boolean isBoxing(@Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
        return desc.charAt(2) == ')' && "valueOf".equals(name) && TypeConversion.isPrimitiveWrapper(owner);
    }

    public static boolean isUnboxing(int opcode, @Nonnull String owner, @Nonnull String desc) {
        return opcode == 182 && desc.charAt(1) == ')' && TypeConversion.isPrimitiveWrapper(owner);
    }
}

