/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import junit.framework.AssertionFailedError;
import org.slf4j.helpers.BubbleSort;
import org.slf4j.helpers.MyRandom;

public class BogoPerf {
    private static long NANOS_IN_ONE_SECOND = 1000000000L;
    private static int INITIAL_N = 1000;
    private static int LAST_N = 100;
    private static int SLACK_FACTOR = 3;

    private static double computeBogoIPS(int N) {
        long begin = System.nanoTime();
        for (int i = 0; i < N; ++i) {
            BogoPerf.bogoInstruction();
        }
        long end = System.nanoTime();
        double D = end - begin;
        double avgDPIS = D / (double)N;
        double bogoIPS = (double)NANOS_IN_ONE_SECOND / avgDPIS;
        return bogoIPS;
    }

    private static void bogoInstruction() {
        MyRandom myRandom = new MyRandom(100L);
        int len = 150;
        int[] intArray = new int[len];
        for (int i = 0; i < len; ++i) {
            intArray[i] = myRandom.nextInt();
        }
        BubbleSort.sort(intArray);
    }

    public static double currentBIPS() {
        return BogoPerf.computeBogoIPS(LAST_N);
    }

    static double min(double a, double b) {
        return a <= b ? a : b;
    }

    public static void assertDuration(double currentDuration, long referenceDuration, double referenceBIPS) throws AssertionFailedError {
        double ajustedDuration = BogoPerf.adjustExpectedDuration(referenceDuration, referenceBIPS);
        if (currentDuration > ajustedDuration * (double)SLACK_FACTOR) {
            throw new AssertionFailedError("current duration " + currentDuration + " exceeded expected " + ajustedDuration + " (adjusted reference), " + referenceDuration + " (raw reference)");
        }
    }

    public static void assertPerformance(double currentPerformance, long referencePerformance, double referenceBIPS) throws AssertionFailedError {
        double ajustedPerf = BogoPerf.adjustExpectedPerformance(referencePerformance, referenceBIPS);
        if (currentPerformance * (double)SLACK_FACTOR < ajustedPerf) {
            throw new AssertionFailedError(currentPerformance + " below expected " + ajustedPerf + " (adjusted), " + referencePerformance + " (raw)");
        }
    }

    private static double adjustExpectedPerformance(long referenceDuration, double referenceBIPS) {
        double currentBIPS = BogoPerf.currentBIPS();
        return (double)referenceDuration * (currentBIPS / referenceBIPS);
    }

    private static double adjustExpectedDuration(long referenceDuration, double referenceBIPS) {
        double currentBIPS = BogoPerf.currentBIPS();
        System.out.println("currentBIPS=" + currentBIPS + " BIPS");
        return (double)referenceDuration * (referenceBIPS / currentBIPS);
    }

    static {
        BogoPerf.computeBogoIPS(INITIAL_N);
        double bogo_ips = BogoPerf.computeBogoIPS(INITIAL_N);
        System.out.println("Host runs at " + bogo_ips + " BIPS");
    }
}

