/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.api.LogOutput;

public class SonarQubeTask
extends DefaultTask {
    private static final Logger LOGGER = Logging.getLogger(SonarQubeTask.class);
    public static final LogOutput LOG_OUTPUT = new DefaultLogOutput();
    private Map<String, Object> sonarProperties;

    @TaskAction
    public void run() {
        Map<String, Object> properties = this.getProperties();
        Properties propertiesObject = new Properties();
        propertiesObject.putAll(properties);
        if (LOGGER.isDebugEnabled()) {
            propertiesObject.put("sonar.verbose", "true");
        }
        if (SonarQubeTask.isSkip(propertiesObject)) {
            return;
        }
        EmbeddedScanner scanner = EmbeddedScanner.create((LogOutput)LOG_OUTPUT).setApp("Gradle", this.getProject().getGradle().getGradleVersion()).addGlobalProperties(propertiesObject);
        scanner.start();
        scanner.runAnalysis(propertiesObject);
        scanner.stop();
    }

    private static boolean isSkip(Properties properties) {
        if ("true".equalsIgnoreCase(properties.getProperty("sonar.scanner.skip"))) {
            LOGGER.warn("SonarQube Scanner analysis skipped");
            return true;
        }
        return false;
    }

    @Input
    public Map<String, Object> getProperties() {
        if (this.sonarProperties == null) {
            this.sonarProperties = new LinkedHashMap<String, Object>();
        }
        return this.sonarProperties;
    }

    private static class DefaultLogOutput
    implements LogOutput {
        private DefaultLogOutput() {
        }

        public void log(String formattedMessage, LogOutput.Level level) {
            switch (level) {
                case TRACE: {
                    LOGGER.trace(formattedMessage);
                    return;
                }
                case DEBUG: {
                    LOGGER.debug(formattedMessage);
                    return;
                }
                case INFO: {
                    LOGGER.info(formattedMessage);
                    return;
                }
                case WARN: {
                    LOGGER.warn(formattedMessage);
                    return;
                }
                case ERROR: {
                    LOGGER.error(formattedMessage);
                    return;
                }
            }
            throw new IllegalArgumentException(level.name());
        }
    }
}

