/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.job.flow.support.state;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.support.state.SplitState;
import org.springframework.batch.core.jsr.job.flow.support.JsrFlow;

public class JsrSplitState
extends SplitState {
    public JsrSplitState(Collection<Flow> flows, String name) {
        super(flows, name);
    }

    @Override
    protected FlowExecutionStatus doAggregation(Collection<FlowExecution> results, FlowExecutor executor) {
        ArrayList<String> stepNames = new ArrayList<String>();
        for (Flow curFlow : this.getFlows()) {
            JsrFlow flow = (JsrFlow)curFlow;
            if (flow.getMostRecentStepName() == null) continue;
            stepNames.add(flow.getMostRecentStepName());
        }
        if (!stepNames.isEmpty()) {
            executor.getJobExecution().getExecutionContext().put("batch.lastSteps", stepNames);
        }
        executor.getJobExecution().setExitStatus(null);
        return super.doAggregation(results, executor);
    }
}

