/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeItemProcessListener<T, S>
implements ItemProcessListener<T, S> {
    private OrderedComposite<ItemProcessListener<? super T, ? super S>> listeners = new OrderedComposite();

    public void setListeners(List<? extends ItemProcessListener<? super T, ? super S>> itemReadListeners) {
        this.listeners.setItems(itemReadListeners);
    }

    public void register(ItemProcessListener<? super T, ? super S> itemReaderListener) {
        this.listeners.add(itemReaderListener);
    }

    @Override
    public void afterProcess(T item, S result) {
        Iterator<ItemProcessListener<T, S>> iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ItemProcessListener<T, S> listener = iterator.next();
            listener.afterProcess(item, result);
        }
    }

    @Override
    public void beforeProcess(T item) {
        Iterator<ItemProcessListener<T, S>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemProcessListener<T, S> listener = iterator.next();
            listener.beforeProcess(item);
        }
    }

    @Override
    public void onProcessError(T item, Exception e) {
        Iterator<ItemProcessListener<T, S>> iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ItemProcessListener<T, S> listener = iterator.next();
            listener.onProcessError(item, e);
        }
    }
}

