/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import javax.batch.operations.BatchRuntimeException;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.UncheckedTransactionException;
import org.springframework.util.Assert;

public class ChunkListenerAdapter
implements ChunkListener {
    private final javax.batch.api.chunk.listener.ChunkListener delegate;

    public ChunkListenerAdapter(javax.batch.api.chunk.listener.ChunkListener delegate) {
        Assert.notNull((Object)delegate, (String)"A ChunkListener is required");
        this.delegate = delegate;
    }

    @Override
    public void beforeChunk(ChunkContext context) {
        try {
            this.delegate.beforeChunk();
        }
        catch (Exception e) {
            throw new UncheckedTransactionException(e);
        }
    }

    @Override
    public void afterChunk(ChunkContext context) {
        try {
            this.delegate.afterChunk();
        }
        catch (Exception e) {
            throw new UncheckedTransactionException(e);
        }
    }

    @Override
    public void afterChunkError(ChunkContext context) {
        if (context != null) {
            try {
                this.delegate.onError((Exception)context.getAttribute("sb_rollback_exception"));
            }
            catch (Exception e) {
                throw new UncheckedTransactionException(e);
            }
        } else {
            throw new BatchRuntimeException("Unable to retrieve causing exception due to null ChunkContext");
        }
    }
}

