/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.job;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.job.SimpleStepHandler;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JsrStepHandler
extends SimpleStepHandler {
    private static final Log logger = LogFactory.getLog(JsrStepHandler.class);
    private JobExplorer jobExplorer;

    public JsrStepHandler(JobRepository jobRepository, JobExplorer jobExplorer) {
        super(jobRepository, new ExecutionContext());
        this.jobExplorer = jobExplorer;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state((this.jobExplorer != null ? 1 : 0) != 0, (String)"A JobExplorer must be provided");
    }

    @Override
    protected boolean shouldStart(StepExecution lastStepExecution, JobExecution jobExecution, Step step) throws JobRestartException, StartLimitExceededException {
        BatchStatus stepStatus;
        String restartStep = null;
        if (lastStepExecution == null) {
            jobExecution.getExecutionContext().put("batch.startedStep", (Object)step.getName());
            stepStatus = BatchStatus.STARTING;
        } else {
            stepStatus = lastStepExecution.getStatus();
            JobExecution lastJobExecution = this.getLastJobExecution(jobExecution);
            if (lastJobExecution.getExecutionContext().containsKey("batch.restartStep")) {
                restartStep = lastJobExecution.getExecutionContext().getString("batch.restartStep");
                if (CollectionUtils.isEmpty(jobExecution.getStepExecutions()) && lastJobExecution.getStatus() == BatchStatus.STOPPED && StringUtils.hasText((String)restartStep)) {
                    if (!restartStep.equals(step.getName()) && !jobExecution.getExecutionContext().containsKey("batch.startedStep")) {
                        logger.info((Object)("Job was stopped and should restart at step " + restartStep + ".  The current step is " + step.getName()));
                        return false;
                    }
                    jobExecution.getExecutionContext().put("batch.startedStep", (Object)step.getName());
                }
            }
        }
        if (stepStatus == BatchStatus.UNKNOWN) {
            throw new JobRestartException("Cannot restart step from UNKNOWN status. The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed. Manual intervention is probably necessary.");
        }
        if (stepStatus == BatchStatus.COMPLETED && !step.isAllowStartIfComplete() || stepStatus == BatchStatus.ABANDONED) {
            logger.info((Object)("Step already complete or not restartable, so no action to execute: " + lastStepExecution));
            return false;
        }
        if (this.getJobRepository().getStepExecutionCount(jobExecution.getJobInstance(), step.getName()) < step.getStartLimit()) {
            return true;
        }
        throw new StartLimitExceededException("Maximum start limit exceeded for step: " + step.getName() + "StartMax: " + step.getStartLimit());
    }

    private JobExecution getLastJobExecution(JobExecution jobExecution) {
        List<JobExecution> jobExecutions = this.jobExplorer.getJobExecutions(jobExecution.getJobInstance());
        JobExecution lastJobExecution = null;
        for (JobExecution curJobExecution : jobExecutions) {
            if (lastJobExecution == null && curJobExecution.getId().longValue() != jobExecution.getId().longValue()) {
                lastJobExecution = curJobExecution;
                continue;
            }
            if (curJobExecution.getId().longValue() == jobExecution.getId().longValue() || lastJobExecution != null && curJobExecution.getId() <= lastJobExecution.getId()) continue;
            lastJobExecution = curJobExecution;
        }
        return lastJobExecution;
    }
}

