/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.partition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.batch.api.partition.PartitionAnalyzer;
import javax.batch.api.partition.PartitionMapper;
import javax.batch.api.partition.PartitionPlan;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext;
import org.springframework.batch.core.jsr.partition.JsrStepExecutionSplitter;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;

public class JsrPartitionHandler
implements PartitionHandler,
InitializingBean {
    private Queue<Serializable> partitionDataQueue;
    private ReentrantLock lock;
    private Step step;
    private int partitions;
    private PartitionAnalyzer analyzer;
    private PartitionMapper mapper;
    private int threads;
    private BatchPropertyContext propertyContext;
    private JobRepository jobRepository;
    private boolean allowStartIfComplete = false;
    private Set<String> partitionStepNames = new HashSet<String>();

    public Step getStep() {
        return this.step;
    }

    public Collection<String> getPartitionStepNames() {
        return this.partitionStepNames;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public void setPartitionDataQueue(Queue<Serializable> queue) {
        this.partitionDataQueue = queue;
    }

    public void setPartitionLock(ReentrantLock lock) {
        this.lock = lock;
    }

    public void setPropertyContext(BatchPropertyContext context) {
        this.propertyContext = context;
    }

    public void setPartitionMapper(PartitionMapper mapper) {
        this.mapper = mapper;
    }

    public void setStep(Step step) {
        this.step = step;
    }

    public void setPartitionAnalyzer(PartitionAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<StepExecution> handle(StepExecutionSplitter stepSplitter, StepExecution stepExecution) throws Exception {
        ArrayList<Future<StepExecution>> tasks = new ArrayList<Future<StepExecution>>();
        HashSet<StepExecution> result = new HashSet<StepExecution>();
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        int stepExecutionCount = this.jobRepository.getStepExecutionCount(stepExecution.getJobExecution().getJobInstance(), stepExecution.getStepName());
        boolean isRestart = stepExecutionCount > 1;
        Set<StepExecution> partitionStepExecutions = this.splitStepExecution(stepExecution, isRestart);
        for (StepExecution curStepExecution : partitionStepExecutions) {
            this.partitionStepNames.add(curStepExecution.getStepName());
        }
        taskExecutor.setCorePoolSize(this.threads);
        taskExecutor.setMaxPoolSize(this.threads);
        taskExecutor.initialize();
        try {
            for (StepExecution curStepExecution : partitionStepExecutions) {
                FutureTask<StepExecution> task = this.createTask(this.step, curStepExecution);
                try {
                    taskExecutor.execute(task);
                    tasks.add(task);
                }
                catch (TaskRejectedException e) {
                    ExitStatus exitStatus = ExitStatus.FAILED.addExitDescription("TaskExecutor rejected the task for this step.");
                    curStepExecution.setStatus(BatchStatus.FAILED);
                    curStepExecution.setExitStatus(exitStatus);
                    result.add(stepExecution);
                }
            }
            this.processPartitionResults(tasks, result);
        }
        finally {
            taskExecutor.shutdown();
        }
        return result;
    }

    private void processPartitionResults(List<Future<StepExecution>> tasks, Set<StepExecution> result) throws Exception {
        while (true) {
            try {
                this.lock.lock();
                while (!this.partitionDataQueue.isEmpty()) {
                    this.analyzer.analyzeCollectorData(this.partitionDataQueue.remove());
                }
                this.processFinishedPartitions(tasks, result);
                if (tasks.size() != 0) continue;
            }
            finally {
                if (!this.lock.isHeldByCurrentThread()) continue;
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    private Set<StepExecution> splitStepExecution(StepExecution stepExecution, boolean isRestart) throws Exception, JobExecutionException {
        Set<Object> partitionStepExecutions = new HashSet();
        if (isRestart) {
            if (this.mapper != null) {
                PartitionPlan plan = this.mapper.mapPartitions();
                if (plan.getPartitionsOverride()) {
                    partitionStepExecutions = this.applyPartitionPlan(stepExecution, plan, false);
                    for (StepExecution stepExecution2 : partitionStepExecutions) {
                        stepExecution2.setExecutionContext(new ExecutionContext());
                    }
                } else {
                    Properties[] partitionProps = plan.getPartitionProperties();
                    plan = (PartitionPlanState)stepExecution.getExecutionContext().get("partitionPlanState");
                    plan.setPartitionProperties(partitionProps);
                    partitionStepExecutions = this.applyPartitionPlan(stepExecution, plan, true);
                }
            } else {
                JsrStepExecutionSplitter stepSplitter = new JsrStepExecutionSplitter(this.jobRepository, this.allowStartIfComplete, stepExecution.getStepName(), true);
                partitionStepExecutions = stepSplitter.split(stepExecution, this.partitions);
            }
        } else if (this.mapper != null) {
            PartitionPlan plan = this.mapper.mapPartitions();
            partitionStepExecutions = this.applyPartitionPlan(stepExecution, plan, true);
        } else {
            JsrStepExecutionSplitter stepSplitter = new JsrStepExecutionSplitter(this.jobRepository, this.allowStartIfComplete, stepExecution.getStepName(), true);
            partitionStepExecutions = stepSplitter.split(stepExecution, this.partitions);
        }
        return partitionStepExecutions;
    }

    private Set<StepExecution> applyPartitionPlan(StepExecution stepExecution, PartitionPlan plan, boolean restoreState) throws JobExecutionException {
        if (plan.getThreads() > 0) {
            this.threads = plan.getThreads();
        } else if (plan.getPartitions() > 0) {
            this.threads = plan.getPartitions();
        } else {
            throw new IllegalArgumentException("Either a number of threads or partitions are required");
        }
        stepExecution.getExecutionContext().put("partitionPlanState", (Object)new PartitionPlanState(plan));
        JsrStepExecutionSplitter stepSplitter = new JsrStepExecutionSplitter(this.jobRepository, this.allowStartIfComplete, stepExecution.getStepName(), restoreState);
        Set<StepExecution> partitionStepExecutions = stepSplitter.split(stepExecution, plan.getPartitions());
        this.registerPartitionProperties(partitionStepExecutions, plan);
        return partitionStepExecutions;
    }

    private void processFinishedPartitions(List<Future<StepExecution>> tasks, Set<StepExecution> result) throws Exception {
        for (int i = 0; i < tasks.size(); ++i) {
            Future<StepExecution> curTask = tasks.get(i);
            if (!curTask.isDone()) continue;
            StepExecution curStepExecution = curTask.get();
            if (this.analyzer != null) {
                this.analyzer.analyzeStatus(curStepExecution.getStatus().getBatchStatus(), curStepExecution.getExitStatus().getExitCode());
            }
            result.add(curStepExecution);
            tasks.remove(i);
            --i;
        }
    }

    private void registerPartitionProperties(Set<StepExecution> partitionStepExecutions, PartitionPlan plan) {
        Properties[] partitionProperties = plan.getPartitionProperties();
        if (partitionProperties != null) {
            Iterator<StepExecution> executions = partitionStepExecutions.iterator();
            int i = 0;
            while (executions.hasNext()) {
                StepExecution curExecution = executions.next();
                if (i >= partitionProperties.length) break;
                Properties partitionPropertyValues = partitionProperties[i];
                if (partitionPropertyValues != null) {
                    this.propertyContext.setStepProperties(curExecution.getStepName(), partitionPropertyValues);
                }
                ++i;
            }
        }
    }

    protected FutureTask<StepExecution> createTask(final Step step, final StepExecution stepExecution) {
        return new FutureTask<StepExecution>(new Callable<StepExecution>(){

            @Override
            public StepExecution call() throws Exception {
                step.execute(stepExecution);
                return stepExecution;
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.propertyContext, (String)"A BatchPropertyContext is required");
        Assert.isTrue((this.mapper != null || this.threads > 0 || this.partitions > 0 ? 1 : 0) != 0, (String)"Either a mapper implementation or the number of partitions/threads is required");
        Assert.notNull((Object)this.jobRepository, (String)"A JobRepository is required");
        if (this.partitionDataQueue == null) {
            this.partitionDataQueue = new LinkedBlockingQueue<Serializable>();
        }
        if (this.lock == null) {
            this.lock = new ReentrantLock();
        }
    }

    public static class PartitionPlanState
    implements PartitionPlan,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Properties[] partitionProperties;
        private int partitions;
        private int threads;

        public PartitionPlanState(PartitionPlan plan) {
            this.partitionProperties = plan.getPartitionProperties();
            this.partitions = plan.getPartitions();
            this.threads = plan.getThreads();
        }

        public Properties[] getPartitionProperties() {
            return this.partitionProperties;
        }

        public int getPartitions() {
            return this.partitions;
        }

        public int getThreads() {
            return this.threads;
        }

        public void setPartitions(int count) {
            this.partitions = count;
        }

        public void setPartitionsOverride(boolean override) {
        }

        public boolean getPartitionsOverride() {
            return false;
        }

        public void setThreads(int count) {
            this.threads = count;
        }

        public void setPartitionProperties(Properties[] props) {
            this.partitionProperties = props;
        }
    }
}

