/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.context;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext;

public abstract class SynchronizationManagerSupport<E, C> {
    private final ThreadLocal<Stack<E>> executionHolder = new ThreadLocal();
    private final Map<E, AtomicInteger> counts = new ConcurrentHashMap<E, AtomicInteger>();
    private final Map<E, C> contexts = new ConcurrentHashMap<E, C>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C getContext() {
        if (this.getCurrent().isEmpty()) {
            return null;
        }
        Map<E, C> map = this.contexts;
        synchronized (map) {
            return this.contexts.get(this.getCurrent().peek());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C register(E execution) {
        C context;
        if (execution == null) {
            return null;
        }
        this.getCurrent().push(execution);
        Map<E, C> map = this.contexts;
        synchronized (map) {
            context = this.contexts.get(execution);
            if (context == null) {
                context = this.createNewContext(execution, null);
                this.contexts.put(execution, context);
            }
        }
        this.increment();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C register(E execution, BatchPropertyContext propertyContext) {
        C context;
        if (execution == null) {
            return null;
        }
        this.getCurrent().push(execution);
        Map<E, C> map = this.contexts;
        synchronized (map) {
            context = this.contexts.get(execution);
            if (context == null) {
                context = this.createNewContext(execution, propertyContext);
                this.contexts.put(execution, context);
            }
        }
        this.increment();
        return context;
    }

    public void close() {
        C oldSession = this.getContext();
        if (oldSession == null) {
            return;
        }
        this.decrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrement() {
        int remaining;
        E current = this.getCurrent().pop();
        if (current != null && (remaining = this.counts.get(current).decrementAndGet()) <= 0) {
            Map<E, C> map = this.contexts;
            synchronized (map) {
                this.contexts.remove(current);
                this.counts.remove(current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        E current = this.getCurrent().peek();
        if (current != null) {
            AtomicInteger count;
            Map<E, AtomicInteger> map = this.counts;
            synchronized (map) {
                count = this.counts.get(current);
                if (count == null) {
                    count = new AtomicInteger();
                    this.counts.put(current, count);
                }
            }
            count.incrementAndGet();
        }
    }

    public Stack<E> getCurrent() {
        if (this.executionHolder.get() == null) {
            this.executionHolder.set(new Stack());
        }
        return this.executionHolder.get();
    }

    public void release() {
        C context = this.getContext();
        try {
            if (context != null) {
                this.close(context);
            }
        }
        finally {
            this.close();
        }
    }

    protected abstract void close(C var1);

    protected abstract C createNewContext(E var1, BatchPropertyContext var2);
}

