/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.data.AbstractNeo4jItemReader;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.util.ClassUtils;

public class Neo4jItemReader<T>
extends AbstractNeo4jItemReader {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ResultConverter<Map<String, Object>, T> resultConverter;

    public Neo4jItemReader() {
        this.setName(ClassUtils.getShortName(Neo4jItemReader.class));
    }

    public void setResultConverter(ResultConverter<Map<String, Object>, T> resultConverter) {
        this.resultConverter = resultConverter;
    }

    @Override
    protected Iterator<T> doPageRead() {
        Result queryResults = this.getTemplate().query(this.generateLimitCypherQuery(), this.getParameterValues());
        if (queryResults != null) {
            if (this.resultConverter != null) {
                return queryResults.to(this.getTargetType(), this.resultConverter).iterator();
            }
            return queryResults.to(this.getTargetType()).iterator();
        }
        return new ArrayList().iterator();
    }
}

