/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.xml;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cloud.config.xml.AbstractNestedElementCloudServiceFactoryParser;
import org.springframework.cloud.service.document.MongoDbFactoryFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CloudMongoDbFactoryParser
extends AbstractNestedElementCloudServiceFactoryParser {
    private static final String WRITE_CONCERN = "write-concern";
    private static final String MAX_WAIT_TIME = "max-wait-time";
    private static final String CONNECTIONS_PER_HOST = "connections-per-host";
    private static final String ELEMENT_MONGO_OPTIONS = "mongo-options";

    public CloudMongoDbFactoryParser() {
        super(MongoDbFactoryFactory.class);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        this.parseWriteConcern(element, attributeMap);
        this.parseMongoOptionsElement(element, parserContext, attributeMap);
        BeanDefinitionBuilder cloudMongoConfigurationBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.cloud.service.document.MongoDbFactoryConfig");
        for (String key : new String[]{WRITE_CONCERN, CONNECTIONS_PER_HOST, MAX_WAIT_TIME}) {
            String value = (String)attributeMap.get(key);
            cloudMongoConfigurationBeanBuilder.addConstructorArgValue((Object)value);
        }
        builder.addConstructorArgValue((Object)cloudMongoConfigurationBeanBuilder.getBeanDefinition());
    }

    private void parseWriteConcern(Element element, Map<String, String> attributeMap) {
        String writeConcern = element.getAttribute(WRITE_CONCERN);
        if (StringUtils.hasText((String)writeConcern)) {
            attributeMap.put(WRITE_CONCERN, writeConcern);
        }
    }

    private void parseMongoOptionsElement(Element element, ParserContext parserContext, Map<String, String> attributeMap) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String maxWaitTime;
            Node child = childNodes.item(i);
            if (!this.isElement(child, parserContext, ELEMENT_MONGO_OPTIONS)) continue;
            Element optionElement = (Element)child;
            String connectionsPerHost = optionElement.getAttribute(CONNECTIONS_PER_HOST);
            if (StringUtils.hasText((String)connectionsPerHost)) {
                attributeMap.put(CONNECTIONS_PER_HOST, connectionsPerHost);
            }
            if (!StringUtils.hasText((String)(maxWaitTime = optionElement.getAttribute(MAX_WAIT_TIME)))) continue;
            attributeMap.put(MAX_WAIT_TIME, maxWaitTime);
        }
    }
}

