/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.NumberUtils;

final class BinaryConverters {
    public static final Charset CHARSET = Charset.forName("UTF-8");

    private BinaryConverters() {
    }

    @ReadingConverter
    static class BytesToDateConverter
    extends StringBasedConverter
    implements Converter<byte[], Date> {
        BytesToDateConverter() {
        }

        public Date convert(byte[] source) {
            if (source == null || source.length == 0) {
                return null;
            }
            String value = this.toString(source);
            try {
                return new Date((Long)NumberUtils.parseNumber((String)value, Long.class));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return DateFormat.getInstance().parse(value);
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException("Cannot parse date out of " + source);
                }
            }
        }
    }

    @WritingConverter
    static class DateToBytesConverter
    extends StringBasedConverter
    implements Converter<Date, byte[]> {
        DateToBytesConverter() {
        }

        public byte[] convert(Date source) {
            if (source == null) {
                return new byte[0];
            }
            return this.fromString(Long.toString(source.getTime()));
        }
    }

    @ReadingConverter
    static class BytesToBooleanConverter
    extends StringBasedConverter
    implements Converter<byte[], Boolean> {
        BytesToBooleanConverter() {
        }

        public Boolean convert(byte[] source) {
            if (source == null || source.length == 0) {
                return null;
            }
            String value = this.toString(source);
            return "1".equals(value) || "true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    @WritingConverter
    static class BooleanToBytesConverter
    extends StringBasedConverter
    implements Converter<Boolean, byte[]> {
        final byte[] _true = this.fromString("1");
        final byte[] _false = this.fromString("0");

        BooleanToBytesConverter() {
        }

        public byte[] convert(Boolean source) {
            if (source == null) {
                return new byte[0];
            }
            return source != false ? this._true : this._false;
        }
    }

    @ReadingConverter
    static class BytesToNumberConverterFactory
    implements ConverterFactory<byte[], Number> {
        BytesToNumberConverterFactory() {
        }

        public <T extends Number> Converter<byte[], T> getConverter(Class<T> targetType) {
            return new BytesToNumberConverter<T>(targetType);
        }

        private static final class BytesToNumberConverter<T extends Number>
        extends StringBasedConverter
        implements Converter<byte[], T> {
            private final Class<T> targetType;

            public BytesToNumberConverter(Class<T> targetType) {
                this.targetType = targetType;
            }

            public T convert(byte[] source) {
                if (source == null || source.length == 0) {
                    return null;
                }
                return (T)NumberUtils.parseNumber((String)this.toString(source), this.targetType);
            }
        }
    }

    @ReadingConverter
    static final class BytesToEnumConverterFactory
    implements ConverterFactory<byte[], Enum<?>> {
        BytesToEnumConverterFactory() {
        }

        public <T extends Enum<?>> Converter<byte[], T> getConverter(Class<T> targetType) {
            Class<T> enumType;
            for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
            }
            if (enumType == null) {
                throw new IllegalArgumentException("The target type " + targetType.getName() + " does not refer to an enum");
            }
            return new BytesToEnum<T>(enumType);
        }

        private class BytesToEnum<T extends Enum<T>>
        extends StringBasedConverter
        implements Converter<byte[], T> {
            private final Class<T> enumType;

            public BytesToEnum(Class<T> enumType) {
                this.enumType = enumType;
            }

            public T convert(byte[] source) {
                String value = this.toString(source);
                if (value == null || value.length() == 0) {
                    return null;
                }
                return Enum.valueOf(this.enumType, value.trim());
            }
        }
    }

    @WritingConverter
    static class EnumToBytesConverter
    extends StringBasedConverter
    implements Converter<Enum<?>, byte[]> {
        EnumToBytesConverter() {
        }

        public byte[] convert(Enum<?> source) {
            if (source == null) {
                return new byte[0];
            }
            return this.fromString(source.toString());
        }
    }

    @WritingConverter
    static class NumberToBytesConverter
    extends StringBasedConverter
    implements Converter<Number, byte[]> {
        NumberToBytesConverter() {
        }

        public byte[] convert(Number source) {
            if (source == null) {
                return new byte[0];
            }
            return this.fromString(source.toString());
        }
    }

    @ReadingConverter
    static class BytesToStringConverter
    extends StringBasedConverter
    implements Converter<byte[], String> {
        BytesToStringConverter() {
        }

        public String convert(byte[] source) {
            return this.toString(source);
        }
    }

    @WritingConverter
    static class StringToBytesConverter
    extends StringBasedConverter
    implements Converter<String, byte[]> {
        StringToBytesConverter() {
        }

        public byte[] convert(String source) {
            return this.fromString(source);
        }
    }

    static class StringBasedConverter {
        StringBasedConverter() {
        }

        byte[] fromString(String source) {
            if (source == null) {
                return new byte[0];
            }
            return source.getBytes(CHARSET);
        }

        String toString(byte[] source) {
            return new String(source, CHARSET);
        }
    }
}

