/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.IResultListener2;

public class TestListenerAdapter
implements IResultListener2 {
    private List<ITestNGMethod> m_allTestMethods = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestResult> m_passedTests = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestResult> m_failedTests = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestResult> m_skippedTests = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestResult> m_failedButWSPerTests = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestContext> m_testContexts = Collections.synchronizedList(new ArrayList());
    private List<ITestResult> m_failedConfs = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestResult> m_skippedConfs = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestResult> m_passedConfs = Collections.synchronizedList(Lists.newArrayList());

    @Override
    public void onTestSuccess(ITestResult iTestResult) {
        this.m_allTestMethods.add(iTestResult.getMethod());
        this.m_passedTests.add(iTestResult);
    }

    @Override
    public void onTestFailure(ITestResult iTestResult) {
        this.m_allTestMethods.add(iTestResult.getMethod());
        this.m_failedTests.add(iTestResult);
    }

    @Override
    public void onTestSkipped(ITestResult iTestResult) {
        this.m_allTestMethods.add(iTestResult.getMethod());
        this.m_skippedTests.add(iTestResult);
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        this.m_allTestMethods.add(iTestResult.getMethod());
        this.m_failedButWSPerTests.add(iTestResult);
    }

    protected ITestNGMethod[] getAllTestMethods() {
        return this.m_allTestMethods.toArray(new ITestNGMethod[this.m_allTestMethods.size()]);
    }

    @Override
    public void onStart(ITestContext iTestContext) {
        this.m_testContexts.add(iTestContext);
    }

    @Override
    public void onFinish(ITestContext iTestContext) {
    }

    public List<ITestResult> getFailedButWithinSuccessPercentageTests() {
        return new ArrayList<ITestResult>(this.m_failedButWSPerTests);
    }

    public List<ITestResult> getFailedTests() {
        return new ArrayList<ITestResult>(this.m_failedTests);
    }

    public List<ITestResult> getPassedTests() {
        return new ArrayList<ITestResult>(this.m_passedTests);
    }

    public List<ITestResult> getSkippedTests() {
        return new ArrayList<ITestResult>(this.m_skippedTests);
    }

    private static void ppp(String string) {
        System.out.println("[TestListenerAdapter] " + string);
    }

    public void setAllTestMethods(List<ITestNGMethod> list) {
        this.m_allTestMethods = list;
    }

    public void setFailedButWithinSuccessPercentageTests(List<ITestResult> list) {
        this.m_failedButWSPerTests = list;
    }

    public void setFailedTests(List<ITestResult> list) {
        this.m_failedTests = list;
    }

    public void setPassedTests(List<ITestResult> list) {
        this.m_passedTests = list;
    }

    public void setSkippedTests(List<ITestResult> list) {
        this.m_skippedTests = list;
    }

    @Override
    public void onTestStart(ITestResult iTestResult) {
    }

    public List<ITestContext> getTestContexts() {
        return this.m_testContexts;
    }

    public List<ITestResult> getConfigurationFailures() {
        return this.m_failedConfs;
    }

    @Override
    public void onConfigurationFailure(ITestResult iTestResult) {
        this.m_failedConfs.add(iTestResult);
    }

    public List<ITestResult> getConfigurationSkips() {
        return this.m_skippedConfs;
    }

    @Override
    public void beforeConfiguration(ITestResult iTestResult) {
    }

    @Override
    public void onConfigurationSkip(ITestResult iTestResult) {
        this.m_skippedConfs.add(iTestResult);
    }

    @Override
    public void onConfigurationSuccess(ITestResult iTestResult) {
        this.m_passedConfs.add(iTestResult);
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("passed", this.getPassedTests().size()).add("failed", this.getFailedTests().size()).add("skipped", this.getSkippedTests().size()).toString();
    }
}

