/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.testng.ReporterConfig;
import org.testng.TestNG;
import org.testng.collections.Lists;
import org.testng.internal.Utils;

public class TestNGAntTask
extends Task {
    protected CommandlineJava m_javaCommand;
    protected List<ResourceCollection> m_xmlFilesets = Lists.newArrayList();
    protected List<ResourceCollection> m_classFilesets = Lists.newArrayList();
    protected File m_outputDir;
    protected File m_testjar;
    protected File m_workingDir;
    private Integer m_timeout;
    private List<String> m_listeners = Lists.newArrayList();
    private List<String> m_methodselectors = Lists.newArrayList();
    private String m_objectFactory;
    protected String m_testRunnerFactory;
    private boolean m_delegateCommandSystemProperties = false;
    protected Environment m_environment = new Environment();
    protected String m_mainClass = TestNG.class.getName();
    protected boolean m_dump;
    private boolean m_dumpEnv;
    private boolean m_dumpSys;
    protected boolean m_assertEnabled = true;
    protected boolean m_haltOnFailure;
    protected String m_onHaltTarget;
    protected String m_failurePropertyName;
    protected boolean m_haltOnSkipped;
    protected String m_skippedPropertyName;
    protected boolean m_haltOnFSP;
    protected String m_fspPropertyName;
    protected String m_includedGroups;
    protected String m_excludedGroups;
    protected String m_parallelMode;
    protected String m_threadCount;
    protected String m_dataproviderthreadCount;
    protected String m_configFailurePolicy;
    protected Boolean m_randomizeSuites;
    public String m_useDefaultListeners;
    private String m_suiteName = "Ant suite";
    private String m_testName = "Ant test";
    private Boolean m_skipFailedInvocationCounts;
    private String m_methods;
    private Mode mode = Mode.testng;
    private List<ReporterConfig> reporterConfigs = Lists.newArrayList();
    private String m_testNames = "";
    private Integer m_verbose = null;
    private Integer m_suiteThreadPoolSize;
    private String m_xmlPathInJar;

    public void setParallel(String string) {
        this.m_parallelMode = string;
    }

    public void setThreadCount(String string) {
        this.m_threadCount = string;
    }

    public void setDataProviderThreadCount(String string) {
        this.m_dataproviderthreadCount = string;
    }

    public void setUseDefaultListeners(String string) {
        this.m_useDefaultListeners = string;
    }

    public void setHaltonfailure(boolean bl) {
        this.m_haltOnFailure = bl;
    }

    public void setOnHaltTarget(String string) {
        this.m_onHaltTarget = string;
    }

    public void setFailureProperty(String string) {
        this.m_failurePropertyName = string;
    }

    public void setHaltonskipped(boolean bl) {
        this.m_haltOnSkipped = bl;
    }

    public void setSkippedProperty(String string) {
        this.m_skippedPropertyName = string;
    }

    public void setHaltonFSP(boolean bl) {
        this.m_haltOnFSP = bl;
    }

    public void setFSPProperty(String string) {
        this.m_fspPropertyName = string;
    }

    public void setDelegateCommandSystemProperties(boolean bl) {
        this.m_delegateCommandSystemProperties = bl;
    }

    public void setDumpCommand(boolean bl) {
        this.m_dump = bl;
    }

    public void setDumpEnv(boolean bl) {
        this.m_dumpEnv = bl;
    }

    public void setDumpSys(boolean bl) {
        this.m_dumpSys = bl;
    }

    public void setEnableAssert(boolean bl) {
        this.m_assertEnabled = bl;
    }

    public void setWorkingDir(File file) {
        this.m_workingDir = file;
    }

    public void setJvm(String string) {
        this.getJavaCommand().setVm(string);
    }

    public void setTimeout(Integer n) {
        this.m_timeout = n;
    }

    public Commandline.Argument createJvmarg() {
        return this.getJavaCommand().createVmArgument();
    }

    public void addSysproperty(Environment.Variable variable) {
        this.getJavaCommand().addSysproperty(variable);
    }

    public void addEnv(Environment.Variable variable) {
        this.m_environment.addVariable(variable);
    }

    public Path createClasspath() {
        return this.getJavaCommand().createClasspath(this.getProject()).createPath();
    }

    public Path createBootclasspath() {
        return this.getJavaCommand().createBootclasspath(this.getProject()).createPath();
    }

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void addXmlfileset(FileSet fileSet) {
        this.m_xmlFilesets.add((ResourceCollection)fileSet);
    }

    public void setXmlfilesetRef(Reference reference) {
        this.m_xmlFilesets.add(this.createResourceCollection(reference));
    }

    public void addClassfileset(FileSet fileSet) {
        this.m_classFilesets.add((ResourceCollection)this.appendClassSelector(fileSet));
    }

    public void setClassfilesetRef(Reference reference) {
        this.m_classFilesets.add(this.createResourceCollection(reference));
    }

    public void setTestNames(String string) {
        this.m_testNames = string;
    }

    public void setSuiteRunnerClass(String string) {
        this.m_mainClass = string;
    }

    public void setSuiteName(String string) {
        this.m_suiteName = string;
    }

    public void setTestName(String string) {
        this.m_testName = string;
    }

    public void setJUnit(boolean bl) {
        this.mode = bl ? Mode.junit : Mode.testng;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setOutputDir(File file) {
        this.m_outputDir = file;
    }

    public void setTestJar(File file) {
        this.m_testjar = file;
    }

    public void setGroups(String string) {
        this.m_includedGroups = string;
    }

    public void setExcludedGroups(String string) {
        this.m_excludedGroups = string;
    }

    public void setVerbose(Integer n) {
        this.m_verbose = n;
    }

    public void setReporter(String string) {
        this.m_listeners.add(string);
    }

    public void setObjectFactory(String string) {
        this.m_objectFactory = string;
    }

    public void setTestRunnerFactory(String string) {
        this.m_testRunnerFactory = string;
    }

    public void setSuiteThreadPoolSize(Integer n) {
        this.m_suiteThreadPoolSize = n;
    }

    @Deprecated
    public void setListener(String string) {
        this.m_listeners.add(string);
    }

    public void setListeners(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            this.m_listeners.add(stringTokenizer.nextToken());
        }
    }

    public void setMethodSelectors(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            this.m_methodselectors.add(stringTokenizer.nextToken());
        }
    }

    public void setConfigFailurePolicy(String string) {
        this.m_configFailurePolicy = string;
    }

    public void setRandomizeSuites(Boolean bl) {
        this.m_randomizeSuites = bl;
    }

    public void setMethods(String string) {
        this.m_methods = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File file;
        this.validateOptions();
        CommandlineJava commandlineJava = this.getJavaCommand();
        commandlineJava.setClassname(this.m_mainClass);
        if (this.m_assertEnabled) {
            commandlineJava.createVmArgument().setValue("-ea");
        }
        if (this.m_delegateCommandSystemProperties) {
            this.delegateCommandSystemProperties();
        }
        List<String> list = this.createArguments();
        String string = "";
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            file = File.createTempFile("testng", "");
            string = file.getAbsolutePath();
            if (!this.m_dump) {
                file.deleteOnExit();
            }
            outputStreamWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            for (String string2 : list) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.printDebugInfo(string);
        this.createClasspath().setLocation(this.findJar());
        commandlineJava.createArgument().setValue("@" + string);
        file = this.createWatchdog();
        boolean bl = false;
        int n = this.executeAsForked(commandlineJava, (ExecuteWatchdog)file);
        if (null != file) {
            bl = file.killedProcess();
        }
        this.actOnResult(n, bl);
    }

    private List<String> createArguments() {
        List<String> list = Lists.newArrayList();
        this.addBooleanIfTrue(list, "-junit", this.mode == Mode.junit);
        this.addBooleanIfTrue(list, "-mixed", this.mode == Mode.mixed);
        this.addBooleanIfTrue(list, "-skipfailedinvocationcounts", this.m_skipFailedInvocationCounts);
        this.addIntegerIfNotNull(list, "-log", this.m_verbose);
        this.addDefaultListeners(list);
        this.addOutputDir(list);
        this.addFileIfFile(list, "-testjar", this.m_testjar);
        this.addStringIfNotBlank(list, "-groups", this.m_includedGroups);
        this.addStringIfNotBlank(list, "-excludegroups", this.m_excludedGroups);
        this.addFilesOfRCollection(list, "-testclass", this.m_classFilesets);
        this.addListOfStringIfNotEmpty(list, "-listener", this.m_listeners);
        this.addListOfStringIfNotEmpty(list, "-methodselectors", this.m_methodselectors);
        this.addStringIfNotNull(list, "-objectfactory", this.m_objectFactory);
        this.addStringIfNotNull(list, "-testrunfactory", this.m_testRunnerFactory);
        this.addStringIfNotNull(list, "-parallel", this.m_parallelMode);
        this.addStringIfNotNull(list, "-configfailurepolicy", this.m_configFailurePolicy);
        this.addBooleanIfTrue(list, "-randomizesuites", this.m_randomizeSuites);
        this.addStringIfNotNull(list, "-threadcount", this.m_threadCount);
        this.addStringIfNotNull(list, "-dataproviderthreadcount", this.m_dataproviderthreadCount);
        this.addStringIfNotBlank(list, "-suitename", this.m_suiteName);
        this.addStringIfNotBlank(list, "-testname", this.m_testName);
        this.addStringIfNotBlank(list, "-testnames", this.m_testNames);
        this.addStringIfNotBlank(list, "-methods", this.m_methods);
        this.addReporterConfigs(list);
        this.addIntegerIfNotNull(list, "-suitethreadpoolsize", this.m_suiteThreadPoolSize);
        this.addStringIfNotNull(list, "-xmlpathinjar", this.m_xmlPathInJar);
        this.addXmlFiles(list);
        return list;
    }

    private void addDefaultListeners(List<String> list) {
        if (this.m_useDefaultListeners != null) {
            String string = "false";
            if ("yes".equalsIgnoreCase(this.m_useDefaultListeners) || "true".equalsIgnoreCase(this.m_useDefaultListeners)) {
                string = "true";
            }
            list.add("-usedefaultlisteners");
            list.add(string);
        }
    }

    private void addOutputDir(List<String> list) {
        if (null != this.m_outputDir) {
            if (!this.m_outputDir.exists()) {
                this.m_outputDir.mkdirs();
            }
            if (this.m_outputDir.isDirectory()) {
                list.add("-d");
                list.add(this.m_outputDir.getAbsolutePath());
            } else {
                throw new BuildException("Output directory is not a directory: " + this.m_outputDir);
            }
        }
    }

    private void addReporterConfigs(List<String> list) {
        for (ReporterConfig reporterConfig : this.reporterConfigs) {
            list.add("-reporter");
            list.add(reporterConfig.serialize());
        }
    }

    private void addFilesOfRCollection(List<String> list, String string, List<ResourceCollection> list2) {
        this.addArgumentsIfNotEmpty(list, string, this.getFiles(list2), ",");
    }

    private void addListOfStringIfNotEmpty(List<String> list, String string, List<String> list2) {
        this.addArgumentsIfNotEmpty(list, string, list2, ";");
    }

    private void addArgumentsIfNotEmpty(List<String> list, String string, List<String> list2, String string2) {
        if (list2 != null && !list2.isEmpty()) {
            list.add(string);
            String string3 = Utils.join(list2, string2);
            list.add(string3);
        }
    }

    private void addFileIfFile(List<String> list, String string, File file) {
        if (null != file && file.isFile()) {
            list.add(string);
            list.add(file.getAbsolutePath());
        }
    }

    private void addBooleanIfTrue(List<String> list, String string, Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            list.add(string);
        }
    }

    private void addIntegerIfNotNull(List<String> list, String string, Integer n) {
        if (n != null) {
            list.add(string);
            list.add(n.toString());
        }
    }

    private void addStringIfNotNull(List<String> list, String string, String string2) {
        if (string2 != null) {
            list.add(string);
            list.add(string2);
        }
    }

    private void addStringIfNotBlank(List<String> list, String string, String string2) {
        if (Utils.isStringNotBlank(string2)) {
            list.add(string);
            list.add(string2);
        }
    }

    private void addXmlFiles(List<String> list) {
        for (String string : this.getSuiteFileNames()) {
            list.add(string);
        }
    }

    protected List<String> getSuiteFileNames() {
        List<String> list = Lists.newArrayList();
        for (String string : this.getFiles(this.m_xmlFilesets)) {
            list.add(string);
        }
        return list;
    }

    private void delegateCommandSystemProperties() {
        for (Object k : this.getProject().getUserProperties().keySet()) {
            String string = (String)k;
            String string2 = this.getProject().getUserProperty(string);
            if (string.startsWith("ant.")) {
                this.log("Excluding ant property: " + string + ": " + string2, 4);
                continue;
            }
            this.log("Including user property: " + string + ": " + string2, 4);
            Environment.Variable variable = new Environment.Variable();
            variable.setKey(string);
            variable.setValue(string2);
            this.addSysproperty(variable);
        }
    }

    private void printDebugInfo(String string) {
        String[] stringArray;
        if (this.m_dumpSys) {
            System.out.println("* SYSTEM PROPERTIES *");
            stringArray = System.getProperties();
            String[] stringArray2 = stringArray.propertyNames();
            while (stringArray2.hasMoreElements()) {
                String string2 = (String)stringArray2.nextElement();
                System.out.println(string2 + ": " + stringArray.getProperty(string2));
            }
            System.out.println("");
        }
        if (this.m_dumpEnv && null != (stringArray = this.m_environment.getVariables()) && stringArray.length > 0) {
            System.out.println("* ENVIRONMENT *");
            for (String string3 : stringArray) {
                System.out.println(string3);
            }
            System.out.println("");
        }
        if (this.m_dump) {
            this.dumpCommand(string);
        }
    }

    private void ppp(String string) {
        System.out.println("[TestNGAntTask] " + string);
    }

    protected void actOnResult(int n, boolean bl) {
        boolean bl2;
        if (n == -1) {
            this.executeHaltTarget(n);
            throw new BuildException("an error occured when running TestNG tests");
        }
        if ((n & 8) == 8) {
            if (this.m_haltOnFailure) {
                this.executeHaltTarget(n);
                throw new BuildException("No tests were run");
            }
            if (null != this.m_failurePropertyName) {
                this.getProject().setNewProperty(this.m_failurePropertyName, "true");
            }
            this.log("TestNG haven't found any tests to be run", 4);
        }
        boolean bl3 = bl2 = (n & 1) == 1 || bl;
        if (bl2) {
            String string;
            String string2 = string = bl ? "The tests timed out and were killed." : "The tests failed.";
            if (this.m_haltOnFailure) {
                this.executeHaltTarget(n);
                throw new BuildException(string);
            }
            if (null != this.m_failurePropertyName) {
                this.getProject().setNewProperty(this.m_failurePropertyName, "true");
            }
            this.log(string, 2);
        }
        if ((n & 2) == 2) {
            if (this.m_haltOnSkipped) {
                this.executeHaltTarget(n);
                throw new BuildException("There are TestNG SKIPPED tests");
            }
            if (null != this.m_skippedPropertyName) {
                this.getProject().setNewProperty(this.m_skippedPropertyName, "true");
            }
            this.log("There are TestNG SKIPPED tests", 4);
        }
        if ((n & 4) == 4) {
            if (this.m_haltOnFSP) {
                this.executeHaltTarget(n);
                throw new BuildException("There are TestNG FAILED WITHIN SUCCESS PERCENTAGE tests");
            }
            if (null != this.m_fspPropertyName) {
                this.getProject().setNewProperty(this.m_fspPropertyName, "true");
            }
            this.log("There are TestNG FAILED WITHIN SUCCESS PERCENTAGE tests", 4);
        }
    }

    private void executeHaltTarget(int n) {
        if (this.m_onHaltTarget != null) {
            if (this.m_outputDir != null) {
                this.getProject().setProperty("testng.outputdir", this.m_outputDir.getAbsolutePath());
            }
            this.getProject().setProperty("testng.returncode", String.valueOf(n));
            Target target = (Target)this.getProject().getTargets().get(this.m_onHaltTarget);
            if (target != null) {
                target.execute();
            }
        }
    }

    protected int executeAsForked(CommandlineJava commandlineJava, ExecuteWatchdog executeWatchdog) {
        int n;
        String[] stringArray;
        Execute execute = new Execute((ExecuteStreamHandler)new TestNGLogSH(this, 2, 1, this.m_verbose == null || this.m_verbose < 5), executeWatchdog);
        execute.setCommandline(commandlineJava.getCommandline());
        execute.setAntRun(this.getProject());
        if (this.m_workingDir != null) {
            if (this.m_workingDir.exists() && this.m_workingDir.isDirectory()) {
                execute.setWorkingDirectory(this.m_workingDir);
            } else {
                this.log("Ignoring invalid working directory : " + this.m_workingDir, 1);
            }
        }
        if (null != (stringArray = this.m_environment.getVariables())) {
            for (String string : stringArray) {
                this.log("Setting environment variable: " + string, 3);
            }
        }
        execute.setEnvironment(stringArray);
        this.log(commandlineJava.describeCommand(), 3);
        try {
            n = execute.execute();
        }
        catch (IOException iOException) {
            throw new BuildException("Process fork failed.", (Throwable)iOException, this.getLocation());
        }
        return n;
    }

    protected CommandlineJava getJavaCommand() {
        if (null == this.m_javaCommand) {
            this.m_javaCommand = new CommandlineJava();
        }
        return this.m_javaCommand;
    }

    protected ExecuteWatchdog createWatchdog() {
        if (this.m_timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.m_timeout.longValue());
    }

    protected void validateOptions() throws BuildException {
        int n = this.getSuiteFileNames().size();
        if (n == 0 && this.m_classFilesets.size() == 0 && Utils.isStringEmpty(this.m_methods) && (null == this.m_testjar || !this.m_testjar.isFile())) {
            throw new BuildException("No suites, classes, methods or jar file was specified.");
        }
        if (null != this.m_includedGroups && this.m_classFilesets.size() == 0 && n == 0) {
            throw new BuildException("No class filesets or xml file sets specified while using groups");
        }
        if (this.m_onHaltTarget != null && !this.getProject().getTargets().containsKey(this.m_onHaltTarget)) {
            throw new BuildException("Target " + this.m_onHaltTarget + " not found in this project");
        }
    }

    private ResourceCollection createResourceCollection(Reference reference) {
        Object object = reference.getReferencedObject();
        if (!(object instanceof ResourceCollection)) {
            throw new BuildException("Only File based ResourceCollections are supported.");
        }
        ResourceCollection resourceCollection = (ResourceCollection)object;
        if (!resourceCollection.isFilesystemOnly()) {
            throw new BuildException("Only ResourceCollections from local file system are supported.");
        }
        return resourceCollection;
    }

    private FileSet appendClassSelector(FileSet fileSet) {
        FilenameSelector filenameSelector = new FilenameSelector();
        filenameSelector.setName("**/*.class");
        filenameSelector.setProject(this.getProject());
        fileSet.appendSelector((FileSelector)filenameSelector);
        return fileSet;
    }

    private File findJar() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String string = clazz.getName().replace('.', '/') + ".class";
        URL uRL = clazz.getClassLoader().getResource(string);
        if (null != uRL) {
            String string2 = uRL.toString();
            if (string2.startsWith("jar:file:")) {
                int n = string2.indexOf("!");
                String string3 = string2.substring(4, n);
                return new File(this.fromURI(string3));
            }
            if (string2.startsWith("file:")) {
                int n = string2.indexOf(string);
                String string4 = string2.substring(0, n);
                return new File(this.fromURI(string4));
            }
        }
        return null;
    }

    private String fromURI(String string) {
        String string2;
        int n;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (null == uRL || !"file".equals(uRL.getProtocol())) {
            throw new IllegalArgumentException("Can only handle valid file: URIs");
        }
        StringBuffer stringBuffer = new StringBuffer(uRL.getHost());
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, File.separatorChar).insert(0, File.separatorChar);
        }
        stringBuffer.append((n = (string2 = uRL.getFile()).indexOf(63)) < 0 ? string2 : string2.substring(0, n));
        string = stringBuffer.toString().replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && string.startsWith("\\") && string.length() > 2 && Character.isLetter(string.charAt(1)) && string.lastIndexOf(58) > -1) {
            string = string.substring(1);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c2 = stringCharacterIterator.next();
                if (c2 != '\uffff') {
                    int n2 = Character.digit(c2, 16);
                    char c3 = stringCharacterIterator.next();
                    if (c3 != '\uffff') {
                        int n3 = Character.digit(c3, 16);
                        stringBuffer2.append((char)((n2 << 4) + n3));
                    }
                }
            } else {
                stringBuffer2.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer2.toString();
    }

    private List<String> getFiles(List<ResourceCollection> list) throws BuildException {
        List<String> list2 = Lists.newArrayList();
        for (ResourceCollection resourceCollection : list) {
            for (Object e : resourceCollection) {
                if (e instanceof FileResource) {
                    FileResource fileResource = (FileResource)e;
                    if (fileResource.isDirectory()) {
                        throw new BuildException("Directory based FileResources are not supported.");
                    }
                    if (!fileResource.isExists()) {
                        this.log("'" + fileResource.toLongString() + "' does not exist", 3);
                    }
                    list2.add(fileResource.getFile().getAbsolutePath());
                    continue;
                }
                this.log("Unsupported Resource type: " + e.toString(), 3);
            }
        }
        return list2;
    }

    private List<String> fileset(FileSet fileSet) throws BuildException {
        List<String> list = Lists.newArrayList();
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        for (String string : directoryScanner.getIncludedFiles()) {
            list.add(directoryScanner.getBasedir() + File.separator + string);
        }
        return list;
    }

    private static String doubleQuote(String string) {
        if (!(string.indexOf(" ") == -1 || string.startsWith("\"") && string.endsWith("\""))) {
            return "\"" + string + '\"';
        }
        return string;
    }

    private String createPathString(Path path, String string) {
        if (path == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < path.list().length; ++i) {
            File file = this.getProject().resolveFile(path.list()[i]);
            if (!file.exists()) {
                this.log("Classpath entry not found: " + file, 1);
            }
            stringBuffer.append(file.getAbsolutePath()).append(string);
        }
        if (path.list().length > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private void dumpCommand(String string) {
        this.ppp("TESTNG PASSED @" + string + " WHICH CONTAINS:");
        this.readAndPrintFile(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndPrintFile(String string) {
        File file = new File(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                System.out.println("  " + string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void addConfiguredReporter(ReporterConfig reporterConfig) {
        this.reporterConfigs.add(reporterConfig);
    }

    public void setSkipFailedInvocationCounts(boolean bl) {
        this.m_skipFailedInvocationCounts = bl;
    }

    public void setXmlPathInJar(String string) {
        this.m_xmlPathInJar = string;
    }

    public void addConfiguredPropertySet(PropertySet propertySet) {
        Properties properties = propertySet.getProperties();
        this.log(properties.keySet().size() + " properties found in nested propertyset", 3);
        for (Object object : properties.keySet()) {
            String string = (String)object;
            Environment.Variable variable = new Environment.Variable();
            variable.setKey(string);
            if (properties.get(string) instanceof String) {
                String string2 = (String)properties.get(string);
                variable.setValue(string2);
                this.getJavaCommand().addSysproperty(variable);
                this.log("Added system property " + string + " with value " + string2, 3);
                continue;
            }
            this.log("Ignoring non-String property " + string, 1);
        }
    }

    protected void handleOutput(String string) {
        if (string.startsWith("[VerboseTestNG] ")) {
            this.log(string, this.m_verbose < 5 ? 3 : 2);
        } else {
            super.handleOutput(string);
        }
    }

    protected static class TestNGLogSH
    extends PumpStreamHandler {
        public TestNGLogSH(Task task, int n, int n2, boolean bl) {
            super((OutputStream)((Object)new TestNGLogOS(task, n, bl)), (OutputStream)new LogOutputStream(task, n2));
        }
    }

    private static class TestNGLogOS
    extends LogOutputStream {
        private Task task;
        private boolean verbose;

        public TestNGLogOS(Task task, int n, boolean bl) {
            super(task, n);
            this.task = task;
            this.verbose = bl;
        }

        protected void processLine(String string, int n) {
            if (string.startsWith("[VerboseTestNG] ")) {
                this.task.log(string, this.verbose ? 3 : 2);
            } else {
                super.processLine(string, n);
            }
        }
    }

    public static enum Mode {
        testng,
        junit,
        mixed;

    }
}

