/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.testng.ClassMethodMap;
import org.testng.DependencyMap;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.IClassListener;
import org.testng.IConfigurable;
import org.testng.IConfigurationListener;
import org.testng.IConfigurationListener2;
import org.testng.IExecutionListener;
import org.testng.IHookable;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.IMethodSelector;
import org.testng.IModuleFactory;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGListenerFactory;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.InstanceOrderingMethodInterceptor;
import org.testng.PreserveOrderMethodInterceptor;
import org.testng.TestClass;
import org.testng.TestNGException;
import org.testng.annotations.Guice;
import org.testng.annotations.IListenersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.MultiMap;
import org.testng.collections.Sets;
import org.testng.internal.Attributes;
import org.testng.internal.ClassHelper;
import org.testng.internal.ClassImpl;
import org.testng.internal.ClassInfoMap;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.Constants;
import org.testng.internal.DynamicGraph;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Invoker;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.ResultMap;
import org.testng.internal.RunInfo;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.graph.GraphThreadPoolExecutor;
import org.testng.internal.thread.graph.IThreadWorkerFactory;
import org.testng.internal.thread.graph.IWorker;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestRunner
implements ITestContext,
ITestResultNotifier,
IThreadWorkerFactory<ITestNGMethod> {
    private static final long serialVersionUID = 4247820024988306670L;
    private ISuite m_suite;
    private XmlTest m_xmlTest;
    private String m_testName;
    private transient List<XmlClass> m_testClassesFromXml = null;
    private transient List<XmlPackage> m_packageNamesFromXml = null;
    private transient IInvoker m_invoker = null;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient List<ITestListener> m_testListeners = Lists.newArrayList();
    private transient Set<IConfigurationListener> m_configurationListeners = Sets.newHashSet();
    private transient IConfigurationListener m_confListener = new ConfigurationListener();
    private transient boolean m_skipFailedInvocationCounts;
    private transient Collection<IInvokedMethodListener> m_invokedMethodListeners = Lists.newArrayList();
    private final transient Map<Class<? extends IClassListener>, IClassListener> m_classListeners = Maps.newHashMap();
    private ITestNGMethod[] m_allTestMethods = new ITestNGMethod[0];
    private Date m_startDate = null;
    private Date m_endDate = null;
    private transient Map<Class<?>, ITestClass> m_classMap = Maps.newLinkedHashMap();
    private String m_outputDirectory = Constants.getDefaultValueFor("testng.outputDir");
    private XmlMethodSelector m_xmlMethodSelector = new XmlMethodSelector();
    private static int m_verbose = 1;
    private ITestNGMethod[] m_beforeSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_beforeXmlTestMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterXmlTestMethods = new ITestNGMethod[0];
    private List<ITestNGMethod> m_excludedMethods = Lists.newArrayList();
    private ConfigurationGroupMethods m_groupMethods = null;
    private Map<String, List<String>> m_metaGroups = Maps.newHashMap();
    private IResultMap m_passedTests = new ResultMap();
    private IResultMap m_failedTests = new ResultMap();
    private IResultMap m_failedButWithinSuccessPercentageTests = new ResultMap();
    private IResultMap m_skippedTests = new ResultMap();
    private RunInfo m_runInfo = new RunInfo();
    private String m_host;
    private transient List<IMethodInterceptor> m_methodInterceptors;
    private transient ClassMethodMap m_classMethodMap;
    private transient TestNGClassFinder m_testClassFinder;
    private transient IConfiguration m_configuration;
    private IMethodInterceptor builtinInterceptor;
    private final List<InvokedMethod> m_invokedMethods = Lists.newArrayList();
    private IResultMap m_passedConfigurations = new ResultMap();
    private IResultMap m_skippedConfigurations = new ResultMap();
    private IResultMap m_failedConfigurations = new ResultMap();
    private IAttributes m_attributes = new Attributes();
    private ListMultiMap<Class<? extends Module>, Module> m_guiceModules = Maps.newListMultiMap();
    private Map<List<Module>, Injector> m_injectors = Maps.newHashMap();

    protected TestRunner(IConfiguration iConfiguration, ISuite iSuite, XmlTest xmlTest, String string, IAnnotationFinder iAnnotationFinder, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
        this.init(iConfiguration, iSuite, xmlTest, string, iAnnotationFinder, bl, collection, list);
    }

    public TestRunner(IConfiguration iConfiguration, ISuite iSuite, XmlTest xmlTest, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
        this.init(iConfiguration, iSuite, xmlTest, iSuite.getOutputDirectory(), iSuite.getAnnotationFinder(), bl, collection, list);
    }

    private void init(IConfiguration iConfiguration, ISuite iSuite, XmlTest xmlTest, String string, IAnnotationFinder iAnnotationFinder, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
        this.m_configuration = iConfiguration;
        this.m_xmlTest = xmlTest;
        this.m_suite = iSuite;
        this.m_testName = xmlTest.getName();
        this.m_host = iSuite.getHost();
        this.m_testClassesFromXml = xmlTest.getXmlClasses();
        this.m_skipFailedInvocationCounts = bl;
        this.setVerbose(xmlTest.getVerbose());
        boolean bl2 = xmlTest.getPreserveOrder();
        this.m_methodInterceptors = new ArrayList<IMethodInterceptor>();
        this.builtinInterceptor = bl2 ? new PreserveOrderMethodInterceptor() : new InstanceOrderingMethodInterceptor();
        this.m_packageNamesFromXml = xmlTest.getXmlPackages();
        if (null != this.m_packageNamesFromXml) {
            for (XmlPackage object : this.m_packageNamesFromXml) {
                this.m_testClassesFromXml.addAll(object.getXmlClasses());
            }
        }
        this.m_annotationFinder = iAnnotationFinder;
        this.m_invokedMethodListeners = collection;
        this.m_classListeners.clear();
        for (IClassListener iClassListener : list) {
            this.m_classListeners.put(iClassListener.getClass(), iClassListener);
        }
        this.m_invoker = new Invoker(this.m_configuration, this, this, this.m_suite.getSuiteState(), this.m_skipFailedInvocationCounts, collection, list);
        if (xmlTest.getParallel() != null) {
            this.log(3, "Running the tests in '" + xmlTest.getName() + "' with parallel mode:" + (Object)((Object)xmlTest.getParallel()));
        }
        this.setOutputDirectory(string);
        this.init();
    }

    public IInvoker getInvoker() {
        return this.m_invoker;
    }

    public ITestNGMethod[] getBeforeSuiteMethods() {
        return this.m_beforeSuiteMethods;
    }

    public ITestNGMethod[] getAfterSuiteMethods() {
        return this.m_afterSuiteMethods;
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return this.m_beforeXmlTestMethods;
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return this.m_afterXmlTestMethods;
    }

    private void init() {
        this.initMetaGroups(this.m_xmlTest);
        this.initRunInfo(this.m_xmlTest);
        if (!this.m_xmlTest.isJUnit()) {
            this.initMethods();
        }
        this.initListeners();
        this.addConfigurationListener(this.m_confListener);
        for (IConfigurationListener iConfigurationListener : this.m_configuration.getConfigurationListeners()) {
            this.addConfigurationListener(iConfigurationListener);
        }
    }

    private ListenerHolder findAllListeners(Class<?> clazz) {
        ListenerHolder listenerHolder = new ListenerHolder();
        listenerHolder.listenerClasses = Lists.newArrayList();
        do {
            Class<? extends ITestNGListener>[] classArray;
            IListenersAnnotation iListenersAnnotation;
            if ((iListenersAnnotation = this.m_annotationFinder.findAnnotation(clazz, IListenersAnnotation.class)) == null) continue;
            for (Class<? extends ITestNGListener> clazz2 : classArray = iListenersAnnotation.getValue()) {
                listenerHolder.listenerClasses.add(clazz2);
                if (!ITestNGListenerFactory.class.isAssignableFrom(clazz2)) continue;
                if (listenerHolder.listenerFactoryClass == null) {
                    listenerHolder.listenerFactoryClass = clazz2;
                    continue;
                }
                throw new TestNGException("Found more than one class implementingITestNGListenerFactory:" + clazz2 + " and " + listenerHolder.listenerFactoryClass);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return listenerHolder;
    }

    private void initListeners() {
        Object object;
        Set<Class> set = Sets.newHashSet();
        Class clazz = null;
        for (IClass object2 : this.getTestClasses()) {
            Class clazz2 = object2.getRealClass();
            object = this.findAllListeners(clazz2);
            if (clazz == null) {
                clazz = ((ListenerHolder)object).listenerFactoryClass;
            }
            set.addAll(((ListenerHolder)object).listenerClasses);
        }
        Object object3 = null;
        try {
            IClass exception;
            if (this.m_testClassFinder != null && (exception = this.m_testClassFinder.getIClass(clazz)) != null) {
                object3 = (ITestNGListenerFactory)exception.getInstances(false)[0];
            }
            if (object3 == null) {
                object3 = clazz != null ? (ITestNGListenerFactory)clazz.newInstance() : null;
            }
        }
        catch (Exception exception) {
            throw new TestNGException("Couldn't instantiate the ITestNGListenerFactory: " + exception);
        }
        for (Class clazz2 : set) {
            if (IClassListener.class.isAssignableFrom(clazz2) && this.m_classListeners.containsKey(clazz2)) continue;
            Object object2 = object = object3 != null ? object3.createListener(clazz2) : null;
            if (object == null) {
                object = (ITestNGListener)ClassHelper.newInstance(clazz2);
            }
            this.addListener((ITestNGListener)object);
        }
    }

    private void initMetaGroups(XmlTest xmlTest) {
        Map<String, List<String>> map = xmlTest.getMetaGroups();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            this.addMetaGroup(entry.getKey(), entry.getValue());
        }
    }

    private void initRunInfo(XmlTest xmlTest) {
        this.m_xmlMethodSelector.setIncludedGroups(this.createGroups(this.m_xmlTest.getIncludedGroups()));
        this.m_xmlMethodSelector.setExcludedGroups(this.createGroups(this.m_xmlTest.getExcludedGroups()));
        this.m_xmlMethodSelector.setExpression(this.m_xmlTest.getExpression());
        this.m_xmlMethodSelector.setXmlClasses(this.m_xmlTest.getXmlClasses());
        this.m_runInfo.addMethodSelector(this.m_xmlMethodSelector, 10);
        if (null != xmlTest.getMethodSelectors()) {
            for (org.testng.xml.XmlMethodSelector xmlMethodSelector : xmlTest.getMethodSelectors()) {
                if (xmlMethodSelector.getClassName() == null) continue;
                IMethodSelector iMethodSelector = ClassHelper.createSelector(xmlMethodSelector);
                this.m_runInfo.addMethodSelector(iMethodSelector, xmlMethodSelector.getPriority());
            }
        }
    }

    private void initMethods() {
        List<ITestNGMethod> list = Lists.newArrayList();
        List<ITestNGMethod> list2 = Lists.newArrayList();
        List<ITestNGMethod> list3 = Lists.newArrayList();
        List<ITestNGMethod> list4 = Lists.newArrayList();
        List<ITestNGMethod> list5 = Lists.newArrayList();
        List<ITestNGMethod> list6 = Lists.newArrayList();
        List<ITestNGMethod> list7 = Lists.newArrayList();
        ClassInfoMap classInfoMap = new ClassInfoMap(this.m_testClassesFromXml);
        this.m_testClassFinder = new TestNGClassFinder(classInfoMap, this.m_xmlTest, this.m_configuration, this);
        TestNGMethodFinder testNGMethodFinder = new TestNGMethodFinder(this.m_runInfo, this.m_annotationFinder);
        this.m_runInfo.setTestMethods(list2);
        IClass[] iClassArray = this.m_testClassFinder.findTestClasses();
        for (IClass iClass : iClassArray) {
            TestClass testClass = new TestClass(iClass, testNGMethodFinder, this.m_annotationFinder, this.m_runInfo, this.m_xmlTest, classInfoMap.getXmlClass(iClass.getRealClass()));
            this.m_classMap.put(iClass.getRealClass(), testClass);
        }
        Map<String, List<ITestNGMethod>> map = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), true);
        Map<String, List<ITestNGMethod>> map2 = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), false);
        for (ITestClass iTestClass : this.m_classMap.values()) {
            this.fixMethodsWithClass(iTestClass.getTestMethods(), iTestClass, list2);
            this.fixMethodsWithClass(iTestClass.getBeforeClassMethods(), iTestClass, list);
            this.fixMethodsWithClass(iTestClass.getBeforeTestMethods(), iTestClass, null);
            this.fixMethodsWithClass(iTestClass.getAfterTestMethods(), iTestClass, null);
            this.fixMethodsWithClass(iTestClass.getAfterClassMethods(), iTestClass, list3);
            this.fixMethodsWithClass(iTestClass.getBeforeSuiteMethods(), iTestClass, list4);
            this.fixMethodsWithClass(iTestClass.getAfterSuiteMethods(), iTestClass, list5);
            this.fixMethodsWithClass(iTestClass.getBeforeTestConfigurationMethods(), iTestClass, list6);
            this.fixMethodsWithClass(iTestClass.getAfterTestConfigurationMethods(), iTestClass, list7);
            this.fixMethodsWithClass(iTestClass.getBeforeGroupsMethods(), iTestClass, MethodHelper.uniqueMethodList(map.values()));
            this.fixMethodsWithClass(iTestClass.getAfterGroupsMethods(), iTestClass, MethodHelper.uniqueMethodList(map2.values()));
        }
        this.m_beforeSuiteMethods = MethodHelper.collectAndOrderMethods(list4, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_beforeXmlTestMethods = MethodHelper.collectAndOrderMethods(list6, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_allTestMethods = MethodHelper.collectAndOrderMethods(list2, true, this.m_runInfo, this.m_annotationFinder, false, this.m_excludedMethods);
        this.m_classMethodMap = new ClassMethodMap(list2, this.m_xmlMethodSelector);
        this.m_afterXmlTestMethods = MethodHelper.collectAndOrderMethods(list7, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_afterSuiteMethods = MethodHelper.collectAndOrderMethods(list5, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_groupMethods = new ConfigurationGroupMethods(this.m_allTestMethods, map, map2);
    }

    private void fixMethodsWithClass(ITestNGMethod[] iTestNGMethodArray, ITestClass iTestClass, List<ITestNGMethod> list) {
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            iTestNGMethod.setTestClass(iTestClass);
            if (list == null) continue;
            list.add(iTestNGMethod);
        }
    }

    public Collection<ITestClass> getTestClasses() {
        return this.m_classMap.values();
    }

    public void setTestName(String string) {
        this.m_testName = string;
    }

    public void setOutputDirectory(String string) {
        this.m_outputDirectory = string;
    }

    private void addMetaGroup(String string, List<String> list) {
        this.m_metaGroups.put(string, list);
    }

    private void collectGroups(String[] stringArray, List<String> list, Map<String, String> map) {
        for (String string : stringArray) {
            List<String> list2 = this.m_metaGroups.get(string);
            if (null == list2) continue;
            for (String string2 : list2) {
                if (null != map.get(string2)) continue;
                map.put(string2, string2);
                list.add(string2);
            }
        }
    }

    private Map<String, String> createGroups(List<String> list) {
        return this.createGroups(list.toArray(new String[list.size()]));
    }

    private Map<String, String> createGroups(String[] stringArray) {
        Map<String, String> map = Maps.newHashMap();
        for (String string : stringArray) {
            map.put(string, string);
        }
        Object object = Lists.newArrayList();
        if (this.m_metaGroups.size() > 0) {
            this.collectGroups(stringArray, (List<String>)object, map);
            while (object.size() > 0) {
                String[] stringArray2 = object.toArray(new String[object.size()]);
                object = Lists.newArrayList();
                this.collectGroups(stringArray2, (List<String>)object, map);
            }
        }
        return map;
    }

    public void run() {
        this.beforeRun();
        try {
            XmlTest xmlTest = this.getTest();
            if (xmlTest.isJUnit()) {
                this.privateRunJUnit(xmlTest);
            } else {
                this.privateRun(xmlTest);
            }
        }
        finally {
            this.afterRun();
        }
    }

    private void beforeRun() {
        this.m_startDate = new Date(System.currentTimeMillis());
        this.logStart();
        this.fireEvent(true);
        ITestNGMethod[] iTestNGMethodArray = this.getBeforeTestConfigurationMethods();
        if (null != iTestNGMethodArray && iTestNGMethodArray.length > 0) {
            this.m_invoker.invokeConfigurations(null, iTestNGMethodArray, this.m_xmlTest.getSuite(), this.m_xmlTest.getAllParameters(), null, null);
        }
    }

    private void privateRunJUnit(XmlTest xmlTest) {
        final ClassInfoMap classInfoMap = new ClassInfoMap(this.m_testClassesFromXml, false);
        final Set<Class<?>> set = classInfoMap.getClasses();
        final List list = Lists.newArrayList();
        List list2 = Lists.newArrayList();
        list2.add(new IWorker<ITestNGMethod>(){

            @Override
            public long getTimeOut() {
                return 0L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (Class clazz : set) {
                    List<XmlInclude> list3 = classInfoMap.getXmlClass(clazz).getIncludedMethods();
                    List list2 = Lists.newArrayList();
                    for (XmlInclude xmlInclude : list3) {
                        list2.add(xmlInclude.getName());
                    }
                    IJUnitTestRunner iJUnitTestRunner = ClassHelper.createTestRunner(TestRunner.this);
                    iJUnitTestRunner.setInvokedMethodListeners(TestRunner.this.m_invokedMethodListeners);
                    try {
                        iJUnitTestRunner.run(clazz, list2.toArray(new String[list2.size()]));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        list.addAll(iJUnitTestRunner.getTestMethods());
                    }
                }
            }

            @Override
            public List<ITestNGMethod> getTasks() {
                throw new TestNGException("JUnit not supported");
            }

            @Override
            public int getPriority() {
                if (TestRunner.this.m_allTestMethods.length == 1) {
                    return TestRunner.this.m_allTestMethods[0].getPriority();
                }
                return 0;
            }

            @Override
            public int compareTo(IWorker<ITestNGMethod> iWorker) {
                return this.getPriority() - iWorker.getPriority();
            }
        });
        this.runJUnitWorkers(list2);
        this.m_allTestMethods = list.toArray(new ITestNGMethod[list.size()]);
    }

    private void privateRun(XmlTest xmlTest) {
        boolean bl = xmlTest.getParallel().isParallel();
        int n = bl ? xmlTest.getThreadCount() : 1;
        DynamicGraph<ITestNGMethod> dynamicGraph = this.createDynamicGraph(this.intercept(this.m_allTestMethods));
        if (bl) {
            if (dynamicGraph.getNodeCount() > 0) {
                GraphThreadPoolExecutor<ITestNGMethod> graphThreadPoolExecutor = new GraphThreadPoolExecutor<ITestNGMethod>(dynamicGraph, this, n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
                graphThreadPoolExecutor.run();
                try {
                    long l = this.m_xmlTest.getTimeOut(Integer.MAX_VALUE);
                    Utils.log("TestRunner", 2, "Starting executor for test " + this.m_xmlTest.getName() + " with time out:" + l + " milliseconds.");
                    graphThreadPoolExecutor.awaitTermination(l, TimeUnit.MILLISECONDS);
                    graphThreadPoolExecutor.shutdownNow();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            boolean bl2 = false;
            List<ITestNGMethod> list = dynamicGraph.getFreeNodes();
            if (bl2) {
                System.out.println("Free nodes:" + list);
            }
            if (dynamicGraph.getNodeCount() > 0 && list.isEmpty()) {
                throw new TestNGException("No free nodes found in:" + dynamicGraph);
            }
            while (!list.isEmpty()) {
                List<IWorker<ITestNGMethod>> list2 = this.createWorkers(list);
                for (IWorker<ITestNGMethod> iWorker : list2) {
                    iWorker.run();
                }
                dynamicGraph.setStatus((ITestNGMethod)((Object)list), DynamicGraph.Status.FINISHED);
                list = dynamicGraph.getFreeNodes();
                if (!bl2) continue;
                System.out.println("Free nodes:" + list);
            }
        }
    }

    private ITestNGMethod[] intercept(ITestNGMethod[] iTestNGMethodArray) {
        List<IMethodInstance> list = this.methodsToMethodInstances(Arrays.asList(iTestNGMethodArray));
        this.m_methodInterceptors.add(this.builtinInterceptor);
        for (IMethodInterceptor object : this.m_methodInterceptors) {
            list = object.intercept(list, this);
        }
        List list2 = Lists.newArrayList();
        for (IMethodInstance iMethodInstance : list) {
            list2.add(iMethodInstance.getMethod());
        }
        this.m_classMethodMap = new ClassMethodMap(list2, null);
        return list2.toArray(new ITestNGMethod[list2.size()]);
    }

    @Override
    public List<IWorker<ITestNGMethod>> createWorkers(List<ITestNGMethod> list) {
        List<IWorker<ITestNGMethod>> list2 = XmlSuite.ParallelMode.INSTANCES.equals((Object)this.m_xmlTest.getParallel()) ? this.createInstanceBasedParallelWorkers(list) : this.createClassBasedParallelWorkers(list);
        return list2;
    }

    private List<IWorker<ITestNGMethod>> createClassBasedParallelWorkers(List<ITestNGMethod> list) {
        Object object;
        List<IWorker<ITestNGMethod>> list2 = Lists.newArrayList();
        Set set = Sets.newHashSet();
        for (ITestNGMethod object32 : list) {
            Class clazz = object32.getRealClass();
            object = this.m_annotationFinder.findAnnotation(clazz, ITestAnnotation.class);
            if ((object == null || !object.getSequential() && !object.getSingleThreaded()) && !XmlSuite.ParallelMode.CLASSES.equals((Object)this.m_xmlTest.getParallel())) continue;
            set.add(clazz);
        }
        List list3 = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod : list) {
            list3.addAll(this.methodsToMultipleMethodInstances(iTestNGMethod));
        }
        Map<String, String> map = this.m_xmlTest.getAllParameters();
        Set set2 = Sets.newHashSet();
        object = list3.iterator();
        while (object.hasNext()) {
            Object object2;
            IMethodInstance iMethodInstance = (IMethodInstance)object.next();
            Class<?> clazz = iMethodInstance.getMethod().getTestClass().getRealClass();
            if (set.contains(clazz)) {
                if (set2.contains(clazz)) continue;
                set2.add(clazz);
                if (System.getProperty("experimental") != null) {
                    object2 = this.createInstances(list3);
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        List list4 = (List)iterator.next();
                        TestMethodWorker testMethodWorker = this.createTestMethodWorker(list4, map, clazz);
                        list2.add(testMethodWorker);
                    }
                    continue;
                }
                object2 = this.createTestMethodWorker(list3, map, clazz);
                list2.add((IWorker<ITestNGMethod>)object2);
                continue;
            }
            object2 = this.createTestMethodWorker(Arrays.asList(iMethodInstance), map, clazz);
            list2.add((IWorker<ITestNGMethod>)object2);
        }
        Collections.sort(list2);
        return list2;
    }

    private List<IWorker<ITestNGMethod>> createInstanceBasedParallelWorkers(List<ITestNGMethod> list) {
        List<IWorker<ITestNGMethod>> list2 = Lists.newArrayList();
        ListMultiMap<Object, ITestNGMethod> listMultiMap = Maps.newListMultiMap();
        for (ITestNGMethod object : list) {
            listMultiMap.put(object.getInstance(), object);
        }
        for (Map.Entry entry : listMultiMap.entrySet()) {
            List list3 = Lists.newArrayList();
            for (ITestNGMethod iTestNGMethod : (List)entry.getValue()) {
                list3.add(new MethodInstance(iTestNGMethod));
            }
            TestMethodWorker testMethodWorker = new TestMethodWorker(this.m_invoker, list3.toArray(new IMethodInstance[list3.size()]), this.m_xmlTest.getSuite(), this.m_xmlTest.getAllParameters(), this.m_groupMethods, this.m_classMethodMap, this, new ArrayList<IClassListener>(this.m_classListeners.values()));
            list2.add(testMethodWorker);
        }
        return list2;
    }

    private List<List<IMethodInstance>> createInstances(List<IMethodInstance> list) {
        Map map = Maps.newHashMap();
        for (IMethodInstance iMethodInstance : list) {
            for (Object object : iMethodInstance.getInstances()) {
                System.out.println(object);
                List list2 = (List)map.get(object);
                if (list2 == null) {
                    list2 = Lists.newArrayList();
                    map.put(object, list2);
                }
                list2.add(iMethodInstance);
            }
        }
        return new ArrayList<List<IMethodInstance>>(map.values());
    }

    private TestMethodWorker createTestMethodWorker(List<IMethodInstance> list, Map<String, String> map, Class<?> clazz) {
        return new TestMethodWorker(this.m_invoker, this.findClasses(list, clazz), this.m_xmlTest.getSuite(), map, this.m_groupMethods, this.m_classMethodMap, this, new ArrayList<IClassListener>(this.m_classListeners.values()));
    }

    private IMethodInstance[] findClasses(List<IMethodInstance> list, Class<?> clazz) {
        List list2 = Lists.newArrayList();
        for (IMethodInstance iMethodInstance : list) {
            if (iMethodInstance.getMethod().getTestClass().getRealClass() != clazz) continue;
            list2.add(iMethodInstance);
        }
        return list2.toArray(new IMethodInstance[list2.size()]);
    }

    private List<MethodInstance> methodsToMultipleMethodInstances(ITestNGMethod ... iTestNGMethodArray) {
        List<MethodInstance> list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            list.add(new MethodInstance(iTestNGMethod));
        }
        return list;
    }

    private List<IMethodInstance> methodsToMethodInstances(List<ITestNGMethod> list) {
        ArrayList<IMethodInstance> arrayList = new ArrayList<IMethodInstance>();
        for (ITestNGMethod iTestNGMethod : list) {
            arrayList.add(new MethodInstance(iTestNGMethod));
        }
        return arrayList;
    }

    private void runJUnitWorkers(List<? extends IWorker<ITestNGMethod>> list) {
        for (IWorker<ITestNGMethod> iWorker : list) {
            iWorker.run();
        }
    }

    private void afterRun() {
        ITestNGMethod[] iTestNGMethodArray = this.getAfterTestConfigurationMethods();
        if (null != iTestNGMethodArray && iTestNGMethodArray.length > 0) {
            this.m_invoker.invokeConfigurations(null, iTestNGMethodArray, this.m_xmlTest.getSuite(), this.m_xmlTest.getAllParameters(), null, null);
        }
        this.m_endDate = new Date(System.currentTimeMillis());
        if (TestRunner.getVerbose() >= 3) {
            this.dumpInvokedMethods();
        }
        this.fireEvent(false);
    }

    private DynamicGraph<ITestNGMethod> createDynamicGraph(ITestNGMethod[] iTestNGMethodArray) {
        Object object;
        DynamicGraph<ITestNGMethod> dynamicGraph = new DynamicGraph<ITestNGMethod>();
        ListMultiMap<Comparable<Integer>, ITestNGMethod> listMultiMap = Maps.newListMultiMap();
        for (Comparable comparable2 : iTestNGMethodArray) {
            listMultiMap.put(Integer.valueOf(comparable2.getPriority()), (ITestNGMethod)comparable2);
        }
        List list = Lists.newArrayList(listMultiMap.keySet());
        Collections.sort(list);
        Comparable<Integer> comparable = iTestNGMethodArray.length > 0 ? (Integer)list.get(0) : 0;
        for (int i = 1; i < list.size(); ++i) {
            Comparable comparable2;
            comparable2 = (Integer)list.get(i);
            for (ITestNGMethod iTestNGMethod : (List)listMultiMap.get(comparable)) {
                for (ITestNGMethod iterator : (List)listMultiMap.get(comparable2)) {
                    dynamicGraph.addEdge(PriorityWeight.priority.ordinal(), iterator, (ITestNGMethod[])new ITestNGMethod[]{iTestNGMethod});
                }
            }
            comparable = comparable2;
        }
        DependencyMap dependencyMap = new DependencyMap(iTestNGMethodArray);
        boolean bl = false;
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            List<ITestNGMethod> list2;
            dynamicGraph.addNode(iTestNGMethod);
            Object object2 = iTestNGMethod.getMethodsDependedUpon();
            if (object2 != null) {
                for (String string : object2) {
                    list2 = dependencyMap.getMethodDependingOn(string, iTestNGMethod);
                    if (iTestNGMethod == list2) continue;
                    dynamicGraph.addEdge(PriorityWeight.dependsOnMethods.ordinal(), iTestNGMethod, (ITestNGMethod[])new ITestNGMethod[]{list2});
                }
            }
            for (String string : object2 = iTestNGMethod.getGroupsDependedUpon()) {
                bl = true;
                list2 = dependencyMap.getMethodsThatBelongTo(string, iTestNGMethod);
                if (list2 == null) {
                    throw new TestNGException("Method \"" + iTestNGMethod + "\" depends on nonexistent group \"" + string + "\"");
                }
                for (ITestNGMethod iTestNGMethod2 : list2) {
                    dynamicGraph.addEdge(PriorityWeight.dependsOnGroups.ordinal(), iTestNGMethod, (ITestNGMethod[])new ITestNGMethod[]{iTestNGMethod2});
                }
            }
        }
        if (!bl && this.getCurrentXmlTest().getParallel() == XmlSuite.ParallelMode.NONE && this.getCurrentXmlTest().getPreserveOrder().booleanValue()) {
            object = this.createClassDependencies(iTestNGMethodArray, this.getCurrentXmlTest());
            for (Map.Entry entry : ((MultiMap)object).entrySet()) {
                for (Object object2 : (List)entry.getValue()) {
                    dynamicGraph.addEdge(PriorityWeight.preserveOrder.ordinal(), (ITestNGMethod)object2, (ITestNGMethod[])new ITestNGMethod[]{(ITestNGMethod)entry.getKey()});
                }
            }
        }
        if (this.getCurrentXmlTest().getGroupByInstances()) {
            object = this.createInstanceDependencies(iTestNGMethodArray);
            for (Map.Entry entry : ((MultiMap)object).entrySet()) {
                dynamicGraph.addEdge(PriorityWeight.groupByInstance.ordinal(), (ITestNGMethod)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return dynamicGraph;
    }

    private ListMultiMap<ITestNGMethod, ITestNGMethod> createInstanceDependencies(ITestNGMethod[] iTestNGMethodArray) {
        ListMultiMap<Object, ITestNGMethod> listMultiMap = Maps.newSortedListMultiMap();
        for (ITestNGMethod object : iTestNGMethodArray) {
            listMultiMap.put(object.getInstance(), object);
        }
        ListMultiMap listMultiMap2 = Maps.newListMultiMap();
        Object k = null;
        for (Map.Entry entry : listMultiMap.entrySet()) {
            if (k == null) {
                k = entry.getKey();
                continue;
            }
            List list = (List)listMultiMap.get(k);
            Object k2 = entry.getKey();
            List list2 = (List)listMultiMap.get(k2);
            for (ITestNGMethod iTestNGMethod : list2) {
                for (ITestNGMethod iTestNGMethod2 : list) {
                    listMultiMap2.put(iTestNGMethod, iTestNGMethod2);
                }
            }
            k = k2;
        }
        return listMultiMap2;
    }

    private ListMultiMap<ITestNGMethod, ITestNGMethod> createClassDependencies(ITestNGMethod[] iTestNGMethodArray, XmlTest xmlTest) {
        Object object2;
        Map map = Maps.newHashMap();
        List<Object> list = Lists.newArrayList();
        for (XmlClass object22 : xmlTest.getXmlClasses()) {
            map.put(object22.getName(), new ArrayList());
            if (list.contains(object22)) continue;
            list.add(object22);
        }
        Collections.sort(list, new Comparator<XmlClass>(){

            @Override
            public int compare(XmlClass xmlClass, XmlClass xmlClass2) {
                return xmlClass.getIndex() - xmlClass2.getIndex();
            }
        });
        Map map2 = Maps.newHashMap();
        Map<Integer, String> map3 = Maps.newHashMap();
        int n = 0;
        for (Object object2 : list) {
            map2.put(((XmlClass)object2).getName(), n);
            map3.put(n, ((XmlClass)object2).getName());
            ++n;
        }
        ListMultiMap listMultiMap = Maps.newListMultiMap();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            listMultiMap.put(iTestNGMethod.getTestClass().getName(), iTestNGMethod);
        }
        object2 = Maps.newListMultiMap();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            String string = iTestNGMethod.getTestClass().getName();
            Integer n2 = (Integer)map2.get(string);
            if (n2 == null || n2 <= 0) continue;
            String string2 = (String)map3.get(n2 - 1);
            List list2 = (List)listMultiMap.get(string2);
            for (ITestNGMethod iTestNGMethod2 : list2) {
                ((MultiMap)object2).put(iTestNGMethod2, iTestNGMethod);
            }
        }
        return object2;
    }

    private void logStart() {
        this.log(3, "Running test " + this.m_testName + " on " + this.m_classMap.size() + "  classes,  included groups:[" + this.mapToString(this.m_xmlMethodSelector.getIncludedGroups()) + "] excluded groups:[" + this.mapToString(this.m_xmlMethodSelector.getExcludedGroups()) + "]");
        if (TestRunner.getVerbose() >= 3) {
            for (ITestClass iTestClass : this.m_classMap.values()) {
                ((TestClass)iTestClass).dump();
            }
        }
    }

    private void fireEvent(boolean bl) {
        for (ITestListener iTestListener : this.m_testListeners) {
            try {
                if (bl) {
                    iTestListener.onStart(this);
                    continue;
                }
                iTestListener.onFinish(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public String getName() {
        return this.m_testName;
    }

    @Override
    public Date getStartDate() {
        return this.m_startDate;
    }

    @Override
    public Date getEndDate() {
        return this.m_endDate;
    }

    @Override
    public IResultMap getPassedTests() {
        return this.m_passedTests;
    }

    @Override
    public IResultMap getSkippedTests() {
        return this.m_skippedTests;
    }

    @Override
    public IResultMap getFailedTests() {
        return this.m_failedTests;
    }

    @Override
    public IResultMap getFailedButWithinSuccessPercentageTests() {
        return this.m_failedButWithinSuccessPercentageTests;
    }

    @Override
    public String[] getIncludedGroups() {
        Map<String, String> map = this.m_xmlMethodSelector.getIncludedGroups();
        String[] stringArray = map.values().toArray(new String[map.size()]);
        return stringArray;
    }

    @Override
    public String[] getExcludedGroups() {
        Map<String, String> map = this.m_xmlMethodSelector.getExcludedGroups();
        String[] stringArray = map.values().toArray(new String[map.size()]);
        return stringArray;
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDirectory;
    }

    @Override
    public ISuite getSuite() {
        return this.m_suite;
    }

    @Override
    public ITestNGMethod[] getAllTestMethods() {
        return this.m_allTestMethods;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        Map<ITestNGMethod, ITestNGMethod> map = Maps.newHashMap();
        for (ITestNGMethod iTestNGMethod : this.m_excludedMethods) {
            map.put(iTestNGMethod, iTestNGMethod);
        }
        return map.keySet();
    }

    @Override
    public IResultMap getFailedConfigurations() {
        return this.m_failedConfigurations;
    }

    @Override
    public IResultMap getPassedConfigurations() {
        return this.m_passedConfigurations;
    }

    @Override
    public IResultMap getSkippedConfigurations() {
        return this.m_skippedConfigurations;
    }

    @Override
    public void addPassedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.m_passedTests.addResult(iTestResult, iTestNGMethod);
    }

    @Override
    public Set<ITestResult> getPassedTests(ITestNGMethod iTestNGMethod) {
        return this.m_passedTests.getResults(iTestNGMethod);
    }

    @Override
    public Set<ITestResult> getFailedTests(ITestNGMethod iTestNGMethod) {
        return this.m_failedTests.getResults(iTestNGMethod);
    }

    @Override
    public Set<ITestResult> getSkippedTests(ITestNGMethod iTestNGMethod) {
        return this.m_skippedTests.getResults(iTestNGMethod);
    }

    @Override
    public void addSkippedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.m_skippedTests.addResult(iTestResult, iTestNGMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInvokedMethod(InvokedMethod invokedMethod) {
        List<InvokedMethod> list = this.m_invokedMethods;
        synchronized (list) {
            this.m_invokedMethods.add(invokedMethod);
        }
    }

    @Override
    public void addFailedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.logFailedTest(iTestNGMethod, iTestResult, false);
    }

    @Override
    public void addFailedButWithinSuccessPercentageTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.logFailedTest(iTestNGMethod, iTestResult, true);
    }

    @Override
    public XmlTest getTest() {
        return this.m_xmlTest;
    }

    @Override
    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    @Override
    public List<IConfigurationListener> getConfigurationListeners() {
        return Lists.newArrayList(this.m_configurationListeners);
    }

    private void logFailedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult, boolean bl) {
        if (bl) {
            this.m_failedButWithinSuccessPercentageTests.addResult(iTestResult, iTestNGMethod);
        } else {
            this.m_failedTests.addResult(iTestResult, iTestNGMethod);
        }
    }

    private String mapToString(Map<?, ?> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object obj : map.values()) {
            stringBuffer.append(obj.toString()).append(" ");
        }
        return stringBuffer.toString();
    }

    private void log(int n, String string) {
        Utils.log("TestRunner", n, string);
    }

    public static int getVerbose() {
        return m_verbose;
    }

    public void setVerbose(int n) {
        m_verbose = n;
    }

    private void log(String string) {
        Utils.log("TestRunner", 2, string);
    }

    @Deprecated
    public void addListener(Object object) {
        if (object instanceof ITestNGListener) {
            this.addListener((ITestNGListener)object);
        }
    }

    public void addListener(ITestNGListener iTestNGListener) {
        ITestNGListener iTestNGListener2;
        if (iTestNGListener instanceof IMethodInterceptor) {
            this.m_methodInterceptors.add((IMethodInterceptor)iTestNGListener);
        }
        if (iTestNGListener instanceof ITestListener) {
            this.addTestListener((ITestListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IClassListener && !this.m_classListeners.containsKey((iTestNGListener2 = (IClassListener)iTestNGListener).getClass())) {
            this.m_classListeners.put(iTestNGListener2.getClass(), (IClassListener)iTestNGListener2);
        }
        if (iTestNGListener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IConfigurable) {
            this.m_configuration.setConfigurable((IConfigurable)iTestNGListener);
        }
        if (iTestNGListener instanceof IHookable) {
            this.m_configuration.setHookable((IHookable)iTestNGListener);
        }
        if (iTestNGListener instanceof IExecutionListener) {
            iTestNGListener2 = (IExecutionListener)iTestNGListener;
            iTestNGListener2.onExecutionStart();
            this.m_configuration.addExecutionListener((IExecutionListener)iTestNGListener2);
        }
        this.m_suite.addListener(iTestNGListener);
    }

    @Deprecated
    public void addTestListener(ITestListener iTestListener) {
        this.m_testListeners.add(iTestListener);
    }

    void addConfigurationListener(IConfigurationListener iConfigurationListener) {
        this.m_configurationListeners.add(iConfigurationListener);
    }

    private void dumpInvokedMethods() {
        System.out.println("===== Invoked methods");
        for (IInvokedMethod iInvokedMethod : this.m_invokedMethods) {
            if (iInvokedMethod.isTestMethod()) {
                System.out.print("    ");
            } else {
                if (!iInvokedMethod.isConfigurationMethod()) continue;
                System.out.print("  ");
            }
            System.out.println("" + iInvokedMethod);
        }
        System.out.println("=====");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITestNGMethod> getInvokedMethods() {
        List<ITestNGMethod> list = Lists.newArrayList();
        List<InvokedMethod> list2 = this.m_invokedMethods;
        synchronized (list2) {
            for (IInvokedMethod iInvokedMethod : this.m_invokedMethods) {
                ITestNGMethod iTestNGMethod = iInvokedMethod.getTestMethod();
                iTestNGMethod.setDate(iInvokedMethod.getDate());
                list.add(iTestNGMethod);
            }
        }
        return list;
    }

    @Deprecated
    public void setMethodInterceptor(IMethodInterceptor iMethodInterceptor) {
        this.m_methodInterceptors.add(iMethodInterceptor);
    }

    public void addMethodInterceptor(IMethodInterceptor iMethodInterceptor) {
        this.m_methodInterceptors.add(iMethodInterceptor);
    }

    @Override
    public XmlTest getCurrentXmlTest() {
        return this.m_xmlTest;
    }

    @Override
    public Object getAttribute(String string) {
        return this.m_attributes.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.m_attributes.setAttribute(string, object);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String string) {
        return this.m_attributes.removeAttribute(string);
    }

    @Override
    public List<Module> getGuiceModules(Class<? extends Module> clazz) {
        return (List)this.m_guiceModules.get(clazz);
    }

    private void addGuiceModule(Class<? extends Module> clazz, Module module) {
        this.m_guiceModules.put(clazz, module);
    }

    @Override
    public Injector getInjector(List<Module> list) {
        return this.m_injectors.get(list);
    }

    @Override
    public Injector getInjector(IClass iClass) {
        Annotation annotation = AnnotationHelper.findAnnotationSuperClasses(Guice.class, iClass.getRealClass());
        if (annotation == null) {
            return null;
        }
        if (iClass instanceof TestClass) {
            iClass = ((TestClass)iClass).getIClass();
        }
        if (!(iClass instanceof ClassImpl)) {
            return null;
        }
        Guice guice = (Guice)annotation;
        Injector injector = ((ClassImpl)iClass).getParentInjector();
        List<Module> list = Lists.newArrayList(this.getModules(guice, injector, iClass.getRealClass()));
        Injector injector2 = this.getInjector(list);
        if (injector2 == null) {
            injector2 = injector.createChildInjector(list);
            this.addInjector(list, injector2);
        }
        return injector2;
    }

    private Module[] getModules(Guice guice, Injector injector, Class<?> clazz) {
        IModuleFactory iModuleFactory;
        Module module;
        List list = Lists.newArrayList();
        for (Class<? extends Module> clazz2 : guice.modules()) {
            List<Module> list2 = this.getGuiceModules(clazz2);
            if (list2 != null && list2.size() > 0) {
                list.addAll(list2);
                continue;
            }
            Module module2 = (Module)injector.getInstance(clazz2);
            list.add(module2);
            this.addGuiceModule(clazz2, module2);
        }
        Class<? extends IModuleFactory> clazz3 = guice.moduleFactory();
        if (clazz3 != IModuleFactory.class && (module = (iModuleFactory = (IModuleFactory)injector.getInstance(clazz3)).createModule(this, clazz)) != null) {
            list.add(module);
        }
        return list.toArray(new Module[list.size()]);
    }

    @Override
    public void addInjector(List<Module> list, Injector injector) {
        this.m_injectors.put(list, injector);
    }

    private class ConfigurationListener
    implements IConfigurationListener2 {
        private ConfigurationListener() {
        }

        @Override
        public void beforeConfiguration(ITestResult iTestResult) {
        }

        @Override
        public void onConfigurationFailure(ITestResult iTestResult) {
            TestRunner.this.m_failedConfigurations.addResult(iTestResult, iTestResult.getMethod());
        }

        @Override
        public void onConfigurationSkip(ITestResult iTestResult) {
            TestRunner.this.m_skippedConfigurations.addResult(iTestResult, iTestResult.getMethod());
        }

        @Override
        public void onConfigurationSuccess(ITestResult iTestResult) {
            TestRunner.this.m_passedConfigurations.addResult(iTestResult, iTestResult.getMethod());
        }
    }

    private static class ListenerHolder {
        private List<Class<? extends ITestNGListener>> listenerClasses;
        private Class<? extends ITestNGListenerFactory> listenerFactoryClass;

        private ListenerHolder() {
        }
    }

    private static enum PriorityWeight {
        groupByInstance,
        preserveOrder,
        priority,
        dependsOnGroups,
        dependsOnMethods;

    }
}

