/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread.graph;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.DynamicGraph;
import org.testng.internal.thread.graph.IThreadWorkerFactory;
import org.testng.internal.thread.graph.IWorker;

public class GraphThreadPoolExecutor<T>
extends ThreadPoolExecutor {
    private static final boolean DEBUG = false;
    private static final boolean DOT_FILES = false;
    private DynamicGraph<T> m_graph;
    private List<Runnable> m_activeRunnables = Lists.newArrayList();
    private IThreadWorkerFactory<T> m_factory;
    private List<String> m_dotFiles = Lists.newArrayList();
    private int m_threadCount;

    public GraphThreadPoolExecutor(DynamicGraph<T> dynamicGraph, IThreadWorkerFactory<T> iThreadWorkerFactory, int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue);
        this.ppp("Initializing executor with " + n + " threads and following graph " + dynamicGraph);
        this.m_threadCount = n2;
        this.m_graph = dynamicGraph;
        this.m_factory = iThreadWorkerFactory;
        if (this.m_graph.getFreeNodes().isEmpty()) {
            throw new TestNGException("The graph of methods contains a cycle:" + dynamicGraph.getEdges());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            List<T> list = this.m_graph.getFreeNodes();
            this.runNodes(list);
        }
    }

    private void runNodes(List<T> list) {
        List<IWorker<T>> list2 = this.m_factory.createWorkers(list);
        for (IWorker<T> iWorker : list2) {
            this.m_activeRunnables.add(iWorker);
            this.ppp("Added to active runnable");
            this.setStatus(iWorker, DynamicGraph.Status.RUNNING);
            this.ppp("Executing: " + iWorker);
            try {
                this.execute(iWorker);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(IWorker<T> iWorker, DynamicGraph.Status status) {
        this.ppp("Set status:" + iWorker + " status:" + (Object)((Object)status));
        if (status == DynamicGraph.Status.FINISHED) {
            this.m_activeRunnables.remove(iWorker);
        }
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            for (T t : iWorker.getTasks()) {
                this.m_graph.setStatus(t, status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterExecute(Runnable runnable, Throwable throwable) {
        this.ppp("Finished runnable:" + runnable);
        this.setStatus((IWorker)runnable, DynamicGraph.Status.FINISHED);
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            this.ppp("Node count:" + this.m_graph.getNodeCount() + " and " + this.m_graph.getNodeCountWithStatus(DynamicGraph.Status.FINISHED) + " finished");
            if (this.m_graph.getNodeCount() == this.m_graph.getNodeCountWithStatus(DynamicGraph.Status.FINISHED)) {
                this.ppp("Shutting down executor " + this);
                this.shutdown();
            } else {
                List<T> list = this.m_graph.getFreeNodes();
                this.runNodes(list);
            }
        }
    }

    private void generateFiles(List<String> list) {
        try {
            File file = File.createTempFile("TestNG-", "");
            file.delete();
            file.mkdir();
            for (int i = 0; i < list.size(); ++i) {
                File file2 = new File(file, "" + (i < 10 ? "0" : "") + i + ".dot");
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));){
                    bufferedWriter.append(list.get(i));
                    continue;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void ppp(String string) {
    }
}

