/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.SetMultiMap;
import org.testng.collections.Sets;
import org.testng.internal.Utils;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlSuite;

public class JUnitReportReporter
implements IReporter {
    @Override
    public void generateReport(List<XmlSuite> list, List<ISuite> list2, String string) {
        Object object;
        Map<Class<?>, Set<ITestResult>> map = Maps.newHashMap();
        ListMultiMap<Object, ITestResult> listMultiMap = Maps.newListMultiMap();
        ListMultiMap<Object, ITestResult> listMultiMap2 = Maps.newListMultiMap();
        SetMultiMap setMultiMap = new SetMultiMap(false);
        int n = 0;
        for (ISuite object2 : list2) {
            object = object2.getResults();
            n += object2.getExcludedMethods().size();
            this.addMapping(setMultiMap, object2.getExcludedMethods());
            for (Object object3 : object.values()) {
                ITestContext iTestContext = object3.getTestContext();
                this.addResults(iTestContext.getPassedTests().getAllResults(), map);
                this.addResults(iTestContext.getFailedTests().getAllResults(), map);
                this.addResults(iTestContext.getSkippedTests().getAllResults(), map);
                this.addResults(iTestContext.getFailedConfigurations().getAllResults(), map);
                for (ITestResult iTestResult : iTestContext.getPassedConfigurations().getAllResults()) {
                    if (iTestResult.getMethod().isBeforeMethodConfiguration()) {
                        listMultiMap.put(iTestResult.getInstance(), iTestResult);
                    }
                    if (!iTestResult.getMethod().isAfterMethodConfiguration()) continue;
                    listMultiMap2.put(iTestResult.getInstance(), iTestResult);
                }
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            Object object3;
            object = (Class)entry.getKey();
            Properties properties = new Properties();
            properties.setProperty("name", ((Class)object).getName());
            properties.setProperty("timestamp", JUnitXMLReporter.timeAsGmt());
            object3 = Lists.newArrayList();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            float f = 0.0f;
            for (ITestResult iTestResult : (Set)entry.getValue()) {
                long l = iTestResult.getEndMillis() - iTestResult.getStartMillis();
                l += this.getNextConfiguration(listMultiMap, iTestResult);
                l += this.getNextConfiguration(listMultiMap2, iTestResult);
                Throwable throwable = iTestResult.getThrowable();
                switch (iTestResult.getStatus()) {
                    case 3: 
                    case 4: {
                        ++n4;
                        break;
                    }
                    case 2: {
                        if (throwable instanceof AssertionError) {
                            ++n2;
                            break;
                        }
                        ++n3;
                    }
                }
                f += (float)l;
                ++n5;
                TestTag testTag = this.createTestTagFor(iTestResult, (Class<?>)object);
                testTag.properties.setProperty("time", "" + this.formatTime(l));
                object3.add(testTag);
            }
            for (Map.Entry entry2 : setMultiMap.entrySet()) {
                for (Cloneable cloneable : (Set)entry2.getValue()) {
                    object3.add(this.createIgnoredTestTagFor((ITestNGMethod)cloneable));
                }
            }
            properties.setProperty("failures", "" + n2);
            properties.setProperty("ignored", "" + n);
            properties.setProperty("errors", "" + n3);
            properties.setProperty("skipped", "" + n4);
            properties.setProperty("name", ((Class)object).getName());
            properties.setProperty("tests", "" + n5);
            properties.setProperty("time", "" + this.formatTime(f));
            try {
                properties.setProperty("hostname", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
            xMLStringBuffer.addComment("Generated by " + this.getClass().getName());
            xMLStringBuffer.push("testsuite", properties);
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                Cloneable cloneable;
                TestTag testTag = (TestTag)iterator.next();
                if (!this.putElement(xMLStringBuffer, "testcase", testTag.properties, testTag.childTag != null)) continue;
                cloneable = new Properties();
                this.safeSetProperty((Properties)cloneable, "message", testTag.message);
                this.safeSetProperty((Properties)cloneable, "type", testTag.type);
                if (this.putElement(xMLStringBuffer, testTag.childTag, (Properties)cloneable, testTag.stackTrace != null)) {
                    xMLStringBuffer.addCDATA(testTag.stackTrace);
                    xMLStringBuffer.pop(testTag.childTag);
                }
                xMLStringBuffer.pop("testcase");
            }
            xMLStringBuffer.pop("testsuite");
            String string2 = string + File.separator + "junitreports";
            Utils.writeUtf8File(string2, this.getFileName((Class)object), xMLStringBuffer.toXML());
        }
    }

    private TestTag createIgnoredTestTagFor(ITestNGMethod iTestNGMethod) {
        TestTag testTag = new TestTag();
        Properties properties = new Properties();
        properties.setProperty("classname", iTestNGMethod.getRealClass().getName());
        properties.setProperty("name", iTestNGMethod.getMethodName());
        testTag.childTag = "skipped";
        testTag.properties = properties;
        return testTag;
    }

    private TestTag createTestTagFor(ITestResult iTestResult, Class<?> clazz) {
        TestTag testTag = new TestTag();
        Properties properties = new Properties();
        properties.setProperty("classname", clazz.getName());
        properties.setProperty("name", this.getTestName(iTestResult));
        Throwable throwable = iTestResult.getThrowable();
        switch (iTestResult.getStatus()) {
            case 3: 
            case 4: {
                testTag.childTag = "skipped";
                break;
            }
            case 2: {
                testTag.childTag = "error";
                if (throwable instanceof AssertionError) {
                    testTag.childTag = "failure";
                }
                if (throwable == null) break;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                testTag.message = throwable.getMessage();
                testTag.type = throwable.getClass().getName();
                testTag.stackTrace = stringWriter.toString();
            }
        }
        testTag.properties = properties;
        return testTag;
    }

    private boolean putElement(XMLStringBuffer xMLStringBuffer, String string, Properties properties, boolean bl) {
        if (bl) {
            xMLStringBuffer.push(string, properties);
        } else {
            xMLStringBuffer.addEmptyElement(string, properties);
        }
        return bl;
    }

    private void safeSetProperty(Properties properties, String string, String string2) {
        if (string2 != null) {
            properties.setProperty(string, string2);
        }
    }

    private long getNextConfiguration(ListMultiMap<Object, ITestResult> listMultiMap, ITestResult iTestResult) {
        long l = 0L;
        List list = (List)listMultiMap.get(iTestResult.getInstance());
        Map<ITestNGMethod, ITestResult> map = Maps.newHashMap();
        for (ITestResult iTestResult2 : list) {
            if (map.containsKey(iTestResult2.getMethod())) continue;
            l += iTestResult2.getEndMillis() - iTestResult2.getStartMillis();
            map.put(iTestResult2.getMethod(), iTestResult2);
        }
        list.removeAll(map.values());
        return l;
    }

    protected String getFileName(Class clazz) {
        return "TEST-" + clazz.getName() + ".xml";
    }

    protected String getTestName(ITestResult iTestResult) {
        return iTestResult.getMethod().getMethodName();
    }

    private String formatTime(float f) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("#.###", decimalFormatSymbols);
        decimalFormat.setMinimumFractionDigits(3);
        return decimalFormat.format(f / 1000.0f);
    }

    private void addResults(Set<ITestResult> set, Map<Class<?>, Set<ITestResult>> map) {
        for (ITestResult iTestResult : set) {
            Class<?> clazz = iTestResult.getMethod().getTestClass().getRealClass();
            Set<ITestResult> set2 = map.get(clazz);
            if (set2 == null) {
                set2 = Sets.newHashSet();
                map.put(clazz, set2);
            }
            set2.add(iTestResult);
        }
    }

    private void addMapping(SetMultiMap<Class<?>, ITestNGMethod> setMultiMap, Collection<ITestNGMethod> collection) {
        for (ITestNGMethod iTestNGMethod : collection) {
            setMultiMap.put(iTestNGMethod.getRealClass(), iTestNGMethod);
        }
    }

    private static class TestTag {
        public Properties properties;
        public String message;
        public String type;
        public String stackTrace;
        String childTag;

        private TestTag() {
        }
    }
}

