/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.IResultListener2;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;

public class JUnitXMLReporter
implements IResultListener2 {
    private static final Pattern ENTITY = Pattern.compile("&[a-zA-Z]+;.*");
    private static final Pattern LESS = Pattern.compile("<");
    private static final Pattern GREATER = Pattern.compile(">");
    private static final Pattern SINGLE_QUOTE = Pattern.compile("'");
    private static final Pattern QUOTE = Pattern.compile("\"");
    private static final Map<String, Pattern> ATTR_ESCAPES = Maps.newHashMap();
    private int m_numFailed = 0;
    private List<ITestResult> m_allTests = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestResult> m_configIssues = Collections.synchronizedList(Lists.newArrayList());
    private Map<String, String> m_fileNameMap = Maps.newHashMap();
    private int m_fileNameIncrementer = 0;

    @Override
    public void onTestStart(ITestResult iTestResult) {
    }

    @Override
    public void beforeConfiguration(ITestResult iTestResult) {
    }

    @Override
    public void onTestSuccess(ITestResult iTestResult) {
        this.m_allTests.add(iTestResult);
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        this.m_allTests.add(iTestResult);
    }

    @Override
    public void onTestFailure(ITestResult iTestResult) {
        this.m_allTests.add(iTestResult);
        ++this.m_numFailed;
    }

    @Override
    public void onTestSkipped(ITestResult iTestResult) {
        this.m_allTests.add(iTestResult);
    }

    @Override
    public void onStart(ITestContext iTestContext) {
    }

    @Override
    public void onFinish(ITestContext iTestContext) {
        this.generateReport(iTestContext);
        this.resetAll();
    }

    @Override
    public void onConfigurationFailure(ITestResult iTestResult) {
        this.m_configIssues.add(iTestResult);
    }

    @Override
    public void onConfigurationSkip(ITestResult iTestResult) {
        this.m_configIssues.add(iTestResult);
    }

    @Override
    public void onConfigurationSuccess(ITestResult iTestResult) {
    }

    protected void generateReport(ITestContext iTestContext) {
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        xMLStringBuffer.addComment("Generated by " + this.getClass().getName());
        Properties properties = new Properties();
        properties.setProperty("errors", "0");
        properties.setProperty("failures", "" + this.m_numFailed);
        properties.setProperty("ignored", "" + iTestContext.getExcludedMethods().size());
        try {
            properties.setProperty("hostname", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        Set<String> set = this.getPackages(iTestContext);
        if (set.size() > 0) {
            properties.setProperty("name", iTestContext.getCurrentXmlTest().getName());
        }
        properties.setProperty("tests", "" + this.m_allTests.size());
        properties.setProperty("time", "" + (double)(iTestContext.getEndDate().getTime() - iTestContext.getStartDate().getTime()) / 1000.0);
        properties.setProperty("timestamp", JUnitXMLReporter.timeAsGmt());
        xMLStringBuffer.push("testsuite", properties);
        this.createElementFromTestResults(xMLStringBuffer, this.m_configIssues);
        this.createElementFromTestResults(xMLStringBuffer, this.m_allTests);
        this.createElementFromIgnoredTests(xMLStringBuffer, iTestContext);
        xMLStringBuffer.pop();
        Utils.writeUtf8File(iTestContext.getOutputDirectory(), this.generateFileName(iTestContext) + ".xml", xMLStringBuffer.toXML());
    }

    static String timeAsGmt() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        simpleDateFormat.applyPattern("dd MMM yyyy HH:mm:ss z");
        return simpleDateFormat.format(Calendar.getInstance().getTime());
    }

    private synchronized void createElementFromTestResults(XMLStringBuffer xMLStringBuffer, List<ITestResult> list) {
        for (ITestResult iTestResult : list) {
            this.createElement(xMLStringBuffer, iTestResult);
        }
    }

    private synchronized void createElementFromIgnoredTests(XMLStringBuffer xMLStringBuffer, ITestContext iTestContext) {
        Collection<ITestNGMethod> collection = iTestContext.getExcludedMethods();
        for (ITestNGMethod iTestNGMethod : collection) {
            Properties properties = this.getPropertiesFor(iTestNGMethod, 0L);
            xMLStringBuffer.push("testcase", properties);
            xMLStringBuffer.addEmptyElement("ignored");
            xMLStringBuffer.pop();
        }
    }

    private Properties getPropertiesFor(ITestNGMethod iTestNGMethod, long l) {
        Properties properties = new Properties();
        String string = Utils.detailedMethodName(iTestNGMethod, false);
        properties.setProperty("name", string);
        properties.setProperty("classname", iTestNGMethod.getRealClass().getName());
        properties.setProperty("time", "" + (double)l / 1000.0);
        return properties;
    }

    private Set<String> getPackages(ITestContext iTestContext) {
        Set<String> set = Sets.newHashSet();
        for (ITestNGMethod iTestNGMethod : iTestContext.getAllTestMethods()) {
            Package package_ = iTestNGMethod.getConstructorOrMethod().getDeclaringClass().getPackage();
            if (package_ == null) continue;
            set.add(package_.getName());
        }
        return set;
    }

    private void createElement(XMLStringBuffer xMLStringBuffer, ITestResult iTestResult) {
        long l = iTestResult.getEndMillis() - iTestResult.getStartMillis();
        Properties properties = this.getPropertiesFor(iTestResult.getMethod(), l);
        if (iTestResult.getMethod().isTest()) {
            properties.setProperty("name", iTestResult.getName());
        }
        if (2 == iTestResult.getStatus() || 3 == iTestResult.getStatus()) {
            xMLStringBuffer.push("testcase", properties);
            if (2 == iTestResult.getStatus()) {
                this.createFailureElement(xMLStringBuffer, iTestResult);
            } else if (3 == iTestResult.getStatus()) {
                this.createSkipElement(xMLStringBuffer);
            }
            xMLStringBuffer.pop();
        } else {
            xMLStringBuffer.addEmptyElement("testcase", properties);
        }
    }

    private void createFailureElement(XMLStringBuffer xMLStringBuffer, ITestResult iTestResult) {
        Properties properties = new Properties();
        Throwable throwable = iTestResult.getThrowable();
        if (throwable != null) {
            properties.setProperty("type", throwable.getClass().getName());
            String string = throwable.getMessage();
            if (string != null && string.length() > 0) {
                properties.setProperty("message", this.encodeAttr(string));
            }
            xMLStringBuffer.push("failure", properties);
            xMLStringBuffer.addCDATA(Utils.shortStackTrace(throwable, false));
            xMLStringBuffer.pop();
        } else {
            xMLStringBuffer.addEmptyElement("failure");
        }
    }

    private void createSkipElement(XMLStringBuffer xMLStringBuffer) {
        xMLStringBuffer.addEmptyElement("skipped");
    }

    private String encodeAttr(String string) {
        String string2 = this.replaceAmpersand(string, ENTITY);
        for (Map.Entry<String, Pattern> entry : ATTR_ESCAPES.entrySet()) {
            string2 = entry.getValue().matcher(string2).replaceAll(entry.getKey());
        }
        return string2;
    }

    private String replaceAmpersand(String string, Pattern pattern) {
        int n = 0;
        int n2 = string.indexOf(38, n);
        if (n2 == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 != -1) {
            stringBuilder.append(string.substring(n, n2));
            if (pattern.matcher(string.substring(n2)).matches()) {
                stringBuilder.append("&");
            } else {
                stringBuilder.append("&amp;");
            }
            n = n2 + 1;
            n2 = string.indexOf(38, n);
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private void resetAll() {
        this.m_allTests = Collections.synchronizedList(Lists.newArrayList());
        this.m_configIssues = Collections.synchronizedList(Lists.newArrayList());
        this.m_numFailed = 0;
    }

    private String generateFileName(ITestContext iTestContext) {
        String string = iTestContext.getSuite().getName() + iTestContext.getName();
        String string2 = this.m_fileNameMap.get(string) == null ? iTestContext.getName() : iTestContext.getName() + this.m_fileNameIncrementer++;
        this.m_fileNameMap.put(string, string2);
        return string2;
    }

    static {
        ATTR_ESCAPES.put("&lt;", LESS);
        ATTR_ESCAPES.put("&gt;", GREATER);
        ATTR_ESCAPES.put("&apos;", SINGLE_QUOTE);
        ATTR_ESCAPES.put("&quot;", QUOTE);
    }
}

