/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testng.IInstanceInfo;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.Parameters;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class FactoryMethod
extends BaseTestMethod {
    private static final long serialVersionUID = -7329918821346197099L;
    private final IFactoryAnnotation factoryAnnotation;
    private final Object m_instance;
    private final XmlTest m_xmlTest;
    private final ITestContext m_testContext;
    private final ITestObjectFactory objectFactory;

    public FactoryMethod(ConstructorOrMethod constructorOrMethod, Object object, XmlTest xmlTest, IAnnotationFinder iAnnotationFinder, ITestContext iTestContext, ITestObjectFactory iTestObjectFactory) {
        super(constructorOrMethod.getName(), constructorOrMethod, iAnnotationFinder, object);
        Utils.checkInstanceOrStatic(object, constructorOrMethod.getMethod());
        Utils.checkReturnType(constructorOrMethod.getMethod(), Object[].class, IInstanceInfo[].class);
        Class<?> clazz = constructorOrMethod.getDeclaringClass();
        if (object != null && !clazz.isAssignableFrom(object.getClass())) {
            throw new TestNGException("Mismatch between instance/method classes:" + object.getClass() + " " + clazz);
        }
        if (object == null && constructorOrMethod.getMethod() != null && !Modifier.isStatic(constructorOrMethod.getMethod().getModifiers())) {
            throw new TestNGException("An inner factory method MUST be static. But '" + constructorOrMethod.getMethod().getName() + "' from '" + clazz.getName() + "' is not.");
        }
        if (constructorOrMethod.getMethod() != null && !Modifier.isPublic(constructorOrMethod.getMethod().getModifiers())) {
            try {
                constructorOrMethod.getMethod().setAccessible(true);
            }
            catch (SecurityException securityException) {
                throw new TestNGException(constructorOrMethod.getMethod().getName() + " must be public", securityException);
            }
        }
        this.factoryAnnotation = iAnnotationFinder.findAnnotation(constructorOrMethod, IFactoryAnnotation.class);
        this.m_instance = object;
        this.m_xmlTest = xmlTest;
        this.m_testContext = iTestContext;
        NoOpTestClass noOpTestClass = new NoOpTestClass();
        noOpTestClass.setTestClass(clazz);
        this.m_testClass = noOpTestClass;
        this.objectFactory = iTestObjectFactory;
    }

    public Object[] invoke() {
        List list = Lists.newArrayList();
        Map<String, String> map = Maps.newHashMap();
        Iterator<Object[]> iterator = Parameters.handleParameters((ITestNGMethod)this, map, (Object)this.m_instance, (Parameters.MethodParameters)new Parameters.MethodParameters(this.m_xmlTest.getAllParameters(), this.findMethodParameters((XmlTest)this.m_xmlTest), null, null, (ITestContext)this.m_testContext, null), (XmlSuite)this.m_xmlTest.getSuite(), (IAnnotationFinder)this.m_annotationFinder, null).parameters;
        try {
            List<Integer> list2 = this.factoryAnnotation.getIndices();
            int n = 0;
            while (iterator.hasNext()) {
                Object object;
                Object[] objectArray = iterator.next();
                ConstructorOrMethod constructorOrMethod = this.getConstructorOrMethod();
                if (constructorOrMethod.getMethod() != null) {
                    object = (Object[])constructorOrMethod.getMethod().invoke(this.m_instance, objectArray);
                    if (list2 == null || list2.isEmpty()) {
                        for (Object object2 : object) {
                            list.add(object2);
                        }
                    } else {
                        for (Integer n2 : list2) {
                            int n3 = n2 - n;
                            if (n3 < 0 || n3 >= ((Object[])object).length) continue;
                            list.add(object[n3]);
                        }
                    }
                    n += ((Object[])object).length;
                    continue;
                }
                if (list2 == null || list2.isEmpty() || list2.contains(n)) {
                    if (this.objectFactory instanceof IObjectFactory) {
                        object = ((IObjectFactory)this.objectFactory).newInstance(constructorOrMethod.getConstructor(), objectArray);
                    } else if (this.objectFactory instanceof IObjectFactory2) {
                        object = ((IObjectFactory2)this.objectFactory).newInstance(constructorOrMethod.getDeclaringClass());
                    } else {
                        throw new IllegalStateException("Unsupported ITestObjectFactory " + this.objectFactory.getClass());
                    }
                    list.add(object);
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            ConstructorOrMethod constructorOrMethod = this.getConstructorOrMethod();
            throw new TestNGException("The factory method " + constructorOrMethod.getDeclaringClass() + "." + constructorOrMethod.getName() + "() threw an exception", throwable);
        }
        return list.toArray(new Object[list.size()]);
    }

    @Override
    public ITestNGMethod clone() {
        throw new IllegalStateException("clone is not supported for FactoryMethod");
    }
}

