/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.Graph;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodInheritance;
import org.testng.internal.RunInfo;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.Pair;

public class MethodHelper {
    private static final Map<ITestNGMethod[], Graph<ITestNGMethod>> GRAPH_CACHE = new ConcurrentHashMap<ITestNGMethod[], Graph<ITestNGMethod>>();
    private static final Map<Method, String> CANONICAL_NAME_CACHE = new ConcurrentHashMap<Method, String>();
    private static final Map<Pair<String, String>, Boolean> MATCH_CACHE = new ConcurrentHashMap<Pair<String, String>, Boolean>();

    public static ITestNGMethod[] collectAndOrderMethods(List<ITestNGMethod> list, boolean bl, RunInfo runInfo, IAnnotationFinder iAnnotationFinder, boolean bl2, List<ITestNGMethod> list2) {
        List<ITestNGMethod> list3 = Lists.newArrayList();
        MethodGroupsHelper.collectMethodsByGroup(list.toArray(new ITestNGMethod[list.size()]), bl, list3, list2, runInfo, iAnnotationFinder, bl2);
        return MethodHelper.sortMethods(bl, list3, iAnnotationFinder).toArray(new ITestNGMethod[0]);
    }

    protected static ITestNGMethod[] findDependedUponMethods(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        String string = MethodHelper.calculateMethodCanonicalName(iTestNGMethod);
        List list = Lists.newArrayList();
        String string2 = null;
        for (String string3 : iTestNGMethod.getMethodsDependedUpon()) {
            boolean bl = false;
            if (null != string3) {
                string2 = string3.replace("$", "\\$");
                boolean bl2 = string2.indexOf(46) != -1;
                Pattern pattern = Pattern.compile(string2);
                for (ITestNGMethod iTestNGMethod2 : iTestNGMethodArray) {
                    ConstructorOrMethod constructorOrMethod = iTestNGMethod2.getConstructorOrMethod();
                    String string4 = constructorOrMethod.getName();
                    String string5 = bl2 ? MethodHelper.calculateMethodCanonicalName(iTestNGMethod2) : string4;
                    Pair<String, String> pair = Pair.create(string2, string5);
                    Boolean bl3 = MATCH_CACHE.get(pair);
                    if (bl3 == null) {
                        bl3 = pattern.matcher(string5).matches();
                        MATCH_CACHE.put(pair, bl3);
                    }
                    if (!bl3.booleanValue()) continue;
                    list.add(iTestNGMethod2);
                    bl = true;
                }
            }
            if (bl || iTestNGMethod.ignoreMissingDependencies() || iTestNGMethod.isAlwaysRun()) continue;
            Method method = MethodHelper.findMethodByName(iTestNGMethod, string2);
            if (method != null) {
                throw new TestNGException(string + "() is depending on method " + method + ", which is not annotated with @Test or not included.");
            }
            throw new TestNGException(string + "() depends on nonexistent method " + string2);
        }
        return list.toArray(new ITestNGMethod[list.size()]);
    }

    private static Method findMethodByName(ITestNGMethod iTestNGMethod, String string) {
        String string2;
        String string3;
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            string3 = iTestNGMethod.getConstructorOrMethod().getDeclaringClass().getCanonicalName();
            string2 = string;
        } else {
            string2 = string.substring(n + 1);
            string3 = string.substring(0, n);
        }
        try {
            Class<?> clazz = Class.forName(string3);
            for (Method method : clazz.getDeclaredMethods()) {
                if (!string2.equals(method.getName())) continue;
                return method;
            }
        }
        catch (Exception exception) {
            Utils.log("MethodHelper", 3, "Caught exception while searching for methods using regex");
        }
        return null;
    }

    protected static boolean isEnabled(Class<?> clazz, IAnnotationFinder iAnnotationFinder) {
        ITestAnnotation iTestAnnotation = AnnotationHelper.findTest(iAnnotationFinder, clazz);
        return MethodHelper.isEnabled(iTestAnnotation);
    }

    protected static boolean isEnabled(Method method, IAnnotationFinder iAnnotationFinder) {
        ITestAnnotation iTestAnnotation = AnnotationHelper.findTest(iAnnotationFinder, method);
        if (null == iTestAnnotation) {
            iTestAnnotation = AnnotationHelper.findTest(iAnnotationFinder, method.getDeclaringClass());
        }
        return MethodHelper.isEnabled(iTestAnnotation);
    }

    protected static boolean isEnabled(ITestOrConfiguration iTestOrConfiguration) {
        return null == iTestOrConfiguration || iTestOrConfiguration.getEnabled();
    }

    public static List<ITestNGMethod> uniqueMethodList(Collection<List<ITestNGMethod>> collection) {
        Set set = Sets.newHashSet();
        for (List<ITestNGMethod> list : collection) {
            set.addAll(list);
        }
        return Lists.newArrayList(set);
    }

    private static Graph<ITestNGMethod> topologicalSort(ITestNGMethod[] iTestNGMethodArray, List<ITestNGMethod> list, List<ITestNGMethod> list2) {
        Graph<ITestNGMethod> graph = new Graph<ITestNGMethod>();
        if (iTestNGMethodArray.length == 0) {
            return graph;
        }
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            ITestNGMethod[] iTestNGMethodArray2;
            graph.addNode(iTestNGMethod);
            List<ITestNGMethod[]> list3 = Lists.newArrayList();
            String[] stringArray = iTestNGMethod.getMethodsDependedUpon();
            String[] stringArray2 = iTestNGMethod.getGroupsDependedUpon();
            if (stringArray.length > 0) {
                ITestNGMethod[] iTestNGMethodArray3 = MethodHelper.findDependedUponMethods(iTestNGMethod, iTestNGMethodArray);
                Object object = iTestNGMethodArray3;
                int n = ((ITestNGMethod[])object).length;
                for (int i = 0; i < n; ++i) {
                    iTestNGMethodArray2 = object[i];
                    list3.add(iTestNGMethodArray2);
                }
            }
            if (stringArray2.length > 0) {
                for (String string : stringArray2) {
                    for (ITestNGMethod iTestNGMethod2 : iTestNGMethodArray2 = MethodGroupsHelper.findMethodsThatBelongToGroup(iTestNGMethod, iTestNGMethodArray, string)) {
                        list3.add((ITestNGMethod[])iTestNGMethod2);
                    }
                }
            }
            for (Object object : list3) {
                graph.addPredecessor(iTestNGMethod, (ITestNGMethod)object);
            }
        }
        graph.topologicalSort();
        list.addAll(graph.getStrictlySortedNodes());
        list2.addAll(graph.getIndependentNodes());
        return graph;
    }

    protected static String calculateMethodCanonicalName(ITestNGMethod iTestNGMethod) {
        return MethodHelper.calculateMethodCanonicalName(iTestNGMethod.getConstructorOrMethod().getMethod());
    }

    private static String calculateMethodCanonicalName(Method method) {
        String string = CANONICAL_NAME_CACHE.get(method);
        if (string != null) {
            return string;
        }
        String string2 = method.getDeclaringClass().getName() + "." + method.getName();
        for (Class<?> clazz = method.getDeclaringClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                if (clazz.getDeclaredMethod(method.getName(), method.getParameterTypes()) == null) continue;
                string2 = clazz.getName();
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = string2 + "." + method.getName();
        CANONICAL_NAME_CACHE.put(method, string);
        return string;
    }

    private static List<ITestNGMethod> sortMethods(boolean bl, List<ITestNGMethod> list, IAnnotationFinder iAnnotationFinder) {
        Object object;
        List<ITestNGMethod> list2 = Lists.newArrayList();
        List<ITestNGMethod> list3 = Lists.newArrayList();
        ITestNGMethod[] iTestNGMethodArray = list.toArray(new ITestNGMethod[list.size()]);
        if (!bl && iTestNGMethodArray.length > 0) {
            object = iTestNGMethodArray[0];
            boolean bl2 = object.isBeforeClassConfiguration() || object.isBeforeMethodConfiguration() || object.isBeforeSuiteConfiguration() || object.isBeforeTestConfiguration();
            MethodInheritance.fixMethodInheritance(iTestNGMethodArray, bl2);
        }
        MethodHelper.topologicalSort(iTestNGMethodArray, list2, list3);
        object = Lists.newArrayList();
        object.addAll(list2);
        object.addAll(list3);
        return object;
    }

    public static List<ITestNGMethod> getMethodsDependedUpon(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        List<ITestNGMethod> list;
        Graph<ITestNGMethod> graph = GRAPH_CACHE.get(iTestNGMethodArray);
        if (graph == null) {
            list = Lists.newArrayList();
            List<ITestNGMethod> list2 = Lists.newArrayList();
            graph = MethodHelper.topologicalSort(iTestNGMethodArray, list2, list);
            GRAPH_CACHE.put(iTestNGMethodArray, graph);
        }
        list = graph.findPredecessors(iTestNGMethod);
        return list;
    }

    protected static String calculateMethodCanonicalName(Class<?> clazz, String string) {
        Set<Method> set = ClassHelper.getAvailableMethods(clazz);
        Method method = null;
        for (Method method2 : set) {
            if (!string.equals(method2.getName())) continue;
            method = method2;
            break;
        }
        return method != null ? MethodHelper.calculateMethodCanonicalName(method) : null;
    }

    protected static long calculateTimeOut(ITestNGMethod iTestNGMethod) {
        long l = iTestNGMethod.getTimeOut() > 0L ? iTestNGMethod.getTimeOut() : iTestNGMethod.getInvocationTimeOut();
        return l;
    }
}

