/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.MethodHelper;
import org.testng.internal.RunInfo;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlTest;

public class TestNGMethodFinder
implements ITestMethodFinder {
    private static final int BEFORE_SUITE = 1;
    private static final int AFTER_SUITE = 2;
    private static final int BEFORE_TEST = 3;
    private static final int AFTER_TEST = 4;
    private static final int BEFORE_CLASS = 5;
    private static final int AFTER_CLASS = 6;
    private static final int BEFORE_TEST_METHOD = 7;
    private static final int AFTER_TEST_METHOD = 8;
    private static final int BEFORE_GROUPS = 9;
    private static final int AFTER_GROUPS = 10;
    private RunInfo runInfo = null;
    private IAnnotationFinder annotationFinder = null;

    public TestNGMethodFinder(RunInfo runInfo, IAnnotationFinder iAnnotationFinder) {
        this.runInfo = runInfo;
        this.annotationFinder = iAnnotationFinder;
    }

    @Override
    public ITestNGMethod[] getTestMethods(Class<?> clazz, XmlTest xmlTest) {
        return AnnotationHelper.findMethodsWithAnnotation(clazz, ITestAnnotation.class, this.annotationFinder, xmlTest);
    }

    public ITestNGMethod[] getBeforeClassMethods(Class clazz) {
        return this.findConfiguration(clazz, 5);
    }

    public ITestNGMethod[] getAfterClassMethods(Class clazz) {
        return this.findConfiguration(clazz, 6);
    }

    public ITestNGMethod[] getBeforeTestMethods(Class clazz) {
        return this.findConfiguration(clazz, 7);
    }

    public ITestNGMethod[] getAfterTestMethods(Class clazz) {
        return this.findConfiguration(clazz, 8);
    }

    public ITestNGMethod[] getBeforeSuiteMethods(Class clazz) {
        return this.findConfiguration(clazz, 1);
    }

    public ITestNGMethod[] getAfterSuiteMethods(Class clazz) {
        return this.findConfiguration(clazz, 2);
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods(Class clazz) {
        return this.findConfiguration(clazz, 3);
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods(Class clazz) {
        return this.findConfiguration(clazz, 4);
    }

    public ITestNGMethod[] getBeforeGroupsConfigurationMethods(Class clazz) {
        return this.findConfiguration(clazz, 9);
    }

    public ITestNGMethod[] getAfterGroupsConfigurationMethods(Class clazz) {
        return this.findConfiguration(clazz, 10);
    }

    private ITestNGMethod[] findConfiguration(Class clazz, int n) {
        List<ITestNGMethod> list = Lists.newArrayList();
        Set<Method> set = ClassHelper.getAvailableMethods(clazz);
        for (Method method : set) {
            boolean bl;
            IConfigurationAnnotation iConfigurationAnnotation = AnnotationHelper.findConfiguration(this.annotationFinder, method);
            if (null == iConfigurationAnnotation) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            String[] stringArray = null;
            String[] stringArray2 = null;
            switch (n) {
                case 1: {
                    bl = iConfigurationAnnotation.getBeforeSuite();
                    bl2 = true;
                    break;
                }
                case 2: {
                    bl = iConfigurationAnnotation.getAfterSuite();
                    bl3 = true;
                    break;
                }
                case 3: {
                    bl = iConfigurationAnnotation.getBeforeTest();
                    bl4 = true;
                    break;
                }
                case 4: {
                    bl = iConfigurationAnnotation.getAfterTest();
                    bl5 = true;
                    break;
                }
                case 5: {
                    bl = iConfigurationAnnotation.getBeforeTestClass();
                    bl6 = true;
                    break;
                }
                case 6: {
                    bl = iConfigurationAnnotation.getAfterTestClass();
                    bl7 = true;
                    break;
                }
                case 7: {
                    bl = iConfigurationAnnotation.getBeforeTestMethod();
                    bl8 = true;
                    break;
                }
                case 8: {
                    bl = iConfigurationAnnotation.getAfterTestMethod();
                    bl9 = true;
                    break;
                }
                case 9: {
                    stringArray = iConfigurationAnnotation.getBeforeGroups();
                    bl = stringArray.length > 0;
                    bl8 = true;
                    break;
                }
                case 10: {
                    stringArray2 = iConfigurationAnnotation.getAfterGroups();
                    bl = stringArray2.length > 0;
                    bl8 = true;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected value: " + n));
                }
            }
            if (!bl) continue;
            this.addConfigurationMethod(clazz, list, method, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, stringArray, stringArray2, null);
        }
        List list2 = Lists.newArrayList();
        boolean bl = n == 1 || n == 2;
        return MethodHelper.collectAndOrderMethods(Lists.newArrayList(list), false, this.runInfo, this.annotationFinder, bl, list2);
    }

    private void addConfigurationMethod(Class<?> clazz, List<ITestNGMethod> list, Method method, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, String[] stringArray, String[] stringArray2, Object object) {
        if (method.getDeclaringClass().isAssignableFrom(clazz)) {
            ConfigurationMethod configurationMethod = new ConfigurationMethod(new ConstructorOrMethod(method), this.annotationFinder, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, stringArray, stringArray2, object);
            list.add(configurationMethod);
        }
    }
}

