/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.internal.thread.ExecutorAdapter;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IThreadFactory;
import org.testng.internal.thread.TestNGThreadFactory;

public class ThreadUtil {
    public static final String THREAD_NAME = "TestNG";

    public static boolean isTestNGThread() {
        return Thread.currentThread().getName().contains(THREAD_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String string, List<? extends Runnable> list, int n, long l, boolean bl) {
        Utils.log("ThreadUtil", 2, "Starting executor timeOut:" + l + "ms workers:" + list.size() + " threadPoolSize:" + n);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n, l, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new TestNGThreadFactory(string));
        List list2 = Lists.newArrayList();
        for (final Runnable runnable : list) {
            list2.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    runnable.run();
                    return null;
                }
            });
        }
        try {
            if (l != 0L) {
                threadPoolExecutor.invokeAll(list2, l, TimeUnit.MILLISECONDS);
            } else {
                threadPoolExecutor.invokeAll(list2);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            Thread.currentThread().interrupt();
        }
        finally {
            threadPoolExecutor.shutdown();
        }
    }

    public static String currentThreadInfo() {
        Thread thread = Thread.currentThread();
        return String.valueOf(thread.getName() + "@" + thread.hashCode());
    }

    public static IExecutor createExecutor(int n, String string) {
        return new ExecutorAdapter(n, ThreadUtil.createFactory(string));
    }

    private static IThreadFactory createFactory(String string) {
        return new ThreadFactoryImpl(string);
    }

    public static class ThreadFactoryImpl
    extends TestNGThreadFactory
    implements IThreadFactory {
        private final List<Thread> threads = Lists.newArrayList();

        public ThreadFactoryImpl(String string) {
            super("method=" + string);
        }

        @Override
        public Object getThreadFactory() {
            return this;
        }

        @Override
        public List<Thread> getThreads() {
            return this.threads;
        }
    }
}

