/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.xml.IFileParser;
import org.testng.xml.IPostProcessor;
import org.testng.xml.ISuiteParser;
import org.testng.xml.SuiteXmlParser;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;

public class Parser {
    public static final String TESTNG_DTD = "testng-1.0.dtd";
    public static final String DEPRECATED_TESTNG_DTD_URL = "http://beust.com/testng/testng-1.0.dtd";
    public static final String TESTNG_DTD_URL = "http://testng.org/testng-1.0.dtd";
    public static final String DEFAULT_FILENAME = "testng.xml";
    private static final ISuiteParser DEFAULT_FILE_PARSER = new SuiteXmlParser();
    private static final List<ISuiteParser> PARSERS = Lists.newArrayList(DEFAULT_FILE_PARSER);
    private String m_fileName;
    private InputStream m_inputStream;
    private IPostProcessor m_postProcessor;
    private boolean m_loadClasses = true;

    public Parser(String string) {
        this.init(string, null, null);
    }

    public Parser() throws FileNotFoundException {
        this.init(null, null, null);
    }

    public Parser(InputStream inputStream) {
        this.init(null, inputStream, null);
    }

    private void init(String string, InputStream inputStream, IFileParser iFileParser) {
        this.m_fileName = string != null ? string : DEFAULT_FILENAME;
        this.m_inputStream = inputStream;
    }

    public void setPostProcessor(IPostProcessor iPostProcessor) {
        this.m_postProcessor = iPostProcessor;
    }

    public void setLoadClasses(boolean bl) {
        this.m_loadClasses = bl;
    }

    private static IFileParser getParser(String string) {
        for (ISuiteParser iSuiteParser : PARSERS) {
            if (!iSuiteParser.accept(string)) continue;
            return iSuiteParser;
        }
        return DEFAULT_FILE_PARSER;
    }

    public Collection<XmlSuite> parse() throws IOException {
        Object object;
        List list = Lists.newArrayList();
        XmlSuite xmlSuite = null;
        List<String> list2 = Lists.newArrayList();
        List<String> list3 = Lists.newArrayList();
        List<String> list4 = Lists.newArrayList();
        if (this.m_fileName != null) {
            object = new File(this.m_fileName);
            list2.add(((File)object).getCanonicalPath());
        }
        object = Maps.newHashMap();
        while (list2.size() > 0) {
            for (String string : list2) {
                Object object2;
                File file = new File(string);
                File file2 = file.getParentFile();
                InputStream inputStream = this.m_inputStream != null ? this.m_inputStream : new FileInputStream(string);
                IFileParser iFileParser = Parser.getParser(string);
                XmlSuite xmlSuite2 = (XmlSuite)iFileParser.parse(string, inputStream, this.m_loadClasses);
                list.add(string);
                list4.add(string);
                if (object.containsKey(string)) {
                    object2 = (XmlSuite)object.get(string);
                    xmlSuite2.setParentSuite((XmlSuite)object2);
                    ((XmlSuite)object2).getChildSuites().add(xmlSuite2);
                }
                if (null == xmlSuite) {
                    xmlSuite = xmlSuite2;
                }
                if ((object2 = xmlSuite2.getSuiteFiles()).size() <= 0) continue;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    String string3 = file2 != null && new File(file2, string2).exists() ? new File(file2, string2).getCanonicalPath() : new File(string2).getCanonicalPath();
                    if (list.contains(string3)) continue;
                    list3.add(string3);
                    object.put(string3, xmlSuite2);
                }
            }
            for (String string : list4) {
                list2.remove(string);
            }
            list4 = Lists.newArrayList();
            for (String string : list3) {
                list2.add(string);
            }
            list3 = Lists.newArrayList();
        }
        Iterator<String> iterator = Lists.newArrayList();
        iterator.add((String)((Object)xmlSuite));
        boolean bl = true;
        if (bl && this.m_postProcessor != null) {
            return this.m_postProcessor.process((Collection<XmlSuite>)((Object)iterator));
        }
        return iterator;
    }

    public List<XmlSuite> parseToList() throws ParserConfigurationException, SAXException, IOException {
        List<XmlSuite> list = Lists.newArrayList();
        Collection<XmlSuite> collection = this.parse();
        for (XmlSuite xmlSuite : collection) {
            list.add(xmlSuite);
        }
        return list;
    }

    static {
        ServiceLoader<ISuiteParser> serviceLoader = ServiceLoader.load(ISuiteParser.class);
        for (ISuiteParser iSuiteParser : serviceLoader) {
            PARSERS.add(iSuiteParser);
        }
    }
}

