/*
 * Decompiled with CFR 0.152.
 */
package org.testng.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.Maps;

public abstract class MultiMap<K, V, C extends Collection<V>> {
    protected final Map<K, C> m_objects = Maps.newHashMap();

    protected abstract C createValue();

    public boolean put(K key, V method) {
        boolean setExists = true;
        Collection<Object> l = (Collection)this.m_objects.get(key);
        if (l == null) {
            setExists = false;
            l = this.createValue();
            this.m_objects.put(key, l);
        }
        return l.add(method) && setExists;
    }

    public C get(K key) {
        return (C)((Collection)this.m_objects.get(key));
    }

    @Deprecated
    public List<K> getKeys() {
        return new ArrayList<K>(this.keySet());
    }

    public Set<K> keySet() {
        return new HashSet<K>(this.m_objects.keySet());
    }

    public boolean containsKey(K k) {
        return this.m_objects.containsKey(k);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Set<K> indices = this.keySet();
        for (K i : indices) {
            result.append("\n    ").append(i).append(" <-- ");
            for (Object o : (Collection)this.m_objects.get(i)) {
                result.append(o).append(" ");
            }
        }
        return result.toString();
    }

    public boolean isEmpty() {
        return this.m_objects.size() == 0;
    }

    @Deprecated
    public int getSize() {
        return this.size();
    }

    public int size() {
        return this.m_objects.size();
    }

    @Deprecated
    public C remove(K key) {
        return this.removeAll(key);
    }

    public boolean remove(K key, V value) {
        C values = this.get(key);
        if (values == null) {
            return false;
        }
        return values.remove(value);
    }

    public C removeAll(K key) {
        return (C)((Collection)this.m_objects.remove(key));
    }

    @Deprecated
    public Set<Map.Entry<K, C>> getEntrySet() {
        return this.entrySet();
    }

    public Set<Map.Entry<K, C>> entrySet() {
        return this.m_objects.entrySet();
    }

    @Deprecated
    public Collection<C> getValues() {
        return this.values();
    }

    public Collection<C> values() {
        return this.m_objects.values();
    }

    public boolean putAll(K k, Collection<? extends V> values) {
        boolean result = false;
        for (V v : values) {
            result = this.put(k, v) || result;
        }
        return result;
    }
}

