/*
 * Decompiled with CFR 0.152.
 */
package org.testng.asserts;

import java.util.Map;
import org.testng.asserts.Assertion;
import org.testng.asserts.IAssert;
import org.testng.collections.Maps;

public class SoftAssert
extends Assertion {
    private Map<AssertionError, IAssert<?>> m_errors = Maps.newLinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAssert(IAssert<?> a) {
        this.onBeforeAssert(a);
        try {
            a.doAssert();
            this.onAssertSuccess(a);
        }
        catch (AssertionError ex) {
            this.onAssertFailure(a, ex);
            this.m_errors.put(ex, a);
        }
        finally {
            this.onAfterAssert(a);
        }
    }

    public void assertAll() {
        if (!this.m_errors.isEmpty()) {
            StringBuilder sb = new StringBuilder("The following asserts failed:");
            boolean first = true;
            for (Map.Entry<AssertionError, IAssert<?>> ae : this.m_errors.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("\n\t");
                String message = ae.getValue().getMessage();
                if (message != null) {
                    sb.append(message).append("\t");
                }
                sb.append(((Throwable)((Object)ae.getKey())).getMessage());
            }
            throw new AssertionError((Object)sb.toString());
        }
    }
}

