/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.ArrayIterator;
import org.testng.internal.ClassHelper;
import org.testng.internal.Graph;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodInheritance;
import org.testng.internal.RunInfo;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.Pair;

public class MethodHelper {
    private static final Map<ITestNGMethod[], Graph<ITestNGMethod>> GRAPH_CACHE = new ConcurrentHashMap<ITestNGMethod[], Graph<ITestNGMethod>>();
    private static final Map<Method, String> CANONICAL_NAME_CACHE = new ConcurrentHashMap<Method, String>();
    private static final Map<Pair<String, String>, Boolean> MATCH_CACHE = new ConcurrentHashMap<Pair<String, String>, Boolean>();

    public static ITestNGMethod[] collectAndOrderMethods(List<ITestNGMethod> methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder, boolean unique, List<ITestNGMethod> outExcludedMethods) {
        List<ITestNGMethod> includedMethods = Lists.newArrayList();
        MethodGroupsHelper.collectMethodsByGroup(methods.toArray(new ITestNGMethod[methods.size()]), forTests, includedMethods, outExcludedMethods, runInfo, finder, unique);
        return MethodHelper.sortMethods(forTests, includedMethods, finder).toArray(new ITestNGMethod[0]);
    }

    protected static ITestNGMethod[] findDependedUponMethods(ITestNGMethod m, ITestNGMethod[] methods) {
        String canonicalMethodName = MethodHelper.calculateMethodCanonicalName(m);
        List vResult = Lists.newArrayList();
        String regexp = null;
        for (String fullyQualifiedRegexp : m.getMethodsDependedUpon()) {
            boolean foundAtLeastAMethod = false;
            if (null != fullyQualifiedRegexp) {
                regexp = fullyQualifiedRegexp.replace("$", "\\$");
                boolean usePackage = regexp.indexOf(46) != -1;
                Pattern pattern = Pattern.compile(regexp);
                for (ITestNGMethod method : methods) {
                    Method thisMethod = method.getMethod();
                    String thisMethodName = thisMethod.getName();
                    String methodName = usePackage ? MethodHelper.calculateMethodCanonicalName(thisMethod) : thisMethodName;
                    Pair<String, String> cacheKey = Pair.create(regexp, methodName);
                    Boolean match = MATCH_CACHE.get(cacheKey);
                    if (match == null) {
                        match = pattern.matcher(methodName).matches();
                        MATCH_CACHE.put(cacheKey, match);
                    }
                    if (!match.booleanValue()) continue;
                    vResult.add(method);
                    foundAtLeastAMethod = true;
                }
            }
            if (foundAtLeastAMethod || m.ignoreMissingDependencies() || m.isAlwaysRun()) continue;
            Method maybeReferringTo = MethodHelper.findMethodByName(m, regexp);
            if (maybeReferringTo != null) {
                throw new TestNGException(canonicalMethodName + "() is depending on method " + maybeReferringTo + ", which is not annotated with @Test or not included.");
            }
            throw new TestNGException(canonicalMethodName + "() depends on nonexistent method " + regexp);
        }
        return vResult.toArray(new ITestNGMethod[vResult.size()]);
    }

    private static Method findMethodByName(ITestNGMethod testngMethod, String regExp) {
        String methodName;
        String className;
        if (regExp == null) {
            return null;
        }
        int lastDot = regExp.lastIndexOf(46);
        if (lastDot == -1) {
            className = testngMethod.getMethod().getDeclaringClass().getCanonicalName();
            methodName = regExp;
        } else {
            methodName = regExp.substring(lastDot + 1);
            className = regExp.substring(0, lastDot);
        }
        try {
            Class<?> c = Class.forName(className);
            for (Method m : c.getDeclaredMethods()) {
                if (!methodName.equals(m.getName())) continue;
                return m;
            }
        }
        catch (Exception e) {
            Utils.log("MethodHelper", 3, "Caught exception while searching for methods using regex");
        }
        return null;
    }

    protected static boolean isEnabled(Class<?> objectClass, IAnnotationFinder finder) {
        ITestAnnotation testClassAnnotation = AnnotationHelper.findTest(finder, objectClass);
        return MethodHelper.isEnabled(testClassAnnotation);
    }

    protected static boolean isEnabled(Method m, IAnnotationFinder finder) {
        ITestAnnotation annotation = AnnotationHelper.findTest(finder, m);
        if (null == annotation) {
            annotation = AnnotationHelper.findTest(finder, m.getDeclaringClass());
        }
        return MethodHelper.isEnabled(annotation);
    }

    protected static boolean isEnabled(ITestOrConfiguration test) {
        return null == test || test.getEnabled();
    }

    public static List<ITestNGMethod> uniqueMethodList(Collection<List<ITestNGMethod>> methods) {
        Set resultSet = Sets.newHashSet();
        for (List<ITestNGMethod> l : methods) {
            resultSet.addAll(l);
        }
        return Lists.newArrayList(resultSet);
    }

    private static Graph<ITestNGMethod> topologicalSort(ITestNGMethod[] methods, List<ITestNGMethod> sequentialList, List<ITestNGMethod> parallelList) {
        Graph<ITestNGMethod> result = new Graph<ITestNGMethod>();
        if (methods.length == 0) {
            return result;
        }
        for (ITestNGMethod m : methods) {
            result.addNode(m);
            List<ITestNGMethod> predecessors = Lists.newArrayList();
            String[] methodsDependedUpon = m.getMethodsDependedUpon();
            String[] groupsDependedUpon = m.getGroupsDependedUpon();
            if (methodsDependedUpon.length > 0) {
                ITestNGMethod[] methodsNamed;
                for (ITestNGMethod pred : methodsNamed = MethodHelper.findDependedUponMethods(m, methods)) {
                    predecessors.add(pred);
                }
            }
            if (groupsDependedUpon.length > 0) {
                for (String group : groupsDependedUpon) {
                    ITestNGMethod[] methodsThatBelongToGroup;
                    for (ITestNGMethod pred : methodsThatBelongToGroup = MethodGroupsHelper.findMethodsThatBelongToGroup(m, methods, group)) {
                        predecessors.add(pred);
                    }
                }
            }
            for (ITestNGMethod predecessor : predecessors) {
                result.addPredecessor(m, predecessor);
            }
        }
        result.topologicalSort();
        sequentialList.addAll(result.getStrictlySortedNodes());
        parallelList.addAll(result.getIndependentNodes());
        return result;
    }

    protected static String calculateMethodCanonicalName(ITestNGMethod m) {
        return MethodHelper.calculateMethodCanonicalName(m.getMethod());
    }

    private static String calculateMethodCanonicalName(Method m) {
        String result = CANONICAL_NAME_CACHE.get(m);
        if (result != null) {
            return result;
        }
        String packageName = m.getDeclaringClass().getName() + "." + m.getName();
        for (Class<?> cls = m.getDeclaringClass(); cls != Object.class; cls = cls.getSuperclass()) {
            try {
                if (cls.getDeclaredMethod(m.getName(), m.getParameterTypes()) == null) continue;
                packageName = cls.getName();
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        result = packageName + "." + m.getName();
        CANONICAL_NAME_CACHE.put(m, result);
        return result;
    }

    private static List<ITestNGMethod> sortMethods(boolean forTests, List<ITestNGMethod> allMethods, IAnnotationFinder finder) {
        List<ITestNGMethod> sl = Lists.newArrayList();
        List<ITestNGMethod> pl = Lists.newArrayList();
        ITestNGMethod[] allMethodsArray = allMethods.toArray(new ITestNGMethod[allMethods.size()]);
        if (!forTests && allMethodsArray.length > 0) {
            ITestNGMethod m = allMethodsArray[0];
            boolean before = m.isBeforeClassConfiguration() || m.isBeforeMethodConfiguration() || m.isBeforeSuiteConfiguration() || m.isBeforeTestConfiguration();
            MethodInheritance.fixMethodInheritance(allMethodsArray, before);
        }
        MethodHelper.topologicalSort(allMethodsArray, sl, pl);
        List<ITestNGMethod> result = Lists.newArrayList();
        result.addAll(sl);
        result.addAll(pl);
        return result;
    }

    public static List<ITestNGMethod> getMethodsDependedUpon(ITestNGMethod method, ITestNGMethod[] methods) {
        Graph<ITestNGMethod> g = GRAPH_CACHE.get(methods);
        if (g == null) {
            List<ITestNGMethod> parallelList = Lists.newArrayList();
            List<ITestNGMethod> sequentialList = Lists.newArrayList();
            g = MethodHelper.topologicalSort(methods, sequentialList, parallelList);
            GRAPH_CACHE.put(methods, g);
        }
        List<ITestNGMethod> result = g.findPredecessors(method);
        return result;
    }

    protected static Iterator<Object[]> createArrayIterator(Object[][] objects) {
        ArrayIterator result = new ArrayIterator(objects);
        return result;
    }

    protected static String calculateMethodCanonicalName(Class<?> methodClass, String methodName) {
        Set<Method> methods = ClassHelper.getAvailableMethods(methodClass);
        Method result = null;
        for (Method m : methods) {
            if (!methodName.equals(m.getName())) continue;
            result = m;
            break;
        }
        return result != null ? MethodHelper.calculateMethodCanonicalName(result) : null;
    }

    protected static long calculateTimeOut(ITestNGMethod tm) {
        long result = tm.getTimeOut() > 0L ? tm.getTimeOut() : tm.getInvocationTimeOut();
        return result;
    }
}

