/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;
import org.testng.remote.RemoteTestNG;
import org.testng.reporters.XMLStringBuffer;

public abstract class LaunchSuite {
    private static final Logger LOGGER = Logger.getLogger(LaunchSuite.class);
    protected boolean m_temporary;

    protected LaunchSuite(boolean isTemp) {
        this.m_temporary = isTemp;
    }

    public boolean isTemporary() {
        return this.m_temporary;
    }

    public abstract File save(File var1);

    public abstract XMLStringBuffer getSuiteBuffer();

    static class ClassListSuite
    extends CustomizedSuite {
        protected Collection<String> m_packageNames;
        protected Collection<String> m_classNames;
        protected Collection<String> m_groupNames;
        protected int m_logLevel;

        ClassListSuite(String projectName, Collection<String> packageNames, Collection<String> classNames, Collection<String> groupNames, Map<String, String> parameters, String annotationType, int logLevel) {
            super(projectName, "Custom suite", parameters, annotationType);
            this.m_packageNames = packageNames;
            this.m_classNames = classNames;
            this.m_groupNames = groupNames;
            this.m_logLevel = logLevel;
        }

        @Override
        protected void initContentBuffer(XMLStringBuffer suiteBuffer) {
            Properties testAttrs = new Properties();
            testAttrs.setProperty("name", this.m_projectName);
            testAttrs.setProperty("verbose", String.valueOf(this.m_logLevel));
            suiteBuffer.push("test", testAttrs);
            if (null != this.m_groupNames) {
                suiteBuffer.push("groups");
                suiteBuffer.push("run");
                for (String groupName : this.m_groupNames) {
                    Properties includeAttrs = new Properties();
                    includeAttrs.setProperty("name", groupName);
                    suiteBuffer.addEmptyElement("include", includeAttrs);
                }
                suiteBuffer.pop("run");
                suiteBuffer.pop("groups");
            }
            if (this.m_packageNames != null && this.m_packageNames.size() > 0) {
                suiteBuffer.push("packages");
                for (String packageName : this.m_packageNames) {
                    Properties packageAttrs = new Properties();
                    packageAttrs.setProperty("name", packageName);
                    suiteBuffer.addEmptyElement("package", packageAttrs);
                }
                suiteBuffer.pop("packages");
            }
            if (this.m_classNames != null && this.m_classNames.size() > 0) {
                suiteBuffer.push("classes");
                for (String className : this.m_classNames) {
                    Properties classAttrs = new Properties();
                    classAttrs.setProperty("name", className);
                    suiteBuffer.addEmptyElement("class", classAttrs);
                }
                suiteBuffer.pop("classes");
            }
            suiteBuffer.pop("test");
        }
    }

    static class ClassesAndMethodsSuite
    extends CustomizedSuite {
        protected Map<String, Collection<String>> m_classes;
        protected int m_logLevel;

        ClassesAndMethodsSuite(String projectName, Map<String, Collection<String>> classes, Map<String, String> parameters, String annotationType, int logLevel) {
            super(projectName, "Custom suite", parameters, annotationType);
            this.m_classes = classes;
            this.m_logLevel = logLevel;
        }

        @Override
        protected void initContentBuffer(XMLStringBuffer suiteBuffer) {
            Properties testAttrs = new Properties();
            testAttrs.setProperty("name", this.m_projectName);
            testAttrs.setProperty("verbose", String.valueOf(this.m_logLevel));
            suiteBuffer.push("test", testAttrs);
            suiteBuffer.push("classes");
            for (Map.Entry<String, Collection<String>> entry : this.m_classes.entrySet()) {
                Properties classAttrs = new Properties();
                classAttrs.setProperty("name", entry.getKey());
                Collection<String> methodNames = this.sanitize(entry.getValue());
                if (null != methodNames && methodNames.size() > 0) {
                    suiteBuffer.push("class", classAttrs);
                    suiteBuffer.push("methods");
                    for (String methodName : methodNames) {
                        Properties methodAttrs = new Properties();
                        methodAttrs.setProperty("name", methodName);
                        suiteBuffer.addEmptyElement("include", methodAttrs);
                    }
                    suiteBuffer.pop("methods");
                    suiteBuffer.pop("class");
                    continue;
                }
                suiteBuffer.addEmptyElement("class", classAttrs);
            }
            suiteBuffer.pop("classes");
            suiteBuffer.pop("test");
        }

        private Collection<String> sanitize(Collection<String> source) {
            if (null == source) {
                return null;
            }
            List<String> result = Lists.newArrayList();
            for (String name : source) {
                if (!Utils.isStringNotBlank(name)) continue;
                result.add(name);
            }
            return result;
        }
    }

    static class MethodsSuite
    extends CustomizedSuite {
        protected Collection<String> m_methodNames;
        protected String m_className;
        protected int m_logLevel;

        MethodsSuite(String projectName, String className, Collection<String> methodNames, Map<String, String> parameters, String annotationType, int logLevel) {
            super(projectName, className, parameters, annotationType);
            this.m_className = className;
            this.m_methodNames = methodNames;
            this.m_logLevel = logLevel;
        }

        @Override
        protected void initContentBuffer(XMLStringBuffer suiteBuffer) {
            Properties testAttrs = new Properties();
            testAttrs.setProperty("name", this.m_className);
            testAttrs.setProperty("verbose", String.valueOf(this.m_logLevel));
            suiteBuffer.push("test", testAttrs);
            suiteBuffer.push("classes");
            Properties classAttrs = new Properties();
            classAttrs.setProperty("name", this.m_className);
            if (null != this.m_methodNames && this.m_methodNames.size() > 0) {
                suiteBuffer.push("class", classAttrs);
                suiteBuffer.push("methods");
                for (String methodName : this.m_methodNames) {
                    Properties methodAttrs = new Properties();
                    methodAttrs.setProperty("name", methodName);
                    suiteBuffer.addEmptyElement("include", methodAttrs);
                }
                suiteBuffer.pop("methods");
                suiteBuffer.pop("class");
            } else {
                suiteBuffer.addEmptyElement("class", classAttrs);
            }
            suiteBuffer.pop("classes");
            suiteBuffer.pop("test");
        }
    }

    private static abstract class CustomizedSuite
    extends LaunchSuite {
        protected String m_projectName;
        protected String m_suiteName;
        protected Map<String, String> m_parameters;
        private XMLStringBuffer m_suiteBuffer;

        private CustomizedSuite(String projectName, String className, Map<String, String> parameters, String annotationType) {
            super(true);
            this.m_projectName = projectName;
            this.m_suiteName = className;
            this.m_parameters = parameters;
        }

        protected XMLStringBuffer createContentBuffer() {
            XMLStringBuffer suiteBuffer = new XMLStringBuffer();
            suiteBuffer.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
            Properties attrs = new Properties();
            attrs.setProperty("parallel", "none");
            attrs.setProperty("name", this.m_suiteName);
            suiteBuffer.push("suite", attrs);
            if (this.m_parameters != null) {
                for (Map.Entry<String, String> entry : this.m_parameters.entrySet()) {
                    Properties paramAttrs = new Properties();
                    paramAttrs.setProperty("name", entry.getKey());
                    paramAttrs.setProperty("value", entry.getValue());
                    suiteBuffer.push("parameter", paramAttrs);
                    suiteBuffer.pop("parameter");
                }
            }
            this.initContentBuffer(suiteBuffer);
            suiteBuffer.pop("suite");
            return suiteBuffer;
        }

        @Override
        public XMLStringBuffer getSuiteBuffer() {
            if (null == this.m_suiteBuffer) {
                this.m_suiteBuffer = this.createContentBuffer();
            }
            return this.m_suiteBuffer;
        }

        protected abstract void initContentBuffer(XMLStringBuffer var1);

        @Override
        public File save(File directory) {
            File suiteFile = new File(directory, "temp-testng-customsuite.xml");
            this.saveSuiteContent(suiteFile, this.getSuiteBuffer());
            return suiteFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveSuiteContent(File file, XMLStringBuffer content) {
            try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8"));){
                fw.write(content.getStringBuffer().toString());
            }
            catch (IOException ioe) {
                LOGGER.error("IO Exception", ioe);
            }
        }
    }

    public static class ExistingSuite
    extends LaunchSuite {
        private File m_suitePath;

        public ExistingSuite(File path) {
            super(false);
            this.m_suitePath = path;
        }

        @Override
        public XMLStringBuffer getSuiteBuffer() {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        @Override
        public File save(File directory) {
            if (RemoteTestNG.isDebug()) {
                File result = new File(directory, "testng-customsuite.xml");
                Utils.copyFile(this.m_suitePath, result);
                return result;
            }
            return this.m_suitePath;
        }
    }
}

