/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.descriptors;

import org.vafer.jdeb.changes.ChangeSet;
import org.vafer.jdeb.descriptors.AbstractDescriptor;

public final class ChangesDescriptor
extends AbstractDescriptor {
    private static final String[] KEYS = new String[]{"Format", "Date", "Source", "Binary", "Architecture", "Version", "Distribution", "Urgency", "Maintainer", "Changed-By", "Description", "Changes", "Closes", "Checksums-Sha1", "Checksums-Sha256", "Files"};
    public static final String[] MANDATORY_KEYS = new String[]{"Format", "Date", "Source", "Binary", "Architecture", "Version", "Distribution", "Urgency", "Maintainer", "Description", "Changes", "Checksums-Sha1", "Checksums-Sha256", "Files"};

    public ChangesDescriptor(AbstractDescriptor pDescriptor, ChangeSet[] changeSets) {
        super(pDescriptor);
        StringBuilder sb = new StringBuilder();
        if (changeSets.length > 0) {
            ChangeSet latestChangeSet = changeSets[0];
            this.set("Urgency", latestChangeSet.getUrgency());
            this.set("Changed-By", latestChangeSet.getChangedBy());
            for (ChangeSet changeSet : changeSets) {
                sb.append(changeSet.toString());
            }
        }
        this.set("Changes", sb.toString());
    }

    @Override
    public String[] getMandatoryKeys() {
        return MANDATORY_KEYS;
    }

    public String toString() {
        return this.toString(KEYS);
    }
}

