/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.yaml.snakeyaml.Dumper;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanDumper {
    private boolean useGlobalTag;
    private DumperOptions.FlowStyle flowStyle;
    private Set<Class<? extends Object>> classTags;

    public JavaBeanDumper(boolean useGlobalTag) {
        this.useGlobalTag = useGlobalTag;
        this.flowStyle = DumperOptions.FlowStyle.BLOCK;
        this.classTags = new HashSet<Class<? extends Object>>();
    }

    public JavaBeanDumper() {
        this(false);
    }

    public void dump(Object data, Writer output) {
        DumperOptions options = new DumperOptions();
        if (!this.useGlobalTag) {
            options.setExplicitRoot("tag:yaml.org,2002:map");
        }
        options.setDefaultFlowStyle(this.flowStyle);
        Representer representer = new Representer();
        for (Class<? extends Object> clazz : this.classTags) {
            representer.addClassTag(clazz, "tag:yaml.org,2002:map");
        }
        Dumper dumper = new Dumper(representer, options);
        ArrayList<Object> list = new ArrayList<Object>(1);
        list.add(data);
        dumper.dump(list.iterator(), output, new Resolver());
    }

    public String dump(Object data) {
        StringWriter buffer = new StringWriter();
        this.dump(data, buffer);
        return buffer.toString();
    }

    public boolean isUseGlobalTag() {
        return this.useGlobalTag;
    }

    public void setUseGlobalTag(boolean useGlobalTag) {
        this.useGlobalTag = useGlobalTag;
    }

    public DumperOptions.FlowStyle getFlowStyle() {
        return this.flowStyle;
    }

    public void setFlowStyle(DumperOptions.FlowStyle flowStyle) {
        this.flowStyle = flowStyle;
    }

    public void setMapTagForBean(Class<? extends Object> clazz) {
        this.classTags.add(clazz);
    }
}

